/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.NotImplementedException;

@InterfaceAudience.Private
public abstract class NonLazyKeyValueScanner
implements KeyValueScanner {
    @Override
    public boolean requestSeek(Cell kv, boolean forward, boolean useBloom) throws IOException {
        return NonLazyKeyValueScanner.doRealSeek(this, kv, forward);
    }

    @Override
    public boolean realSeekDone() {
        return true;
    }

    @Override
    public void enforceSeek() throws IOException {
        throw new NotImplementedException("enforceSeek must not be called on a non-lazy scanner");
    }

    public static boolean doRealSeek(KeyValueScanner scanner, Cell kv, boolean forward) throws IOException {
        return forward ? scanner.reseek(kv) : scanner.seek(kv);
    }

    @Override
    public boolean shouldUseScanner(Scan scan, Store store, long oldestUnexpiredTS) {
        return true;
    }

    @Override
    public boolean isFileScanner() {
        return false;
    }

    @Override
    public Cell getNextIndexedKey() {
        return null;
    }
}

