/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.monitoring.LogMonitoring;
import org.apache.hadoop.hbase.monitoring.StateDumpServlet;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class RSDumpServlet
extends StateDumpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "===========================================================";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HRegionServer hrs = (HRegionServer)this.getServletContext().getAttribute("regionserver");
        assert (hrs != null) : "No RS in context!";
        response.setContentType("text/plain");
        if (!hrs.isOnline()) {
            response.getWriter().write("The RegionServer is initializing!");
            response.getWriter().close();
            return;
        }
        ServletOutputStream os = response.getOutputStream();
        PrintWriter out = new PrintWriter(os);
        out.println("RegionServer status for " + hrs.getServerName() + " as of " + new Date());
        out.println("\n\nVersion Info:");
        out.println(LINE);
        this.dumpVersionInfo(out);
        out.println("\n\nTasks:");
        out.println(LINE);
        TaskMonitor.get().dumpAsText(out);
        out.println("\n\nRowLocks:");
        out.println(LINE);
        RSDumpServlet.dumpRowLock(hrs, out);
        out.println("\n\nExecutors:");
        out.println(LINE);
        this.dumpExecutors(hrs.getExecutorService(), out);
        out.println("\n\nStacks:");
        out.println(LINE);
        PrintStream ps = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");
        Threads.printThreadInfo(ps, "");
        ps.flush();
        out.println("\n\nRS Configuration:");
        out.println(LINE);
        Configuration conf = hrs.getConfiguration();
        out.flush();
        conf.writeXml(os);
        os.flush();
        out.println("\n\nLogs");
        out.println(LINE);
        long tailKb = this.getTailKbParam(request);
        LogMonitoring.dumpTailOfLogs(out, tailKb);
        out.println("\n\nRS Queue:");
        out.println(LINE);
        if (this.isShowQueueDump(conf)) {
            RSDumpServlet.dumpQueue(hrs, out);
        }
        out.flush();
    }

    public static void dumpRowLock(HRegionServer hrs, PrintWriter out) {
        StringBuilder sb = new StringBuilder();
        for (Region region : hrs.getOnlineRegions()) {
            HRegion hRegion = (HRegion)region;
            if (hRegion.getLockedRows().size() <= 0) continue;
            for (HRegion.RowLockContext rowLockContext : hRegion.getLockedRows().values()) {
                sb.setLength(0);
                sb.append(hRegion.getTableDesc().getTableName()).append(",").append(hRegion.getRegionInfo().getEncodedName()).append(",");
                sb.append(rowLockContext.toString());
                out.println(sb.toString());
            }
        }
    }

    public static void dumpQueue(HRegionServer hrs, PrintWriter out) throws IOException {
        if (hrs.compactSplitThread != null) {
            out.println("Compaction/Split Queue summary: " + hrs.compactSplitThread.toString());
            out.println(hrs.compactSplitThread.dumpQueue());
        }
        if (hrs.cacheFlusher != null) {
            out.println("\nFlush Queue summary: " + hrs.cacheFlusher.toString());
            out.println(hrs.cacheFlusher.dumpQueue());
        }
    }
}

