/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class ScanQueryMatcher {
    private boolean stickyNextRow;
    private final byte[] stopRow;
    private final TimeRange tr;
    private final Filter filter;
    private final DeleteTracker deletes;
    private boolean retainDeletesInOutput;
    private final KeepDeletedCells keepDeletedCells;
    private final boolean seePastDeleteMarkers;
    private final ColumnTracker columns;
    private final Cell startKey;
    private final KeyValue.KVComparator rowComparator;
    byte[] row;
    int rowOffset;
    short rowLength;
    private final long earliestPutTs;
    private final long ttl;
    private final long oldestUnexpiredTS;
    private final long now;
    protected long maxReadPointToTrackVersions;
    private byte[] dropDeletesFromRow = null;
    private byte[] dropDeletesToRow = null;
    private boolean hasNullColumn = true;
    private RegionCoprocessorHost regionCoprocessorHost = null;
    private final long timeToPurgeDeletes;
    private final boolean isUserScan;
    private final boolean isReversed;
    private final boolean get;

    public ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, ScanType scanType, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        int maxVersions;
        TimeRange timeRange = scan.getColumnFamilyTimeRange().get(scanInfo.getFamily());
        this.tr = timeRange == null ? scan.getTimeRange() : timeRange;
        this.get = scan.isGetScan();
        this.rowComparator = scanInfo.getComparator();
        this.regionCoprocessorHost = regionCoprocessorHost;
        this.deletes = this.instantiateDeleteTracker();
        this.stopRow = scan.getStopRow();
        this.startKey = KeyValueUtil.createFirstDeleteFamilyOnRow(scan.getStartRow(), scanInfo.getFamily());
        this.filter = scan.getFilter();
        this.earliestPutTs = earliestPutTs;
        this.oldestUnexpiredTS = oldestUnexpiredTS;
        this.now = now;
        this.maxReadPointToTrackVersions = readPointToUse;
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.ttl = oldestUnexpiredTS;
        boolean bl = this.isUserScan = scanType == ScanType.USER_SCAN;
        this.keepDeletedCells = scan.isRaw() ? KeepDeletedCells.TRUE : (this.isUserScan ? KeepDeletedCells.FALSE : scanInfo.getKeepDeletedCells());
        this.retainDeletesInOutput = scanType == ScanType.COMPACT_RETAIN_DELETES || scan.isRaw();
        this.seePastDeleteMarkers = scanInfo.getKeepDeletedCells() != KeepDeletedCells.FALSE && this.isUserScan;
        int n = maxVersions = scan.isRaw() ? scan.getMaxVersions() : Math.min(scan.getMaxVersions(), scanInfo.getMaxVersions());
        if (columns == null || columns.size() == 0) {
            this.hasNullColumn = true;
            this.columns = new ScanWildcardColumnTracker(scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        } else {
            this.hasNullColumn = ((byte[])columns.first()).length == 0;
            this.columns = new ExplicitColumnTracker(columns, scanInfo.getMinVersions(), maxVersions, oldestUnexpiredTS);
        }
        this.isReversed = scan.isReversed();
    }

    private DeleteTracker instantiateDeleteTracker() throws IOException {
        DeleteTracker tracker = new ScanDeleteTracker();
        if (this.regionCoprocessorHost != null) {
            tracker = this.regionCoprocessorHost.postInstantiateDeleteTracker(tracker);
        }
        return tracker;
    }

    public ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, byte[] dropDeletesFromRow, byte[] dropDeletesToRow, RegionCoprocessorHost regionCoprocessorHost) throws IOException {
        this(scan, scanInfo, columns, ScanType.COMPACT_RETAIN_DELETES, readPointToUse, earliestPutTs, oldestUnexpiredTS, now, regionCoprocessorHost);
        Preconditions.checkArgument(dropDeletesFromRow != null && dropDeletesToRow != null);
        this.dropDeletesFromRow = dropDeletesFromRow;
        this.dropDeletesToRow = dropDeletesToRow;
    }

    ScanQueryMatcher(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long oldestUnexpiredTS, long now) throws IOException {
        this(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, oldestUnexpiredTS, now, null);
    }

    public boolean hasNullColumnInQuery() {
        return this.hasNullColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchCode match(Cell cell) throws IOException {
        int timestampComparison;
        if (this.filter != null && this.filter.filterAllRemaining()) {
            return MatchCode.DONE_SCAN;
        }
        if (this.row == null) return MatchCode.DONE;
        int ret = this.rowComparator.compareRows(this.row, this.rowOffset, this.rowLength, cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
        if (!this.isReversed) {
            if (ret <= -1) {
                return MatchCode.DONE;
            }
            if (ret >= 1) {
                return MatchCode.SEEK_NEXT_ROW;
            }
        } else {
            if (ret <= -1) {
                return MatchCode.SEEK_NEXT_ROW;
            }
            if (ret >= 1) {
                return MatchCode.DONE;
            }
        }
        if (this.stickyNextRow) {
            return MatchCode.SEEK_NEXT_ROW;
        }
        if (this.columns.done()) {
            this.stickyNextRow = true;
            return MatchCode.SEEK_NEXT_ROW;
        }
        int qualifierOffset = cell.getQualifierOffset();
        int qualifierLength = cell.getQualifierLength();
        long timestamp = cell.getTimestamp();
        if (this.columns.isDone(timestamp)) {
            return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
        }
        if (HStore.isCellTTLExpired(cell, this.oldestUnexpiredTS, this.now)) {
            return MatchCode.SKIP;
        }
        byte typeByte = cell.getTypeByte();
        long mvccVersion = cell.getMvccVersion();
        if (CellUtil.isDelete(cell)) {
            if (this.keepDeletedCells == KeepDeletedCells.FALSE || this.keepDeletedCells == KeepDeletedCells.TTL && timestamp < this.ttl) {
                boolean includeDeleteMarker;
                boolean bl = includeDeleteMarker = this.seePastDeleteMarkers ? this.tr.withinTimeRange(timestamp) : this.tr.withinOrAfterTimeRange(timestamp);
                if (includeDeleteMarker && mvccVersion <= this.maxReadPointToTrackVersions) {
                    this.deletes.add(cell);
                }
            }
            if (!this.isUserScan && this.timeToPurgeDeletes > 0L && EnvironmentEdgeManager.currentTime() - timestamp <= this.timeToPurgeDeletes) {
                return MatchCode.INCLUDE;
            }
            if (this.retainDeletesInOutput || mvccVersion > this.maxReadPointToTrackVersions) {
                if (!this.isUserScan) {
                    return MatchCode.INCLUDE;
                }
            } else {
                if (this.keepDeletedCells != KeepDeletedCells.TRUE && (this.keepDeletedCells != KeepDeletedCells.TTL || timestamp < this.ttl)) return MatchCode.SKIP;
                if (timestamp < this.earliestPutTs) {
                    return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                }
            }
        } else if (!this.deletes.isEmpty()) {
            DeleteTracker.DeleteResult deleteResult = this.deletes.isDeleted(cell);
            switch (deleteResult) {
                case FAMILY_DELETED: 
                case COLUMN_DELETED: {
                    return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                }
                case VERSION_DELETED: 
                case FAMILY_VERSION_DELETED: {
                    return MatchCode.SKIP;
                }
                case NOT_DELETED: {
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED");
                }
            }
        }
        int n = timestampComparison = timestamp == Long.MIN_VALUE ? -1 : this.tr.compare(timestamp);
        if (timestampComparison >= 1) {
            return MatchCode.SKIP;
        }
        if (timestampComparison <= -1) {
            return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
        }
        MatchCode colChecker = this.columns.checkColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength, typeByte);
        if (colChecker == MatchCode.INCLUDE) {
            Filter.ReturnCode filterResponse = Filter.ReturnCode.SKIP;
            if (this.filter != null) {
                filterResponse = this.filter.filterKeyValue(cell);
                switch (filterResponse) {
                    case SKIP: {
                        return MatchCode.SKIP;
                    }
                    case NEXT_COL: {
                        return this.columns.getNextRowOrNextColumn(cell.getQualifierArray(), qualifierOffset, qualifierLength);
                    }
                    case NEXT_ROW: {
                        this.stickyNextRow = true;
                        return MatchCode.SEEK_NEXT_ROW;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        return MatchCode.SEEK_NEXT_USING_HINT;
                    }
                }
            }
            colChecker = this.columns.checkVersions(cell.getQualifierArray(), qualifierOffset, qualifierLength, timestamp, typeByte, mvccVersion > this.maxReadPointToTrackVersions);
            this.stickyNextRow = colChecker == MatchCode.INCLUDE_AND_SEEK_NEXT_ROW ? true : this.stickyNextRow;
            return filterResponse == Filter.ReturnCode.INCLUDE_AND_NEXT_COL && colChecker == MatchCode.INCLUDE ? MatchCode.INCLUDE_AND_SEEK_NEXT_COL : colChecker;
        }
        this.stickyNextRow = colChecker == MatchCode.SEEK_NEXT_ROW ? true : this.stickyNextRow;
        return colChecker;
    }

    private void checkPartialDropDeleteRange(byte[] row, int offset, short length) {
        if (this.dropDeletesFromRow != null && (this.dropDeletesFromRow == HConstants.EMPTY_START_ROW || Bytes.compareTo(row, offset, length, this.dropDeletesFromRow, 0, this.dropDeletesFromRow.length) >= 0)) {
            this.retainDeletesInOutput = false;
            this.dropDeletesFromRow = null;
        }
        if (this.dropDeletesFromRow == null && this.dropDeletesToRow != null && this.dropDeletesToRow != HConstants.EMPTY_END_ROW && Bytes.compareTo(row, offset, length, this.dropDeletesToRow, 0, this.dropDeletesToRow.length) >= 0) {
            this.retainDeletesInOutput = true;
            this.dropDeletesToRow = null;
        }
    }

    public boolean moreRowsMayExistAfter(Cell kv) {
        if (this.get) {
            return false;
        }
        if (this.stopRow == null || this.stopRow == HConstants.EMPTY_BYTE_ARRAY) {
            return true;
        }
        return this.isReversed ? this.rowComparator.compareRows(kv, this.stopRow, 0, this.stopRow.length) > 0 : Bytes.equals(this.stopRow, HConstants.EMPTY_END_ROW) || this.rowComparator.compareRows(kv, this.stopRow, 0, this.stopRow.length) < 0;
    }

    public void setRow(byte[] row, int offset, short length) {
        this.checkPartialDropDeleteRange(row, offset, length);
        this.row = row;
        this.rowOffset = offset;
        this.rowLength = length;
        this.reset();
    }

    public void reset() {
        this.deletes.reset();
        this.columns.reset();
        this.stickyNextRow = false;
    }

    public Cell getStartKey() {
        return this.startKey;
    }

    Filter getFilter() {
        return this.filter;
    }

    public Cell getNextKeyHint(Cell kv) throws IOException {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getNextCellHint(kv);
    }

    public Cell getKeyForNextColumn(Cell kv) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return KeyValueUtil.createLastOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
        }
        return KeyValueUtil.createFirstOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength());
    }

    public int compareKeyForNextRow(Cell nextIndexed, Cell kv) {
        return this.rowComparator.compareKey(nextIndexed, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), null, 0, 0, null, 0, 0, Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
    }

    public int compareKeyForNextColumn(Cell nextIndexed, Cell kv) {
        ColumnCount nextColumn = this.columns.getColumnHint();
        if (nextColumn == null) {
            return this.rowComparator.compareKey(nextIndexed, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), Long.MIN_VALUE, KeyValue.Type.Minimum.getCode());
        }
        return this.rowComparator.compareKey(nextIndexed, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), nextColumn.getBuffer(), nextColumn.getOffset(), nextColumn.getLength(), Long.MAX_VALUE, KeyValue.Type.Maximum.getCode());
    }

    static MatchCode checkColumn(ColumnTracker columnTracker, byte[] bytes, int offset, int length, long ttl, byte type, boolean ignoreCount) throws IOException {
        MatchCode matchCode = columnTracker.checkColumn(bytes, offset, length, type);
        if (matchCode == MatchCode.INCLUDE) {
            return columnTracker.checkVersions(bytes, offset, length, ttl, type, ignoreCount);
        }
        return matchCode;
    }

    public static enum MatchCode {
        INCLUDE,
        SKIP,
        NEXT,
        DONE,
        SEEK_NEXT_ROW,
        SEEK_NEXT_COL,
        DONE_SCAN,
        SEEK_NEXT_USING_HINT,
        INCLUDE_AND_SEEK_NEXT_COL,
        INCLUDE_AND_SEEK_NEXT_ROW;

    }
}

