/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DumpReplicationQueues
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)DumpReplicationQueues.class.getName());

    static DumpOptions parseOpts(Queue<String> args) {
        DumpOptions opts = new DumpOptions();
        String cmd = null;
        while ((cmd = args.poll()) != null) {
            if (cmd.equals("-h") || cmd.equals("--h") || cmd.equals("--help")) {
                args.add(cmd);
                break;
            }
            String hdfs = "--hdfs";
            if (cmd.equals("--hdfs")) {
                opts.setHdfs(true);
                continue;
            }
            String distributed = "--distributed";
            if (cmd.equals("--distributed")) {
                opts.setDistributed(true);
                continue;
            }
            DumpReplicationQueues.printUsageAndExit("ERROR: Unrecognized option/command: " + cmd, -1);
            if (opts.isDistributed() || !opts.isHdfs()) continue;
            DumpReplicationQueues.printUsageAndExit("ERROR: --hdfs option can only be used with --distributed: " + cmd, -1);
        }
        return opts;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run(conf, new DumpReplicationQueues(), args);
        System.exit(ret);
    }

    @Override
    public int run(String[] args) throws Exception {
        int errCode = -1;
        LinkedList<String> argv = new LinkedList<String>();
        argv.addAll(Arrays.asList(args));
        DumpOptions opts = DumpReplicationQueues.parseOpts(argv);
        if (!argv.isEmpty()) {
            errCode = 0;
            this.printUsage();
            return errCode;
        }
        return this.dumpReplicationQueues(opts);
    }

    protected void printUsage() {
        DumpReplicationQueues.printUsage(this.getClass().getName(), null);
    }

    protected static void printUsage(String message) {
        DumpReplicationQueues.printUsage(DumpReplicationQueues.class.getName(), message);
    }

    protected static void printUsage(String className, String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + className + " \\");
        System.err.println("  <OPTIONS> [-D<property=value>]*");
        System.err.println();
        System.err.println("General Options:");
        System.err.println(" distributed  Poll each RS and print its own replication queue. Default only polls ZooKeeper");
        System.err.println(" hdfs         Use HDFS to calculate usage of WALs by replication. It could be overestimated if replicating to multiple peers. --distributed flag is also needed.");
    }

    protected static void printUsageAndExit(String message, int exitCode) {
        DumpReplicationQueues.printUsage(message);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dumpReplicationQueues(DumpOptions opts) throws Exception {
        Configuration conf = this.getConf();
        HBaseAdmin.checkHBaseAvailable(conf);
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(conf);
        ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection(conf);
        long deleted = 0L;
        try (ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "DumpReplicationQueues" + System.currentTimeMillis(), new WarnOnlyAbortable(), true);){
            LOG.info((Object)("Our Quorum: " + zkw.getQuorum()));
            List<HashMap<String, String>> replicatedTables = replicationAdmin.listReplicated();
            if (replicatedTables.isEmpty()) {
                LOG.info((Object)"No tables with a configured replication peer were found.");
                int n = 0;
                return n;
            }
            LOG.info((Object)("Replicated Tables: " + replicatedTables));
            Map<String, ReplicationPeerConfig> peerConfigs = replicationAdmin.listPeerConfigs();
            if (peerConfigs.isEmpty()) {
                LOG.info((Object)"Replication is enabled but no peer configuration was found.");
            }
            System.out.println("Dumping replication peers and configurations:");
            System.out.println(this.dumpPeersState(replicationAdmin, peerConfigs));
            if (opts.isDistributed()) {
                LOG.info((Object)"Found [--distributed], will poll each RegionServer.");
                System.out.println(this.dumpQueues(connection, zkw, opts.isHdfs(), deleted));
                if (deleted > 0L) {
                    LOG.warn((Object)("Found " + deleted + " deleted queues" + ", run hbck -fixReplication in order to remove the deleted replication queues"));
                }
            } else {
                System.out.print("Dumping replication znodes via ZooKeeper:");
                System.out.println(ZKUtil.getReplicationZnodesDump(zkw));
            }
            int n = 0;
            return n;
        }
    }

    public String dumpPeersState(ReplicationAdmin replicationAdmin, Map<String, ReplicationPeerConfig> peerConfigs) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ReplicationPeerConfig> peer : peerConfigs.entrySet()) {
            try {
                sb.append("Peer: " + peer.getKey() + "\n");
                sb.append("    State: " + (replicationAdmin.getPeerState(peer.getKey()) ? "ENABLED" : "DISABLED") + "\n");
                sb.append("    Cluster Name: " + peer.getValue() + "\n");
                Map<String, String> currentConf = peer.getValue().getConfiguration();
                if (currentConf.size() > 1) {
                    sb.append("    Peer Configuration: " + currentConf + "\n");
                }
                sb.append("    Peer Table CFs: " + replicationAdmin.getPeerTableCFs(peer.getKey()) + "\n");
            }
            catch (ReplicationException re) {
                sb.append("Got an exception while invoking ReplicationAdmin: " + re + "\n");
            }
        }
        return sb.toString();
    }

    public String dumpQueues(ClusterConnection connection, ZooKeeperWatcher zkw, boolean hdfs, long deleted) throws Exception {
        StringBuilder sb = new StringBuilder();
        ReplicationQueuesClient queuesClient = ReplicationFactory.getReplicationQueuesClient(zkw, this.getConf(), connection);
        queuesClient.init();
        ReplicationQueues replicationQueues = ReplicationFactory.getReplicationQueues(zkw, this.getConf(), connection);
        ReplicationPeers replicationPeers = ReplicationFactory.getReplicationPeers(zkw, this.getConf(), queuesClient, connection);
        replicationPeers.init();
        HashSet<String> peerIds = new HashSet<String>(replicationPeers.getAllPeerIds());
        try {
            List<String> regionservers = queuesClient.getListOfReplicators();
            for (String regionserver : regionservers) {
                List<String> queueIds = queuesClient.getAllQueues(regionserver);
                replicationQueues.init(regionserver);
                for (String queueId : queueIds) {
                    ReplicationQueueInfo queueInfo = new ReplicationQueueInfo(queueId);
                    List<String> wals = queuesClient.getLogsInQueue(regionserver, queueId);
                    if (!peerIds.contains(queueInfo.getPeerId())) {
                        ++deleted;
                        sb.append(this.formatQueue(regionserver, replicationQueues, queueInfo, queueId, wals, true, hdfs));
                        continue;
                    }
                    sb.append(this.formatQueue(regionserver, replicationQueues, queueInfo, queueId, wals, false, hdfs));
                }
            }
        }
        catch (KeeperException ke) {
            throw new IOException(ke);
        }
        return sb.toString();
    }

    private String formatQueue(String regionserver, ReplicationQueues replicationQueues, ReplicationQueueInfo queueInfo, String queueId, List<String> wals, boolean isDeleted, boolean hdfs) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Dumping replication queue info for RegionServer: [" + regionserver + "]" + "\n");
        sb.append("    PeerID: " + queueInfo.getPeerId() + "\n");
        sb.append("    Recovered: " + queueInfo.isQueueRecovered() + "\n");
        List<String> deadServers = queueInfo.getDeadRegionServers();
        if (deadServers.isEmpty()) {
            sb.append("    No dead RegionServers found in this queue.\n");
        } else {
            sb.append("    Dead RegionServers: " + deadServers + "\n");
        }
        sb.append("    Was deleted: " + isDeleted + "\n");
        sb.append("    Number of WALs in replication queue: " + wals.size() + "\n");
        for (String wal : wals) {
            long position = replicationQueues.getLogPosition(queueInfo.getPeerId(), wal);
            sb.append("    Replication position for " + wal + ": " + (position > 0L ? Long.valueOf(position) : "0 (not started or nothing to replicate)") + "\n");
        }
        if (hdfs) {
            FileSystem fs = FileSystem.get(this.getConf());
            sb.append("    Total size of WALs on HDFS for this queue: " + StringUtils.humanSize(this.getTotalWALSize(fs, wals, regionserver)) + "\n");
        }
        return sb.toString();
    }

    private long getTotalWALSize(FileSystem fs, List<String> wals, String server) throws IOException {
        int size = 0;
        for (String wal : wals) {
            FileStatus fileStatus;
            try {
                fileStatus = new WALLink(this.getConf(), server, wal).getFileStatus(fs);
            }
            catch (IOException e) {
                LOG.warn((Object)("WAL " + wal + " couldn't be found, skipping"));
                break;
            }
            size = (int)((long)size + fileStatus.getLen());
        }
        return size;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            LOG.error((Object)errorMsg);
        }
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.warn((Object)("DumpReplicationQueue received abort, ignoring.  Reason: " + why));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }

        @Override
        public boolean isAborted() {
            return false;
        }
    }

    static class DumpOptions {
        boolean hdfs = false;
        boolean distributed = false;

        public DumpOptions() {
        }

        public DumpOptions(DumpOptions that) {
            this.hdfs = that.hdfs;
            this.distributed = that.distributed;
        }

        boolean isHdfs() {
            return this.hdfs;
        }

        boolean isDistributed() {
            return this.distributed;
        }

        void setHdfs(boolean hdfs) {
            this.hdfs = hdfs;
        }

        void setDistributed(boolean distributed) {
            this.distributed = distributed;
        }
    }
}

