/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSinkSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSinkSourceImpl
implements MetricsReplicationSinkSource {
    private final MutableGaugeLong ageGauge;
    private final MutableFastCounter batchesCounter;
    private final MutableFastCounter opsCounter;
    private final MutableFastCounter hfilesCounter;

    public MetricsReplicationSinkSourceImpl(MetricsReplicationSourceImpl rms) {
        this.ageGauge = rms.getMetricsRegistry().getGauge("sink.ageOfLastAppliedOp", 0L);
        this.batchesCounter = rms.getMetricsRegistry().getCounter("sink.appliedBatches", 0L);
        this.opsCounter = rms.getMetricsRegistry().getCounter("sink.appliedOps", 0L);
        this.hfilesCounter = rms.getMetricsRegistry().getCounter("sink.appliedHFiles", 0L);
    }

    @Override
    public void setLastAppliedOpAge(long age) {
        this.ageGauge.set(age);
    }

    @Override
    public void incrAppliedBatches(long batches) {
        this.batchesCounter.incr(batches);
    }

    @Override
    public void incrAppliedOps(long batchsize) {
        this.opsCounter.incr(batchsize);
    }

    @Override
    public long getLastAppliedOpAge() {
        return this.ageGauge.value();
    }

    @Override
    public void incrAppliedHFiles(long hfiles) {
        this.hfilesCounter.incr(hfiles);
    }
}

