/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.standard.tag.common.sql;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.sql.DataSource;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.resources.Resources;
import org.apache.hadoop.hbase.shaded.org.apache.commons.standard.tag.common.sql.DataSourceWrapper;

public class DataSourceUtil {
    private static final String ESCAPE = "\\";
    private static final String TOKEN = ",";

    static DataSource getDataSource(Object rawDataSource, PageContext pc) throws JspException {
        DataSource dataSource = null;
        if (rawDataSource == null) {
            rawDataSource = Config.find(pc, "javax.servlet.jsp.jstl.sql.dataSource");
        }
        if (rawDataSource == null) {
            return null;
        }
        if (rawDataSource instanceof String) {
            try {
                InitialContext ctx = new InitialContext();
                Context envCtx = (Context)ctx.lookup("java:comp/env");
                dataSource = (DataSource)envCtx.lookup((String)rawDataSource);
            }
            catch (NamingException ex) {
                dataSource = DataSourceUtil.getDataSource((String)rawDataSource);
            }
        } else if (rawDataSource instanceof DataSource) {
            dataSource = (DataSource)rawDataSource;
        } else {
            throw new JspException(Resources.getMessage("SQL_DATASOURCE_INVALID_TYPE"));
        }
        return dataSource;
    }

    private static DataSource getDataSource(String params) throws JspException {
        DataSourceWrapper dataSource = new DataSourceWrapper();
        String[] paramString = new String[4];
        int escCount = 0;
        int aryCount = 0;
        int begin = 0;
        for (int index = 0; index < params.length(); ++index) {
            char nextChar = params.charAt(index);
            if (TOKEN.indexOf(nextChar) != -1 && escCount == 0) {
                paramString[aryCount] = params.substring(begin, index).trim();
                begin = index + 1;
                if (++aryCount > 4) {
                    throw new JspTagException(Resources.getMessage("JDBC_PARAM_COUNT"));
                }
            }
            if (ESCAPE.indexOf(nextChar) != -1) {
                ++escCount;
                continue;
            }
            escCount = 0;
        }
        paramString[aryCount] = params.substring(begin).trim();
        dataSource.setJdbcURL(paramString[0]);
        if (paramString[1] != null) {
            try {
                dataSource.setDriverClassName(paramString[1]);
            }
            catch (Exception ex) {
                throw new JspTagException(Resources.getMessage("DRIVER_INVALID_CLASS", ex.toString()), ex);
            }
        }
        dataSource.setUserName(paramString[2]);
        dataSource.setPassword(paramString[3]);
        return dataSource;
    }
}

