/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.Constants;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JasperException;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.JspCompilationContext;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.PageInfo;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.ParserController;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.compiler.TagFileProcessor;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.xmlparser.ParserUtils;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.xmlparser.TreeNode;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private Hashtable tagFileMap;
    private ParserController pc;
    private PageInfo pageInfo;
    private Vector vec;
    private ErrorDispatcher err;

    public ImplicitTagLibraryInfo(JspCompilationContext ctxt, ParserController pc, String prefix, String tagdir, ErrorDispatcher err) throws JasperException {
        super(prefix, null);
        this.pc = pc;
        this.err = err;
        this.pageInfo = pc.getCompiler().getPageInfo();
        this.tagFileMap = new Hashtable();
        this.vec = new Vector();
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!tagdir.startsWith(WEB_INF_TAGS)) {
            err.jspError("jsp.error.invalid.tagdir", tagdir);
        }
        if (tagdir.equals(WEB_INF_TAGS) || tagdir.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = tagdir.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set dirList = ctxt.getResourcePaths(tagdir);
        if (dirList != null) {
            for (String path : dirList) {
                String tldName;
                if (path.endsWith(TAG_FILE_SUFFIX) || path.endsWith(TAGX_FILE_SUFFIX)) {
                    String suffix = path.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                    String tagName = path.substring(path.lastIndexOf("/") + 1);
                    tagName = tagName.substring(0, tagName.lastIndexOf(suffix));
                    this.tagFileMap.put(tagName, path);
                    continue;
                }
                if (!path.endsWith(IMPLICIT_TLD) || !IMPLICIT_TLD.equals(tldName = path.substring(path.lastIndexOf("/") + 1))) continue;
                this.parseImplicitTld(ctxt, path);
            }
        }
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Object[] objs;
        TagLibraryInfo[] taglibs = null;
        Collection c = this.pageInfo.getTaglibs();
        if (c != null && (objs = c.toArray()) != null && objs.length > 0) {
            taglibs = new TagLibraryInfo[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                taglibs[i] = (TagLibraryInfo)objs[i];
            }
        }
        return taglibs;
    }

    public TagFileInfo getTagFile(String shortName) {
        TagFileInfo tagFile = super.getTagFile(shortName);
        if (tagFile == null) {
            String path = (String)this.tagFileMap.get(shortName);
            if (path == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, shortName, path, this);
            }
            catch (JasperException je) {
                throw new RuntimeException(je.toString());
            }
            tagFile = new TagFileInfo(shortName, path, tagInfo);
            this.vec.addElement(tagFile);
            this.tagFiles = new TagFileInfo[this.vec.size()];
            this.vec.copyInto(this.tagFiles);
        }
        return tagFile;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseImplicitTld(JspCompilationContext ctxt, String path) throws JasperException {
        block15: {
            block14: {
                is = null;
                tld = null;
                try {
                    try {
                        uri = ctxt.getResource(path);
                        if (uri == null) {
                            var7_7 = null;
                            if (is == null) return;
                            break block14;
                        }
                        is = uri.openStream();
                        tld = new ParserUtils().parseXMLDocument("implicit.tld", is, ctxt.getOptions().isValidationEnabled());
                        break block15;
                    }
                    catch (Exception ex) {
                        throw new JasperException(ex);
                    }
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (is == null) throw var6_13;
                    try {
                        is.close();
                        throw var6_13;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw var6_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 83->90)] { 
lbl28:
            // 1 sources

            is.close();
            return;
lbl30:
            // 1 sources

            catch (Throwable t) {
                // empty catch block
            }
            return;
        }
        var7_8 = null;
        if (is != null) {
            try {}
            catch (Throwable t) {}
            is.close();
        }
        this.jspversion = tld.findAttribute("version");
        list = tld.findChildren();
        while (true) {
            if (!list.hasNext()) {
                jspVersionDouble = Double.valueOf(this.jspversion);
                if (Double.compare(jspVersionDouble, Constants.JSP_VERSION_2_0) >= 0) return;
                this.err.jspError("jsp.error.implicitTld.jspVersion", new String[]{path, this.jspversion});
                return;
            }
            element = (TreeNode)list.next();
            tname = element.getName();
            if ("tlibversion".equals(tname) || "tlib-version".equals(tname)) {
                this.tlibversion = element.getBody();
                continue;
            }
            if ("jspversion".equals(tname) || "jsp-version".equals(tname)) {
                this.jspversion = element.getBody();
                continue;
            }
            if ("shortname".equals(tname) || "short-name".equals(tname)) continue;
            this.err.jspError("jsp.error.implicitTld.additionalElements", new String[]{path, tname});
        }
    }
}

