/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIterator
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private CacheDirectiveInfo filter;
    private final ClientProtocol namenode;

    public CacheDirectiveIterator(ClientProtocol namenode, CacheDirectiveInfo filter) {
        super(0L);
        this.namenode = namenode;
        this.filter = filter;
    }

    private static CacheDirectiveInfo removeIdFromFilter(CacheDirectiveInfo filter) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder(filter);
        builder.setId(null);
        return builder.build();
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries = null;
        try {
            entries = this.namenode.listCacheDirectives(prevKey, this.filter);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Filtering by ID is unsupported")) {
                long id = this.filter.getId();
                this.filter = CacheDirectiveIterator.removeIdFromFilter(this.filter);
                entries = this.namenode.listCacheDirectives(id - 1L, this.filter);
                for (int i = 0; i < entries.size(); ++i) {
                    CacheDirectiveEntry entry = entries.get(i);
                    if (!entry.getInfo().getId().equals(id)) continue;
                    return new SingleEntry(entry);
                }
                throw new RemoteException(InvalidRequestException.class.getName(), "Did not find requested id " + id);
            }
            throw e;
        }
        Preconditions.checkNotNull(entries);
        return entries;
    }

    @Override
    public Long elementToPrevKey(CacheDirectiveEntry entry) {
        return entry.getInfo().getId();
    }

    private static class SingleEntry
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final CacheDirectiveEntry entry;

        public SingleEntry(CacheDirectiveEntry entry) {
            this.entry = entry;
        }

        @Override
        public CacheDirectiveEntry get(int i) {
            if (i > 0) {
                return null;
            }
            return this.entry;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean hasMore() {
            return false;
        }
    }
}

