/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonGenerationException;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.JsonMappingException;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.ObjectMapper;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.map.SerializationConfig;
import org.apache.hadoop.hbase.util.FastLongHistogram;

@InterfaceAudience.Private
public class BlockCacheUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toString(CachedBlock cb, long now) {
        return "filename=" + cb.getFilename() + ", " + BlockCacheUtil.toStringMinusFileName(cb, now);
    }

    public static String toJSON(String filename, NavigableSet<CachedBlock> blocks) throws JsonGenerationException, JsonMappingException, IOException {
        CachedBlockCountsPerFile counts = new CachedBlockCountsPerFile(filename);
        for (CachedBlock cb : blocks) {
            counts.count++;
            counts.size += cb.getSize();
            BlockType bt = cb.getBlockType();
            if (bt == null || !bt.isData()) continue;
            counts.countData++;
            counts.sizeData += cb.getSize();
        }
        return MAPPER.writeValueAsString(counts);
    }

    public static String toJSON(CachedBlocksByFile cbsbf) throws JsonGenerationException, JsonMappingException, IOException {
        return MAPPER.writeValueAsString(cbsbf);
    }

    public static String toJSON(BlockCache bc) throws JsonGenerationException, JsonMappingException, IOException {
        return MAPPER.writeValueAsString(bc);
    }

    public static String toStringMinusFileName(CachedBlock cb, long now) {
        return "offset=" + cb.getOffset() + ", size=" + cb.getSize() + ", age=" + (now - cb.getCachedTime()) + ", type=" + (Object)((Object)cb.getBlockType()) + ", priority=" + (Object)((Object)cb.getBlockPriority());
    }

    public static CachedBlocksByFile getLoadedCachedBlocksByFile(Configuration conf, BlockCache bc) {
        CachedBlocksByFile cbsbf = new CachedBlocksByFile(conf);
        for (CachedBlock cb : bc) {
            if (cbsbf.update(cb)) break;
        }
        return cbsbf;
    }

    static {
        MAPPER.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationConfig.Feature.FLUSH_AFTER_WRITE_VALUE, true);
        MAPPER.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
    }

    @JsonIgnoreProperties(value={"cachedBlockStatsByFile"})
    public static class CachedBlocksByFile {
        private int count;
        private int dataBlockCount;
        private long size;
        private long dataSize;
        private final long now = System.nanoTime();
        private final int max;
        public static final int DEFAULT_MAX = 1000000;
        private NavigableMap<String, NavigableSet<CachedBlock>> cachedBlockByFile = new ConcurrentSkipListMap<String, NavigableSet<CachedBlock>>();
        FastLongHistogram hist = new FastLongHistogram();

        CachedBlocksByFile() {
            this(null);
        }

        CachedBlocksByFile(Configuration c) {
            this.max = c == null ? 1000000 : c.getInt("hbase.ui.blockcache.by.file.max", 1000000);
        }

        public boolean update(CachedBlock cb) {
            if (this.isFull()) {
                return true;
            }
            ConcurrentSkipListSet<CachedBlock> set = (ConcurrentSkipListSet<CachedBlock>)this.cachedBlockByFile.get(cb.getFilename());
            if (set == null) {
                set = new ConcurrentSkipListSet<CachedBlock>();
                this.cachedBlockByFile.put(cb.getFilename(), set);
            }
            set.add(cb);
            this.size += cb.getSize();
            ++this.count;
            BlockType bt = cb.getBlockType();
            if (bt != null && bt.isData()) {
                ++this.dataBlockCount;
                this.dataSize += cb.getSize();
            }
            long age = this.now - cb.getCachedTime();
            this.hist.add(age, 1L);
            return false;
        }

        public boolean isFull() {
            return this.count >= this.max;
        }

        public NavigableMap<String, NavigableSet<CachedBlock>> getCachedBlockStatsByFile() {
            return this.cachedBlockByFile;
        }

        public int getCount() {
            return this.count;
        }

        public int getDataCount() {
            return this.dataBlockCount;
        }

        public long getSize() {
            return this.size;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public AgeSnapshot getAgeInCacheSnapshot() {
            return new AgeSnapshot(this.hist);
        }

        public String toString() {
            AgeSnapshot snapshot = this.getAgeInCacheSnapshot();
            return "count=" + this.count + ", dataBlockCount=" + this.dataBlockCount + ", size=" + this.size + ", dataSize=" + this.getDataSize() + ", mean age=" + snapshot.getMean() + ", min age=" + snapshot.getMin() + ", max age=" + snapshot.getMax() + ", 75th percentile age=" + snapshot.get75thPercentile() + ", 95th percentile age=" + snapshot.get95thPercentile() + ", 98th percentile age=" + snapshot.get98thPercentile() + ", 99th percentile age=" + snapshot.get99thPercentile() + ", 99.9th percentile age=" + snapshot.get99thPercentile();
        }
    }

    static class CachedBlockCountsPerFile {
        private int count = 0;
        private long size = 0L;
        private int countData = 0;
        private long sizeData = 0L;
        private final String filename;

        CachedBlockCountsPerFile(String filename) {
            this.filename = filename;
        }

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }

        public int getCountData() {
            return this.countData;
        }

        public long getSizeData() {
            return this.sizeData;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

