/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.BlockPriority;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocatorException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
import org.apache.hadoop.hbase.io.hfile.bucket.ByteBufferIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.apache.hadoop.hbase.io.hfile.bucket.CachedEntryQueue;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.UniqueIndexMap;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.IdReadWriteLock;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class BucketCache
implements BlockCache,
HeapSize {
    private static final Log LOG = LogFactory.getLog(BucketCache.class);
    private static final float DEFAULT_SINGLE_FACTOR = 0.25f;
    private static final float DEFAULT_MULTI_FACTOR = 0.5f;
    private static final float DEFAULT_MEMORY_FACTOR = 0.25f;
    private static final float DEFAULT_EXTRA_FREE_FACTOR = 0.1f;
    private static final float DEFAULT_ACCEPT_FACTOR = 0.95f;
    private static final float DEFAULT_MIN_FACTOR = 0.85f;
    private static final int DEFAULT_FREE_ENTIRE_BLOCK_FACTOR = 2;
    private static final int statThreadPeriod = 300;
    static final int DEFAULT_WRITER_THREADS = 3;
    static final int DEFAULT_WRITER_QUEUE_ITEMS = 64;
    final IOEngine ioEngine;
    @VisibleForTesting
    final ConcurrentMap<BlockCacheKey, RAMQueueEntry> ramCache;
    @VisibleForTesting
    ConcurrentMap<BlockCacheKey, BucketEntry> backingMap;
    private volatile boolean cacheEnabled;
    @VisibleForTesting
    final ArrayList<BlockingQueue<RAMQueueEntry>> writerQueues = new ArrayList();
    @VisibleForTesting
    final WriterThread[] writerThreads;
    private volatile boolean freeInProgress = false;
    private final Lock freeSpaceLock = new ReentrantLock();
    private UniqueIndexMap<Integer> deserialiserMap = new UniqueIndexMap();
    private final AtomicLong realCacheSize = new AtomicLong(0L);
    private final AtomicLong heapSize = new AtomicLong(0L);
    private final AtomicLong blockNumber = new AtomicLong(0L);
    private final AtomicLong accessCount = new AtomicLong(0L);
    private static final int DEFAULT_CACHE_WAIT_TIME = 50;
    boolean wait_when_cache = false;
    private final BucketCacheStats cacheStats = new BucketCacheStats();
    private final String persistencePath;
    private final long cacheCapacity;
    private final long blockSize;
    private final int ioErrorsTolerationDuration;
    public static final int DEFAULT_ERROR_TOLERATION_DURATION = 60000;
    private volatile long ioErrorStartTime = -1L;
    @VisibleForTesting
    final IdReadWriteLock offsetLock = new IdReadWriteLock();
    private final NavigableSet<BlockCacheKey> blocksByHFile = new ConcurrentSkipListSet<BlockCacheKey>(new Comparator<BlockCacheKey>(){

        @Override
        public int compare(BlockCacheKey a, BlockCacheKey b) {
            int nameComparison = a.getHfileName().compareTo(b.getHfileName());
            if (nameComparison != 0) {
                return nameComparison;
            }
            if (a.getOffset() == b.getOffset()) {
                return 0;
            }
            if (a.getOffset() < b.getOffset()) {
                return -1;
            }
            return 1;
        }
    });
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("BucketCacheStatsExecutor").setDaemon(true).build());
    private BucketAllocator bucketAllocator;

    public BucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath) throws FileNotFoundException, IOException {
        this(ioEngineName, capacity, blockSize, bucketSizes, writerThreadNum, writerQLen, persistencePath, 60000);
    }

    public BucketCache(String ioEngineName, long capacity, int blockSize, int[] bucketSizes, int writerThreadNum, int writerQLen, String persistencePath, int ioErrorsTolerationDuration) throws FileNotFoundException, IOException {
        this.ioEngine = this.getIOEngineFromName(ioEngineName, capacity);
        this.writerThreads = new WriterThread[writerThreadNum];
        long blockNumCapacity = capacity / (long)blockSize;
        if (blockNumCapacity >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache capacity is too large, only support 32TB now");
        }
        this.cacheCapacity = capacity;
        this.persistencePath = persistencePath;
        this.blockSize = blockSize;
        this.ioErrorsTolerationDuration = ioErrorsTolerationDuration;
        this.bucketAllocator = new BucketAllocator(capacity, bucketSizes);
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerQueues.add(new ArrayBlockingQueue(writerQLen));
        }
        assert (this.writerQueues.size() == this.writerThreads.length);
        this.ramCache = new ConcurrentHashMap<BlockCacheKey, RAMQueueEntry>();
        this.backingMap = new ConcurrentHashMap<BlockCacheKey, BucketEntry>((int)blockNumCapacity);
        if (this.ioEngine.isPersistent() && persistencePath != null) {
            try {
                this.retrieveFromFile(bucketSizes);
            }
            catch (IOException ioex) {
                LOG.error((Object)"Can't restore from file because of", (Throwable)ioex);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)"Can't restore from file in rebuild because can't deserialise", (Throwable)cnfe);
                throw new RuntimeException(cnfe);
            }
        }
        String threadName = Thread.currentThread().getName();
        this.cacheEnabled = true;
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i] = new WriterThread(this.writerQueues.get(i));
            this.writerThreads[i].setName(threadName + "-BucketCacheWriter-" + i);
            this.writerThreads[i].setDaemon(true);
        }
        this.startWriterThreads();
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 300L, 300L, TimeUnit.SECONDS);
        LOG.info((Object)("Started bucket cache; ioengine=" + ioEngineName + ", capacity=" + StringUtils.byteDesc(capacity) + ", blockSize=" + StringUtils.byteDesc(blockSize) + ", writerThreadNum=" + writerThreadNum + ", writerQLen=" + writerQLen + ", persistencePath=" + persistencePath + ", bucketAllocator=" + this.bucketAllocator.getClass().getName()));
    }

    @VisibleForTesting
    protected void startWriterThreads() {
        for (WriterThread thread : this.writerThreads) {
            thread.start();
        }
    }

    @VisibleForTesting
    boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public long getMaxSize() {
        return this.cacheCapacity;
    }

    public String getIoEngine() {
        return this.ioEngine.toString();
    }

    private IOEngine getIOEngineFromName(String ioEngineName, long capacity) throws IOException {
        if (ioEngineName.startsWith("file:") || ioEngineName.startsWith("files:")) {
            String[] filePaths = ioEngineName.substring(ioEngineName.indexOf(":") + 1).split(",");
            return new FileIOEngine(capacity, filePaths);
        }
        if (ioEngineName.startsWith("offheap")) {
            return new ByteBufferIOEngine(capacity, true);
        }
        if (ioEngineName.startsWith("heap")) {
            return new ByteBufferIOEngine(capacity, false);
        }
        throw new IllegalArgumentException("Don't understand io engine name for cache - prefix with file:, heap or offheap");
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false, false);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable cachedItem, boolean inMemory, boolean cacheDataInL1) {
        this.cacheBlockWithWait(cacheKey, cachedItem, inMemory, this.wait_when_cache);
    }

    public void cacheBlockWithWait(BlockCacheKey cacheKey, Cacheable cachedItem, boolean inMemory, boolean wait) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Caching key=" + cacheKey + ", item=" + cachedItem));
        }
        if (!this.cacheEnabled) {
            return;
        }
        if (this.backingMap.containsKey(cacheKey)) {
            return;
        }
        RAMQueueEntry re = new RAMQueueEntry(cacheKey, cachedItem, this.accessCount.incrementAndGet(), inMemory);
        if (this.ramCache.putIfAbsent(cacheKey, re) != null) {
            return;
        }
        int queueNum = (cacheKey.hashCode() & Integer.MAX_VALUE) % this.writerQueues.size();
        BlockingQueue<RAMQueueEntry> bq = this.writerQueues.get(queueNum);
        boolean successfulAddition = false;
        if (wait) {
            try {
                successfulAddition = bq.offer(re, 50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            successfulAddition = bq.offer(re);
        }
        if (!successfulAddition) {
            this.ramCache.remove(cacheKey);
            this.cacheStats.failInsert();
        } else {
            this.blockNumber.incrementAndGet();
            this.heapSize.addAndGet(cachedItem.heapSize());
            this.blocksByHFile.add(cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        if (!this.cacheEnabled) {
            return null;
        }
        RAMQueueEntry re = (RAMQueueEntry)this.ramCache.get(key);
        if (re != null) {
            if (updateCacheMetrics) {
                this.cacheStats.hit(caching, key.isPrimary(), key.getBlockType());
            }
            re.access(this.accessCount.incrementAndGet());
            return re.getData();
        }
        BucketEntry bucketEntry = (BucketEntry)this.backingMap.get(key);
        if (bucketEntry != null) {
            long start = System.nanoTime();
            ReentrantReadWriteLock lock = this.offsetLock.getLock(bucketEntry.offset());
            try {
                lock.readLock().lock();
                if (bucketEntry.equals(this.backingMap.get(key))) {
                    ByteBuffer bb;
                    int lenRead;
                    int len = bucketEntry.getLength();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Read offset=" + bucketEntry.offset() + ", len=" + len));
                    }
                    if ((lenRead = this.ioEngine.read(bb = ByteBuffer.allocate(len), bucketEntry.offset())) != len) {
                        throw new RuntimeException("Only " + lenRead + " bytes read, " + len + " expected");
                    }
                    CacheableDeserializer<Cacheable> deserializer = bucketEntry.deserializerReference(this.deserialiserMap);
                    Cacheable cachedBlock = deserializer.deserialize(bb, true);
                    long timeTaken = System.nanoTime() - start;
                    if (updateCacheMetrics) {
                        this.cacheStats.hit(caching, key.isPrimary(), key.getBlockType());
                        this.cacheStats.ioHit(timeTaken);
                    }
                    bucketEntry.access(this.accessCount.incrementAndGet());
                    if (this.ioErrorStartTime > 0L) {
                        this.ioErrorStartTime = -1L;
                    }
                    Cacheable cacheable = cachedBlock;
                    return cacheable;
                }
            }
            catch (IOException ioex) {
                LOG.error((Object)("Failed reading block " + key + " from bucket cache"), (Throwable)ioex);
                this.checkIOErrorIsTolerated();
            }
            finally {
                lock.readLock().unlock();
            }
        }
        if (!repeat && updateCacheMetrics) {
            this.cacheStats.miss(caching, key.isPrimary(), key.getBlockType());
        }
        return null;
    }

    @VisibleForTesting
    void blockEvicted(BlockCacheKey cacheKey, BucketEntry bucketEntry, boolean decrementBlockNumber) {
        this.bucketAllocator.freeBlock(bucketEntry.offset());
        this.realCacheSize.addAndGet(-1 * bucketEntry.getLength());
        this.blocksByHFile.remove(cacheKey);
        if (decrementBlockNumber) {
            this.blockNumber.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        BucketEntry bucketEntry;
        block8: {
            if (!this.cacheEnabled) {
                return false;
            }
            RAMQueueEntry removedBlock = (RAMQueueEntry)this.ramCache.remove(cacheKey);
            if (removedBlock != null) {
                this.blockNumber.decrementAndGet();
                this.heapSize.addAndGet(-1L * removedBlock.getData().heapSize());
            }
            if ((bucketEntry = (BucketEntry)this.backingMap.get(cacheKey)) == null) {
                if (removedBlock != null) {
                    this.cacheStats.evicted(0L, cacheKey.isPrimary());
                    return true;
                }
                return false;
            }
            ReentrantReadWriteLock lock = this.offsetLock.getLock(bucketEntry.offset());
            try {
                lock.writeLock().lock();
                if (this.backingMap.remove(cacheKey, bucketEntry)) {
                    this.blockEvicted(cacheKey, bucketEntry, removedBlock == null);
                    break block8;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        this.cacheStats.evicted(bucketEntry.getCachedTime(), cacheKey.isPrimary());
        return true;
    }

    public void logStats() {
        long totalSize = this.bucketAllocator.getTotalSize();
        long usedSize = this.bucketAllocator.getUsedSize();
        long freeSize = totalSize - usedSize;
        long cacheSize = this.getRealCacheSize();
        LOG.info((Object)("failedBlockAdditions=" + this.cacheStats.getFailedInserts() + ", " + "totalSize=" + StringUtils.byteDesc(totalSize) + ", " + "freeSize=" + StringUtils.byteDesc(freeSize) + ", " + "usedSize=" + StringUtils.byteDesc(usedSize) + ", " + "cacheSize=" + StringUtils.byteDesc(cacheSize) + ", " + "accesses=" + this.cacheStats.getRequestCount() + ", " + "hits=" + this.cacheStats.getHitCount() + ", " + "IOhitsPerSecond=" + this.cacheStats.getIOHitsPerSecond() + ", " + "IOTimePerHit=" + String.format("%.2f", this.cacheStats.getIOTimePerHit()) + ", " + "hitRatio=" + (this.cacheStats.getHitCount() == 0L ? "0," : StringUtils.formatPercent(this.cacheStats.getHitRatio(), 2) + ", ") + "cachingAccesses=" + this.cacheStats.getRequestCachingCount() + ", " + "cachingHits=" + this.cacheStats.getHitCachingCount() + ", " + "cachingHitsRatio=" + (this.cacheStats.getHitCachingCount() == 0L ? "0," : StringUtils.formatPercent(this.cacheStats.getHitCachingRatio(), 2) + ", ") + "evictions=" + this.cacheStats.getEvictionCount() + ", " + "evicted=" + this.cacheStats.getEvictedCount() + ", " + "evictedPerRun=" + this.cacheStats.evictedPerEviction()));
        this.cacheStats.reset();
    }

    public long getRealCacheSize() {
        return this.realCacheSize.get();
    }

    private long acceptableSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.95f);
    }

    private long singleSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.25f * 0.85f);
    }

    private long multiSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.5f * 0.85f);
    }

    private long memorySize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.25f * 0.85f);
    }

    private int bucketSizesAboveThresholdCount(float minFactor) {
        BucketAllocator.IndexStatistics[] stats = this.bucketAllocator.getIndexStatistics();
        int fullCount = 0;
        for (int i = 0; i < stats.length; ++i) {
            long freeGoal = (long)Math.floor((float)stats[i].totalCount() * (1.0f - minFactor));
            freeGoal = Math.max(freeGoal, 1L);
            if (stats[i].freeCount() >= freeGoal) continue;
            ++fullCount;
        }
        return fullCount;
    }

    private void freeEntireBuckets(int completelyFreeBucketsNeeded) {
        if (completelyFreeBucketsNeeded != 0) {
            HashSet<Integer> inUseBuckets = new HashSet<Integer>();
            for (BucketEntry entry : this.backingMap.values()) {
                inUseBuckets.add(this.bucketAllocator.getBucketIndex(entry.offset()));
            }
            Set<Integer> candidateBuckets = this.bucketAllocator.getLeastFilledBuckets(inUseBuckets, completelyFreeBucketsNeeded);
            for (Map.Entry entry : this.backingMap.entrySet()) {
                if (!candidateBuckets.contains(this.bucketAllocator.getBucketIndex(((BucketEntry)entry.getValue()).offset()))) continue;
                this.evictBlock((BlockCacheKey)entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void freeSpace(String why) {
        if (!this.freeSpaceLock.tryLock()) {
            return;
        }
        try {
            BucketEntryGroup bucketGroup;
            this.freeInProgress = true;
            long bytesToFreeWithoutExtra = 0L;
            StringBuffer msgBuffer = LOG.isDebugEnabled() ? new StringBuffer() : null;
            BucketAllocator.IndexStatistics[] stats = this.bucketAllocator.getIndexStatistics();
            long[] bytesToFreeForBucket = new long[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                bytesToFreeForBucket[i] = 0L;
                long freeGoal = (long)Math.floor((float)stats[i].totalCount() * 0.14999998f);
                freeGoal = Math.max(freeGoal, 1L);
                if (stats[i].freeCount() >= freeGoal) continue;
                bytesToFreeForBucket[i] = stats[i].itemSize() * (freeGoal - stats[i].freeCount());
                bytesToFreeWithoutExtra += bytesToFreeForBucket[i];
                if (msgBuffer == null) continue;
                msgBuffer.append("Free for bucketSize(" + stats[i].itemSize() + ")=" + StringUtils.byteDesc(bytesToFreeForBucket[i]) + ", ");
            }
            if (msgBuffer != null) {
                msgBuffer.append("Free for total=" + StringUtils.byteDesc(bytesToFreeWithoutExtra) + ", ");
            }
            if (bytesToFreeWithoutExtra <= 0L) {
                return;
            }
            long currentSize = this.bucketAllocator.getUsedSize();
            long totalSize = this.bucketAllocator.getTotalSize();
            if (LOG.isDebugEnabled() && msgBuffer != null) {
                LOG.debug((Object)("Free started because \"" + why + "\"; " + msgBuffer.toString() + " of current used=" + StringUtils.byteDesc(currentSize) + ", actual cacheSize=" + StringUtils.byteDesc(this.realCacheSize.get()) + ", total=" + StringUtils.byteDesc(totalSize)));
            }
            long bytesToFreeWithExtra = (long)Math.floor((float)bytesToFreeWithoutExtra * 1.1f);
            BucketEntryGroup bucketSingle = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.singleSize());
            BucketEntryGroup bucketMulti = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.multiSize());
            BucketEntryGroup bucketMemory = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.memorySize());
            for (Map.Entry<BlockCacheKey, BucketEntry> entry : this.backingMap.entrySet()) {
                switch (((BucketEntry)entry.getValue()).getPriority()) {
                    case SINGLE: {
                        bucketSingle.add(entry);
                        break;
                    }
                    case MULTI: {
                        bucketMulti.add(entry);
                        break;
                    }
                    case MEMORY: {
                        bucketMemory.add(entry);
                    }
                }
            }
            PriorityQueue<BucketEntryGroup> bucketQueue = new PriorityQueue<BucketEntryGroup>(3);
            bucketQueue.add(bucketSingle);
            bucketQueue.add(bucketMulti);
            bucketQueue.add(bucketMemory);
            int n = 3;
            long bytesFreed = 0L;
            while ((bucketGroup = (BucketEntryGroup)bucketQueue.poll()) != null) {
                void var20_17;
                long overflow = bucketGroup.overflow();
                if (overflow > 0L) {
                    long bucketBytesToFree = Math.min(overflow, (bytesToFreeWithoutExtra - bytesFreed) / (long)var20_17);
                    bytesFreed += bucketGroup.free(bucketBytesToFree);
                }
                --var20_17;
            }
            if (this.bucketSizesAboveThresholdCount(0.85f) > 0) {
                bucketQueue.clear();
                int n2 = 3;
                bucketQueue.add(bucketSingle);
                bucketQueue.add(bucketMulti);
                bucketQueue.add(bucketMemory);
                while ((bucketGroup = (BucketEntryGroup)bucketQueue.poll()) != null) {
                    void var20_19;
                    long bucketBytesToFree = (bytesToFreeWithExtra - bytesFreed) / (long)var20_19;
                    bytesFreed += bucketGroup.free(bucketBytesToFree);
                    --var20_19;
                }
            }
            this.freeEntireBuckets(2 * this.bucketSizesAboveThresholdCount(1.0f));
            if (LOG.isDebugEnabled()) {
                long single = bucketSingle.totalSize();
                long multi = bucketMulti.totalSize();
                long memory = bucketMemory.totalSize();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Bucket cache free space completed; freed=" + StringUtils.byteDesc(bytesFreed) + ", " + "total=" + StringUtils.byteDesc(totalSize) + ", " + "single=" + StringUtils.byteDesc(single) + ", " + "multi=" + StringUtils.byteDesc(multi) + ", " + "memory=" + StringUtils.byteDesc(memory)));
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Failed freeing space", t);
        }
        finally {
            this.cacheStats.evict();
            this.freeInProgress = false;
            this.freeSpaceLock.unlock();
        }
    }

    @VisibleForTesting
    static List<RAMQueueEntry> getRAMQueueEntries(BlockingQueue<RAMQueueEntry> q, List<RAMQueueEntry> receptical) throws InterruptedException {
        receptical.clear();
        receptical.add(q.take());
        q.drainTo(receptical);
        return receptical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToFile() throws IOException {
        assert (!this.cacheEnabled);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            if (!this.ioEngine.isPersistent()) {
                throw new IOException("Attempt to persist non-persistent cache mappings!");
            }
            fos = new FileOutputStream(this.persistencePath, false);
            oos = new ObjectOutputStream(fos);
            oos.writeLong(this.cacheCapacity);
            oos.writeUTF(this.ioEngine.getClass().getName());
            oos.writeUTF(this.backingMap.getClass().getName());
            oos.writeObject(this.deserialiserMap);
            oos.writeObject(this.backingMap);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFromFile(int[] bucketSizes) throws IOException, BucketAllocatorException, ClassNotFoundException {
        File persistenceFile = new File(this.persistencePath);
        if (!persistenceFile.exists()) {
            return;
        }
        assert (!this.cacheEnabled);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            BucketAllocator allocator;
            if (!this.ioEngine.isPersistent()) {
                throw new IOException("Attempt to restore non-persistent cache mappings!");
            }
            fis = new FileInputStream(this.persistencePath);
            ois = new ObjectInputStream(fis);
            long capacitySize = ois.readLong();
            if (capacitySize != this.cacheCapacity) {
                throw new IOException("Mismatched cache capacity:" + StringUtils.byteDesc(capacitySize) + ", expected: " + StringUtils.byteDesc(this.cacheCapacity));
            }
            String ioclass = ois.readUTF();
            String mapclass = ois.readUTF();
            if (!this.ioEngine.getClass().getName().equals(ioclass)) {
                throw new IOException("Class name for IO engine mismatch: " + ioclass + ", expected:" + this.ioEngine.getClass().getName());
            }
            if (!this.backingMap.getClass().getName().equals(mapclass)) {
                throw new IOException("Class name for cache map mismatch: " + mapclass + ", expected:" + this.backingMap.getClass().getName());
            }
            UniqueIndexMap deserMap = (UniqueIndexMap)ois.readObject();
            ConcurrentHashMap backingMapFromFile = (ConcurrentHashMap)ois.readObject();
            this.bucketAllocator = allocator = new BucketAllocator(this.cacheCapacity, bucketSizes, backingMapFromFile, this.realCacheSize);
            this.deserialiserMap = deserMap;
            this.backingMap = backingMapFromFile;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (!persistenceFile.delete()) {
                throw new IOException("Failed deleting persistence file " + persistenceFile.getAbsolutePath());
            }
        }
    }

    private void checkIOErrorIsTolerated() {
        long now = EnvironmentEdgeManager.currentTime();
        if (this.ioErrorStartTime > 0L) {
            if (this.cacheEnabled && now - this.ioErrorStartTime > (long)this.ioErrorsTolerationDuration) {
                LOG.error((Object)("IO errors duration time has exceeded " + this.ioErrorsTolerationDuration + "ms, disabling cache, please check your IOEngine"));
                this.disableCache();
            }
        } else {
            this.ioErrorStartTime = now;
        }
    }

    private void disableCache() {
        if (!this.cacheEnabled) {
            return;
        }
        this.cacheEnabled = false;
        this.ioEngine.shutdown();
        this.scheduleThreadPool.shutdown();
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i].interrupt();
        }
        this.ramCache.clear();
        if (!this.ioEngine.isPersistent() || this.persistencePath == null) {
            this.backingMap.clear();
        }
    }

    private void join() throws InterruptedException {
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i].join();
        }
    }

    @Override
    public void shutdown() {
        this.disableCache();
        LOG.info((Object)("Shutdown bucket cache: IO persistent=" + this.ioEngine.isPersistent() + "; path to write=" + this.persistencePath));
        if (this.ioEngine.isPersistent() && this.persistencePath != null) {
            try {
                this.join();
                this.persistToFile();
            }
            catch (IOException ex) {
                LOG.error((Object)("Unable to persist data on exit: " + ex.toString()), (Throwable)ex);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Failed to persist data on exit", (Throwable)e);
            }
        }
    }

    @Override
    public CacheStats getStats() {
        return this.cacheStats;
    }

    public BucketAllocator getAllocator() {
        return this.bucketAllocator;
    }

    @Override
    public long heapSize() {
        return this.heapSize.get();
    }

    @Override
    public long size() {
        return this.realCacheSize.get();
    }

    @Override
    public long getFreeSize() {
        return this.bucketAllocator.getFreeSize();
    }

    @Override
    public long getBlockCount() {
        return this.blockNumber.get();
    }

    @Override
    public long getCurrentSize() {
        return this.bucketAllocator.getUsedSize();
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        NavigableSet<BlockCacheKey> keySet = this.blocksByHFile.subSet(new BlockCacheKey(hfileName, Long.MIN_VALUE), true, new BlockCacheKey(hfileName, Long.MAX_VALUE), true);
        int numEvicted = 0;
        for (BlockCacheKey key : keySet) {
            if (!this.evictBlock(key)) continue;
            ++numEvicted;
        }
        return numEvicted;
    }

    void stopWriterThreads() throws InterruptedException {
        for (WriterThread writerThread : this.writerThreads) {
            writerThread.disableWriter();
            writerThread.interrupt();
            writerThread.join();
        }
    }

    @Override
    public Iterator<CachedBlock> iterator() {
        final Iterator i = this.backingMap.entrySet().iterator();
        return new Iterator<CachedBlock>(){
            private final long now = System.nanoTime();

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public CachedBlock next() {
                final Map.Entry e = (Map.Entry)i.next();
                return new CachedBlock(){

                    public String toString() {
                        return BlockCacheUtil.toString(this, now);
                    }

                    @Override
                    public BlockPriority getBlockPriority() {
                        return ((BucketEntry)e.getValue()).getPriority();
                    }

                    @Override
                    public BlockType getBlockType() {
                        return null;
                    }

                    @Override
                    public long getOffset() {
                        return ((BlockCacheKey)e.getKey()).getOffset();
                    }

                    @Override
                    public long getSize() {
                        return ((BucketEntry)e.getValue()).getLength();
                    }

                    @Override
                    public long getCachedTime() {
                        return ((BucketEntry)e.getValue()).getCachedTime();
                    }

                    @Override
                    public String getFilename() {
                        return ((BlockCacheKey)e.getKey()).getHfileName();
                    }

                    @Override
                    public int compareTo(CachedBlock other) {
                        int diff = this.getFilename().compareTo(other.getFilename());
                        if (diff != 0) {
                            return diff;
                        }
                        diff = Long.compare(this.getOffset(), other.getOffset());
                        if (diff != 0) {
                            return diff;
                        }
                        if (other.getCachedTime() < 0L || this.getCachedTime() < 0L) {
                            throw new IllegalStateException("" + this.getCachedTime() + ", " + other.getCachedTime());
                        }
                        return Long.compare(other.getCachedTime(), this.getCachedTime());
                    }

                    public int hashCode() {
                        return ((BlockCacheKey)e.getKey()).hashCode();
                    }

                    public boolean equals(Object obj) {
                        if (obj instanceof CachedBlock) {
                            CachedBlock cb = (CachedBlock)obj;
                            return this.compareTo(cb) == 0;
                        }
                        return false;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public BlockCache[] getBlockCaches() {
        return null;
    }

    @VisibleForTesting
    static class RAMQueueEntry {
        private BlockCacheKey key;
        private Cacheable data;
        private long accessCounter;
        private boolean inMemory;

        public RAMQueueEntry(BlockCacheKey bck, Cacheable data, long accessCounter, boolean inMemory) {
            this.key = bck;
            this.data = data;
            this.accessCounter = accessCounter;
            this.inMemory = inMemory;
        }

        public Cacheable getData() {
            return this.data;
        }

        public BlockCacheKey getKey() {
            return this.key;
        }

        public void access(long accessCounter) {
            this.accessCounter = accessCounter;
        }

        public BucketEntry writeToCache(IOEngine ioEngine, BucketAllocator bucketAllocator, UniqueIndexMap<Integer> deserialiserMap, AtomicLong realCacheSize) throws CacheFullException, IOException, BucketAllocatorException {
            int len = this.data.getSerializedLength();
            if (len == 0) {
                return null;
            }
            long offset = bucketAllocator.allocateBlock(len);
            BucketEntry bucketEntry = new BucketEntry(offset, len, this.accessCounter, this.inMemory);
            bucketEntry.setDeserialiserReference(this.data.getDeserializer(), deserialiserMap);
            try {
                if (this.data instanceof HFileBlock) {
                    HFileBlock block = (HFileBlock)this.data;
                    ByteBuffer sliceBuf = block.getBufferReadOnly();
                    ByteBuffer metadata = block.getMetaData();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Write offset=" + offset + ", len=" + len));
                    }
                    ioEngine.write(sliceBuf, offset);
                    ioEngine.write(metadata, offset + (long)len - (long)metadata.limit());
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(len);
                    this.data.serialize(bb);
                    ioEngine.write(bb, offset);
                }
            }
            catch (IOException ioe) {
                bucketAllocator.freeBlock(offset);
                throw ioe;
            }
            realCacheSize.addAndGet(len);
            return bucketEntry;
        }
    }

    private class BucketEntryGroup
    implements Comparable<BucketEntryGroup> {
        private CachedEntryQueue queue;
        private long totalSize = 0L;
        private long bucketSize;

        public BucketEntryGroup(long bytesToFree, long blockSize, long bucketSize) {
            this.bucketSize = bucketSize;
            this.queue = new CachedEntryQueue(bytesToFree, blockSize);
            this.totalSize = 0L;
        }

        public void add(Map.Entry<BlockCacheKey, BucketEntry> block) {
            this.totalSize += (long)block.getValue().getLength();
            this.queue.add(block);
        }

        public long free(long toFree) {
            Map.Entry<BlockCacheKey, BucketEntry> entry;
            long freedBytes = 0L;
            while ((entry = this.queue.pollLast()) != null) {
                BucketCache.this.evictBlock(entry.getKey());
                if ((freedBytes += (long)entry.getValue().getLength()) < toFree) continue;
                return freedBytes;
            }
            return freedBytes;
        }

        public long overflow() {
            return this.totalSize - this.bucketSize;
        }

        public long totalSize() {
            return this.totalSize;
        }

        @Override
        public int compareTo(BucketEntryGroup that) {
            return Long.compare(this.overflow(), that.overflow());
        }

        public boolean equals(Object that) {
            return this == that;
        }
    }

    static class BucketEntry
    implements Serializable {
        private static final long serialVersionUID = -6741504807982257534L;
        static final Comparator<BucketEntry> COMPARATOR = new Comparator<BucketEntry>(){

            @Override
            public int compare(BucketEntry o1, BucketEntry o2) {
                return Long.compare(o2.accessCounter, o1.accessCounter);
            }
        };
        private int offsetBase;
        private int length;
        private byte offset1;
        byte deserialiserIndex;
        private volatile long accessCounter;
        private BlockPriority priority;
        private final long cachedTime = System.nanoTime();

        BucketEntry(long offset, int length, long accessCounter, boolean inMemory) {
            this.setOffset(offset);
            this.length = length;
            this.accessCounter = accessCounter;
            this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
        }

        long offset() {
            long o = (long)this.offsetBase & 0xFFFFFFFFL;
            return (o += ((long)this.offset1 & 0xFFL) << 32) << 8;
        }

        private void setOffset(long value) {
            assert ((value & 0xFFL) == 0L);
            this.offsetBase = (int)(value >>= 8);
            this.offset1 = (byte)(value >> 32);
        }

        public int getLength() {
            return this.length;
        }

        protected CacheableDeserializer<Cacheable> deserializerReference(UniqueIndexMap<Integer> deserialiserMap) {
            return CacheableDeserializerIdManager.getDeserializer(deserialiserMap.unmap(this.deserialiserIndex));
        }

        protected void setDeserialiserReference(CacheableDeserializer<Cacheable> deserializer, UniqueIndexMap<Integer> deserialiserMap) {
            this.deserialiserIndex = (byte)deserialiserMap.map(deserializer.getDeserialiserIdentifier());
        }

        public void access(long accessCounter) {
            this.accessCounter = accessCounter;
            if (this.priority == BlockPriority.SINGLE) {
                this.priority = BlockPriority.MULTI;
            }
        }

        public BlockPriority getPriority() {
            return this.priority;
        }

        public long getCachedTime() {
            return this.cachedTime;
        }
    }

    @VisibleForTesting
    class WriterThread
    extends HasThread {
        private final BlockingQueue<RAMQueueEntry> inputQueue;
        private volatile boolean writerEnabled;

        WriterThread(BlockingQueue<RAMQueueEntry> queue) {
            super("BucketCacheWriterThread");
            this.writerEnabled = true;
            this.inputQueue = queue;
        }

        @VisibleForTesting
        void disableWriter() {
            this.writerEnabled = false;
        }

        @Override
        public void run() {
            List<RAMQueueEntry> entries = new ArrayList<RAMQueueEntry>();
            try {
                while (BucketCache.this.cacheEnabled && this.writerEnabled) {
                    try {
                        try {
                            entries = BucketCache.getRAMQueueEntries(this.inputQueue, entries);
                        }
                        catch (InterruptedException ie) {
                            if (!BucketCache.this.cacheEnabled) break;
                        }
                        this.doDrain(entries);
                    }
                    catch (Exception ioe) {
                        LOG.error((Object)"WriterThread encountered error", (Throwable)ioe);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)"Failed doing drain", t);
            }
            LOG.info((Object)(this.getName() + " exiting, cacheEnabled=" + BucketCache.this.cacheEnabled));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        void doDrain(List<RAMQueueEntry> entries) throws InterruptedException {
            if (entries.isEmpty()) {
                return;
            }
            int size = entries.size();
            BucketEntry[] bucketEntries = new BucketEntry[size];
            int index = 0;
            while (BucketCache.this.cacheEnabled && index < size) {
                RAMQueueEntry re = null;
                try {
                    BucketEntry bucketEntry;
                    re = entries.get(index);
                    if (re == null) {
                        LOG.warn((Object)"Couldn't get entry or changed on us; who else is messing with it?");
                        ++index;
                        continue;
                    }
                    bucketEntries[index] = bucketEntry = re.writeToCache(BucketCache.this.ioEngine, BucketCache.this.bucketAllocator, BucketCache.this.deserialiserMap, BucketCache.this.realCacheSize);
                    if (BucketCache.this.ioErrorStartTime > 0L) {
                        BucketCache.this.ioErrorStartTime = -1L;
                    }
                    ++index;
                }
                catch (BucketAllocatorException fle) {
                    LOG.warn((Object)("Failed allocation for " + (re == null ? "" : re.getKey()) + "; " + fle));
                    bucketEntries[index] = null;
                    ++index;
                }
                catch (CacheFullException cfe) {
                    if (!BucketCache.this.freeInProgress) {
                        BucketCache.this.freeSpace("Full!");
                        continue;
                    }
                    Thread.sleep(50L);
                }
                catch (IOException ioex) {
                    LOG.error((Object)"Failed writing to bucket cache", (Throwable)ioex);
                    BucketCache.this.checkIOErrorIsTolerated();
                }
            }
            try {
                BucketCache.this.ioEngine.sync();
            }
            catch (IOException ioex) {
                LOG.error((Object)"Failed syncing IO engine", (Throwable)ioex);
                BucketCache.this.checkIOErrorIsTolerated();
                for (int i = 0; i < entries.size(); ++i) {
                    if (bucketEntries[i] == null) continue;
                    BucketCache.this.bucketAllocator.freeBlock(bucketEntries[i].offset());
                    bucketEntries[i] = null;
                }
            }
            for (int i = 0; i < size; ++i) {
                RAMQueueEntry ramCacheEntry;
                BlockCacheKey key = entries.get(i).getKey();
                if (bucketEntries[i] != null) {
                    BucketCache.this.backingMap.put(key, bucketEntries[i]);
                }
                if ((ramCacheEntry = (RAMQueueEntry)BucketCache.this.ramCache.remove(key)) != null) {
                    BucketCache.this.heapSize.addAndGet(-1L * entries.get(i).getData().heapSize());
                    continue;
                }
                if (bucketEntries[i] == null) continue;
                ReentrantReadWriteLock lock = BucketCache.this.offsetLock.getLock(bucketEntries[i].offset());
                try {
                    lock.writeLock().lock();
                    if (!BucketCache.this.backingMap.remove(key, bucketEntries[i])) continue;
                    BucketCache.this.blockEvicted(key, bucketEntries[i], false);
                    continue;
                }
                finally {
                    lock.writeLock().unlock();
                }
            }
            long used = BucketCache.this.bucketAllocator.getUsedSize();
            if (used > BucketCache.this.acceptableSize()) {
                BucketCache.this.freeSpace("Used=" + used + " > acceptable=" + BucketCache.this.acceptableSize());
            }
        }
    }

    private static class StatisticsThread
    extends Thread {
        private final BucketCache bucketCache;

        public StatisticsThread(BucketCache bucketCache) {
            super("BucketCacheStatsThread");
            this.setDaemon(true);
            this.bucketCache = bucketCache;
        }

        @Override
        public void run() {
            this.bucketCache.logStats();
        }
    }
}

