/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.FastLongHistogram;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableMetric;

@InterfaceAudience.Private
public class MutableHistogram
extends MutableMetric
implements MetricHistogram {
    protected final FastLongHistogram histogram;
    protected final String name;
    protected final String desc;
    protected final Counter counter = new Counter(0L);
    private boolean metricsInfoStringInited = false;
    private String NUM_OPS_METRIC;
    private String MIN_METRIC;
    private String MAX_METRIC;
    private String MEAN_METRIC;
    private String MEDIAN_METRIC;
    private String TWENTY_FIFTH_PERCENTILE_METRIC;
    private String SEVENTY_FIFTH_PERCENTILE_METRIC;
    private String NINETIETH_PERCENTILE_METRIC;
    private String NINETY_FIFTH_PERCENTILE_METRIC;
    private String NINETY_EIGHTH_PERCENTILE_METRIC;
    private String NINETY_NINETH_PERCENTILE_METRIC;
    private String NINETY_NINE_POINT_NINETH_PERCENTILE_METRIC;

    public MutableHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableHistogram(String name, String description) {
        this(name, description, -4L);
    }

    protected MutableHistogram(String name, String description, long maxExpected) {
        this.name = StringUtils.capitalize(name);
        this.desc = StringUtils.uncapitalize(description);
        this.histogram = new FastLongHistogram(255, 1L, maxExpected);
    }

    @Override
    public void add(long val) {
        this.counter.increment();
        this.histogram.add(val, 1L);
    }

    public long getMax() {
        return this.histogram.getMax();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        FastLongHistogram histo = this.histogram.reset();
        if (histo != null) {
            this.updateSnapshotMetrics(metricsRecordBuilder, histo);
        }
    }

    protected void updateSnapshotMetrics(MetricsRecordBuilder metricsRecordBuilder, FastLongHistogram histo) {
        if (!this.metricsInfoStringInited) {
            this.NUM_OPS_METRIC = this.name + "_num_ops";
            this.MIN_METRIC = this.name + "_min";
            this.MAX_METRIC = this.name + "_max";
            this.MEAN_METRIC = this.name + "_mean";
            this.MEDIAN_METRIC = this.name + "_median";
            this.TWENTY_FIFTH_PERCENTILE_METRIC = this.name + "_25th_percentile";
            this.SEVENTY_FIFTH_PERCENTILE_METRIC = this.name + "_75th_percentile";
            this.NINETIETH_PERCENTILE_METRIC = this.name + "_90th_percentile";
            this.NINETY_FIFTH_PERCENTILE_METRIC = this.name + "_95th_percentile";
            this.NINETY_EIGHTH_PERCENTILE_METRIC = this.name + "_98th_percentile";
            this.NINETY_NINETH_PERCENTILE_METRIC = this.name + "_99th_percentile";
            this.NINETY_NINE_POINT_NINETH_PERCENTILE_METRIC = this.name + "_99.9th_percentile";
            this.metricsInfoStringInited = true;
        }
        metricsRecordBuilder.addCounter(Interns.info(this.NUM_OPS_METRIC, this.desc), this.counter.get());
        metricsRecordBuilder.addGauge(Interns.info(this.MIN_METRIC, this.desc), histo.getMin());
        metricsRecordBuilder.addGauge(Interns.info(this.MAX_METRIC, this.desc), histo.getMax());
        metricsRecordBuilder.addGauge(Interns.info(this.MEAN_METRIC, this.desc), histo.getMean());
        long[] percentiles = histo.getQuantiles();
        metricsRecordBuilder.addGauge(Interns.info(this.TWENTY_FIFTH_PERCENTILE_METRIC, this.desc), percentiles[0]);
        metricsRecordBuilder.addGauge(Interns.info(this.MEDIAN_METRIC, this.desc), percentiles[1]);
        metricsRecordBuilder.addGauge(Interns.info(this.SEVENTY_FIFTH_PERCENTILE_METRIC, this.desc), percentiles[2]);
        metricsRecordBuilder.addGauge(Interns.info(this.NINETIETH_PERCENTILE_METRIC, this.desc), percentiles[3]);
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_FIFTH_PERCENTILE_METRIC, this.desc), percentiles[4]);
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_EIGHTH_PERCENTILE_METRIC, this.desc), percentiles[5]);
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_NINETH_PERCENTILE_METRIC, this.desc), percentiles[6]);
        metricsRecordBuilder.addGauge(Interns.info(this.NINETY_NINE_POINT_NINETH_PERCENTILE_METRIC, this.desc), percentiles[7]);
    }
}

