/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AMRMTokenIdentifier
extends TokenIdentifier {
    public static final Text KIND_NAME = new Text("YARN_AM_RM_TOKEN");
    private ApplicationAttemptId applicationAttemptId;

    public AMRMTokenIdentifier() {
    }

    public AMRMTokenIdentifier(ApplicationAttemptId appAttemptId) {
        this();
        this.applicationAttemptId = appAttemptId;
    }

    @InterfaceAudience.Private
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        ApplicationId appId = this.applicationAttemptId.getApplicationId();
        out.writeLong(appId.getClusterTimestamp());
        out.writeInt(appId.getId());
        out.writeInt(this.applicationAttemptId.getAttemptId());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        long clusterTimeStamp = in.readLong();
        int appId = in.readInt();
        int attemptId = in.readInt();
        ApplicationId applicationId = ApplicationId.newInstance(clusterTimeStamp, appId);
        this.applicationAttemptId = ApplicationAttemptId.newInstance(applicationId, attemptId);
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.applicationAttemptId == null || "".equals(this.applicationAttemptId.toString())) {
            return null;
        }
        return UserGroupInformation.createRemoteUser(this.applicationAttemptId.toString());
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

