/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AppsBlock
extends HtmlBlock {
    protected ApplicationContext appContext;

    @Inject
    AppsBlock(ApplicationContext appContext, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appContext;
    }

    @Override
    public void render(HtmlBlock.Block html) {
        Collection<ApplicationReport> appReports;
        this.setTitle("Applications");
        HamletSpec.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)((HamletImpl.EImp)((Object)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.THEAD)((Hamlet.TABLE)html.table("#apps")).thead()).tr()).th(".id", "ID")).th(".user", "User")).th(".name", "Name")).th(".type", "Application Type")).th(".queue", "Queue")).th(".starttime", "StartTime")).th(".finishtime", "FinishTime")).th(".state", "State")).th(".finalstatus", "FinalStatus")).th(".progress", "Progress")).th(".ui", "Tracking UI")))._())._()).tbody();
        HashSet<YarnApplicationState> reqAppStates = null;
        String reqStateString = this.$("app.state");
        if (reqStateString != null && !reqStateString.isEmpty()) {
            String[] appStateStrings = reqStateString.split(",");
            reqAppStates = new HashSet<YarnApplicationState>(appStateStrings.length);
            for (String stateString : appStateStrings) {
                reqAppStates.add(YarnApplicationState.valueOf(stateString));
            }
        }
        try {
            appReports = this.appContext.getAllApplications().values();
        }
        catch (IOException e) {
            String message = "Failed to read the applications.";
            LOG.error(message, (Throwable)e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (ApplicationReport appReport : appReports) {
            if (reqAppStates != null && !reqAppStates.contains((Object)appReport.getYarnApplicationState())) continue;
            AppInfo app = new AppInfo(appReport);
            String percent = String.format("%.1f", Float.valueOf(app.getProgress()));
            appsTableData.append("[\"<a href='").append(this.url("app", app.getAppId())).append("'>").append(app.getAppId()).append("</a>\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(app.getUser()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(app.getName()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(app.getType()))).append("\",\"").append(StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(app.getQueue()))).append("\",\"").append(app.getStartedTime()).append("\",\"").append(app.getFinishedTime()).append("\",\"").append((Object)app.getAppState()).append("\",\"").append((Object)app.getFinalAppStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join(percent, Character.valueOf('%'))).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join("width:", percent, Character.valueOf('%'))).append("'> </div> </div>").append("\",\"<a href='");
            String trackingURL = app.getTrackingUrl() == null ? "#" : app.getTrackingUrl();
            appsTableData.append(trackingURL).append("'>").append("History").append("</a>\"],\n");
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"var appsTableData=" + appsTableData})))._();
        ((Hamlet.TABLE)((HamletImpl.EImp)((Object)tbody))._())._();
    }
}

