/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.AgeSnapshot;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.util.FastLongHistogram;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapter;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonReader;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;

@InterfaceAudience.Private
public class BlockCacheUtil {
    private static final Gson GSON = GsonUtil.createGson().registerTypeAdapter((Type)((Object)FastLongHistogram.class), new TypeAdapter<FastLongHistogram>(){

        @Override
        public void write(JsonWriter out, FastLongHistogram value) throws IOException {
            AgeSnapshot snapshot = new AgeSnapshot(value);
            out.beginObject();
            out.name("mean").value(snapshot.getMean());
            out.name("min").value(snapshot.getMin());
            out.name("max").value(snapshot.getMax());
            out.name("75thPercentile").value(snapshot.get75thPercentile());
            out.name("95thPercentile").value(snapshot.get95thPercentile());
            out.name("98thPercentile").value(snapshot.get98thPercentile());
            out.name("99thPercentile").value(snapshot.get99thPercentile());
            out.name("999thPercentile").value(snapshot.get999thPercentile());
            out.endObject();
        }

        @Override
        public FastLongHistogram read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }).setPrettyPrinting().create();

    public static String toString(CachedBlock cb, long now) {
        return "filename=" + cb.getFilename() + ", " + BlockCacheUtil.toStringMinusFileName(cb, now);
    }

    public static String toJSON(String filename, NavigableSet<CachedBlock> blocks) throws IOException {
        CachedBlockCountsPerFile counts = new CachedBlockCountsPerFile(filename);
        for (CachedBlock cb : blocks) {
            counts.count++;
            counts.size += cb.getSize();
            BlockType bt = cb.getBlockType();
            if (bt == null || !bt.isData()) continue;
            counts.countData++;
            counts.sizeData += cb.getSize();
        }
        return GSON.toJson(counts);
    }

    public static String toJSON(CachedBlocksByFile cbsbf) throws IOException {
        return GSON.toJson(cbsbf);
    }

    public static String toJSON(BlockCache bc) throws IOException {
        return GSON.toJson(bc);
    }

    public static String toStringMinusFileName(CachedBlock cb, long now) {
        return "offset=" + cb.getOffset() + ", size=" + cb.getSize() + ", age=" + (now - cb.getCachedTime()) + ", type=" + (Object)((Object)cb.getBlockType()) + ", priority=" + (Object)((Object)cb.getBlockPriority());
    }

    public static CachedBlocksByFile getLoadedCachedBlocksByFile(Configuration conf, BlockCache bc) {
        CachedBlocksByFile cbsbf = new CachedBlocksByFile(conf);
        for (CachedBlock cb : bc) {
            if (cbsbf.update(cb)) break;
        }
        return cbsbf;
    }

    public static class CachedBlocksByFile {
        private int count;
        private int dataBlockCount;
        private long size;
        private long dataSize;
        private final long now = System.nanoTime();
        private final int max;
        public static final int DEFAULT_MAX = 1000000;
        private transient NavigableMap<String, NavigableSet<CachedBlock>> cachedBlockByFile = new ConcurrentSkipListMap<String, NavigableSet<CachedBlock>>();
        FastLongHistogram hist = new FastLongHistogram();

        CachedBlocksByFile() {
            this(null);
        }

        CachedBlocksByFile(Configuration c) {
            this.max = c == null ? 1000000 : c.getInt("hbase.ui.blockcache.by.file.max", 1000000);
        }

        public boolean update(CachedBlock cb) {
            if (this.isFull()) {
                return true;
            }
            ConcurrentSkipListSet<CachedBlock> set = (ConcurrentSkipListSet<CachedBlock>)this.cachedBlockByFile.get(cb.getFilename());
            if (set == null) {
                set = new ConcurrentSkipListSet<CachedBlock>();
                this.cachedBlockByFile.put(cb.getFilename(), set);
            }
            set.add(cb);
            this.size += cb.getSize();
            ++this.count;
            BlockType bt = cb.getBlockType();
            if (bt != null && bt.isData()) {
                ++this.dataBlockCount;
                this.dataSize += cb.getSize();
            }
            long age = this.now - cb.getCachedTime();
            this.hist.add(age, 1L);
            return false;
        }

        public boolean isFull() {
            return this.count >= this.max;
        }

        public NavigableMap<String, NavigableSet<CachedBlock>> getCachedBlockStatsByFile() {
            return this.cachedBlockByFile;
        }

        public int getCount() {
            return this.count;
        }

        public int getDataCount() {
            return this.dataBlockCount;
        }

        public long getSize() {
            return this.size;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public AgeSnapshot getAgeInCacheSnapshot() {
            return new AgeSnapshot(this.hist);
        }

        public String toString() {
            AgeSnapshot snapshot = this.getAgeInCacheSnapshot();
            return "count=" + this.count + ", dataBlockCount=" + this.dataBlockCount + ", size=" + this.size + ", dataSize=" + this.getDataSize() + ", mean age=" + snapshot.getMean() + ", min age=" + snapshot.getMin() + ", max age=" + snapshot.getMax() + ", 75th percentile age=" + snapshot.get75thPercentile() + ", 95th percentile age=" + snapshot.get95thPercentile() + ", 98th percentile age=" + snapshot.get98thPercentile() + ", 99th percentile age=" + snapshot.get99thPercentile() + ", 99.9th percentile age=" + snapshot.get99thPercentile();
        }
    }

    static class CachedBlockCountsPerFile {
        private int count = 0;
        private long size = 0L;
        private int countData = 0;
        private long sizeData = 0L;
        private final String filename;

        CachedBlockCountsPerFile(String filename) {
            this.filename = filename;
        }

        public int getCount() {
            return this.count;
        }

        public long getSize() {
            return this.size;
        }

        public int getCountData() {
            return this.countData;
        }

        public long getSizeData() {
            return this.sizeData;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

