/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormatReader;
import org.apache.hadoop.hbase.procedure2.util.ByteSlot;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ProcedureWALFormat {
    static final byte LOG_TYPE_STREAM = 0;
    static final byte LOG_TYPE_COMPACTED = 1;
    static final byte LOG_TYPE_MAX_VALID = 1;
    static final byte HEADER_VERSION = 1;
    static final byte TRAILER_VERSION = 1;
    static final long HEADER_MAGIC = 3564119998633046608L;
    static final long TRAILER_MAGIC = 5796804896788084273L;

    private ProcedureWALFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Iterator<ProcedureWALFile> logs, ProcedureStoreTracker tracker, Loader loader) throws IOException {
        ProcedureWALFormatReader reader = new ProcedureWALFormatReader(tracker);
        tracker.setKeepDeletes(true);
        try {
            while (logs.hasNext()) {
                log.open();
                try (ProcedureWALFile log = logs.next();){
                    reader.read(log, loader);
                }
            }
            reader.finalize(loader);
            tracker.setPartialFlag(false);
            tracker.resetUpdates();
        }
        finally {
            tracker.setKeepDeletes(false);
        }
    }

    public static void writeHeader(OutputStream stream, ProcedureProtos.ProcedureWALHeader header) throws IOException {
        header.writeDelimitedTo(stream);
    }

    public static long writeTrailer(FSDataOutputStream stream, ProcedureStoreTracker tracker) throws IOException {
        long offset = stream.getPos();
        ProcedureProtos.ProcedureWALEntry.newBuilder().setType(ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_EOF).build().writeDelimitedTo(stream);
        tracker.writeTo(stream);
        stream.write(1);
        StreamUtils.writeLong(stream, 5796804896788084273L);
        StreamUtils.writeLong(stream, offset);
        return stream.getPos() - offset;
    }

    public static ProcedureProtos.ProcedureWALHeader readHeader(InputStream stream) throws IOException {
        ProcedureProtos.ProcedureWALHeader header;
        try {
            header = ProcedureProtos.ProcedureWALHeader.parseDelimitedFrom(stream);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidWALDataException(e);
        }
        if (header == null) {
            throw new InvalidWALDataException("No data available to read the Header");
        }
        if (header.getVersion() < 0 || header.getVersion() != 1) {
            throw new InvalidWALDataException("Invalid Header version. got " + header.getVersion() + " expected " + 1);
        }
        if (header.getType() < 0 || header.getType() > 1) {
            throw new InvalidWALDataException("Invalid header type. got " + header.getType());
        }
        return header;
    }

    public static ProcedureProtos.ProcedureWALTrailer readTrailer(FSDataInputStream stream, long startPos, long size) throws IOException {
        long trailerPos = size - 17L;
        if (trailerPos < startPos) {
            throw new InvalidWALDataException("Missing trailer: size=" + size + " startPos=" + startPos);
        }
        stream.seek(trailerPos);
        int version = stream.read();
        if (version != 1) {
            throw new InvalidWALDataException("Invalid Trailer version. got " + version + " expected " + 1);
        }
        long magic = StreamUtils.readLong(stream);
        if (magic != 5796804896788084273L) {
            throw new InvalidWALDataException("Invalid Trailer magic. got " + magic + " expected " + 5796804896788084273L);
        }
        long trailerOffset = StreamUtils.readLong(stream);
        stream.seek(trailerOffset);
        ProcedureProtos.ProcedureWALEntry entry = ProcedureWALFormat.readEntry(stream);
        if (entry.getType() != ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_EOF) {
            throw new InvalidWALDataException("Invalid Trailer begin");
        }
        ProcedureProtos.ProcedureWALTrailer trailer = ProcedureProtos.ProcedureWALTrailer.newBuilder().setVersion(version).setTrackerPos(stream.getPos()).build();
        return trailer;
    }

    public static ProcedureProtos.ProcedureWALEntry readEntry(InputStream stream) throws IOException {
        return ProcedureProtos.ProcedureWALEntry.parseDelimitedFrom(stream);
    }

    public static void writeEntry(ByteSlot slot, ProcedureProtos.ProcedureWALEntry.Type type, Procedure proc, Procedure[] subprocs) throws IOException {
        ProcedureProtos.ProcedureWALEntry.Builder builder = ProcedureProtos.ProcedureWALEntry.newBuilder();
        builder.setType(type);
        builder.addProcedure(Procedure.convert(proc));
        if (subprocs != null) {
            for (int i = 0; i < subprocs.length; ++i) {
                builder.addProcedure(Procedure.convert(subprocs[i]));
            }
        }
        builder.build().writeDelimitedTo(slot);
    }

    public static void writeInsert(ByteSlot slot, Procedure proc) throws IOException {
        ProcedureWALFormat.writeEntry(slot, ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_INIT, proc, null);
    }

    public static void writeInsert(ByteSlot slot, Procedure proc, Procedure[] subprocs) throws IOException {
        ProcedureWALFormat.writeEntry(slot, ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_INSERT, proc, subprocs);
    }

    public static void writeUpdate(ByteSlot slot, Procedure proc) throws IOException {
        ProcedureWALFormat.writeEntry(slot, ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_UPDATE, proc, null);
    }

    public static void writeDelete(ByteSlot slot, long procId) throws IOException {
        ProcedureProtos.ProcedureWALEntry.Builder builder = ProcedureProtos.ProcedureWALEntry.newBuilder();
        builder.setType(ProcedureProtos.ProcedureWALEntry.Type.PROCEDURE_WAL_DELETE);
        builder.setProcId(procId);
        builder.build().writeDelimitedTo(slot);
    }

    static interface Loader
    extends ProcedureStore.ProcedureLoader {
        public void markCorruptedWAL(ProcedureWALFile var1, IOException var2);
    }

    @InterfaceAudience.Private
    public static class InvalidWALDataException
    extends IOException {
        public InvalidWALDataException(String s) {
            super(s);
        }

        public InvalidWALDataException(Throwable t) {
            super(t);
        }
    }
}

