/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class CellSkipListSet
implements NavigableSet<Cell> {
    private final ConcurrentNavigableMap<Cell, Cell> delegatee;

    CellSkipListSet(KeyValue.KVComparator c) {
        this.delegatee = new ConcurrentSkipListMap<Cell, Cell>(c);
    }

    CellSkipListSet(ConcurrentNavigableMap<Cell, Cell> m) {
        this.delegatee = m;
    }

    @Override
    public Cell ceiling(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<Cell> descendingIterator() {
        return this.delegatee.descendingMap().values().iterator();
    }

    @Override
    public NavigableSet<Cell> descendingSet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell floor(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> headSet(Cell toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<Cell> headSet(Cell toElement, boolean inclusive) {
        return new CellSkipListSet((ConcurrentNavigableMap<Cell, Cell>)this.delegatee.headMap((Object)toElement, inclusive));
    }

    @Override
    public Cell higher(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.delegatee.values().iterator();
    }

    @Override
    public Cell lower(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell pollFirst() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell pollLast() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> subSet(Cell fromElement, Cell toElement) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public NavigableSet<Cell> subSet(Cell fromElement, boolean fromInclusive, Cell toElement, boolean toInclusive) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> tailSet(Cell fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<Cell> tailSet(Cell fromElement, boolean inclusive) {
        return new CellSkipListSet((ConcurrentNavigableMap<Cell, Cell>)this.delegatee.tailMap((Object)fromElement, inclusive));
    }

    @Override
    public Comparator<? super Cell> comparator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell first() {
        return (Cell)this.delegatee.get(this.delegatee.firstKey());
    }

    @Override
    public Cell last() {
        return (Cell)this.delegatee.get(this.delegatee.lastKey());
    }

    @Override
    public boolean add(Cell e) {
        return this.delegatee.put(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends Cell> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clear() {
        this.delegatee.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegatee.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this.delegatee.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegatee.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Cell get(Cell kv) {
        return (Cell)this.delegatee.get(kv);
    }

    @Override
    public int size() {
        if (this.delegatee instanceof ConcurrentSkipListMap) {
            throw new UnsupportedOperationException("ConcurrentSkipListMap.size() is time-consuming");
        }
        return this.delegatee.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @VisibleForTesting
    int sizeForTests() {
        return this.delegatee.size();
    }
}

