/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;

@InterfaceAudience.Private
public class MetricsRegionServerSourceFactoryImpl
implements MetricsRegionServerSourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MetricsRegionAggregateSourceImpl getAggregate() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.aggImpl == null) {
                FactoryStorage.INSTANCE.aggImpl = new MetricsRegionAggregateSourceImpl();
            }
            return FactoryStorage.INSTANCE.aggImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MetricsTableAggregateSourceImpl getTableAggregate() {
        Object object = FactoryStorage.INSTANCE.aggLock;
        synchronized (object) {
            if (FactoryStorage.INSTANCE.tblAggImpl == null) {
                FactoryStorage.INSTANCE.tblAggImpl = new MetricsTableAggregateSourceImpl();
            }
            return FactoryStorage.INSTANCE.tblAggImpl;
        }
    }

    @Override
    public synchronized MetricsRegionServerSource createServer(MetricsRegionServerWrapper regionServerWrapper) {
        return new MetricsRegionServerSourceImpl(regionServerWrapper);
    }

    @Override
    public MetricsRegionSource createRegion(MetricsRegionWrapper wrapper) {
        return new MetricsRegionSourceImpl(wrapper, this.getAggregate());
    }

    @Override
    public MetricsTableSource createTable(String table, MetricsTableWrapperAggregate wrapper) {
        return new MetricsTableSourceImpl(table, this.getTableAggregate(), wrapper);
    }

    public static enum FactoryStorage {
        INSTANCE;

        private Object aggLock = new Object();
        private MetricsRegionAggregateSourceImpl aggImpl;
        private MetricsTableAggregateSourceImpl tblAggImpl;
    }
}

