/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceFactory;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class MetricsSource {
    private Map<String, Long> lastTimeStamps = new HashMap<String, Long>();
    private long lastHFileRefsQueueSize = 0L;
    private String id;
    private final MetricsReplicationSourceSource singleSourceSource;
    private final MetricsReplicationSourceSource globalSourceSource;
    private Map<String, MetricsReplicationSourceSource> singleSourceSourceByTable;

    public MetricsSource(String id) {
        this.id = id;
        this.singleSourceSource = CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getSource(id);
        this.globalSourceSource = CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getGlobalSource();
        this.singleSourceSourceByTable = new HashMap<String, MetricsReplicationSourceSource>();
    }

    public MetricsSource(String id, MetricsReplicationSourceSource singleSourceSource, MetricsReplicationSourceSource globalSourceSource, Map<String, MetricsReplicationSourceSource> singleSourceSourceByTable) {
        this.id = id;
        this.singleSourceSource = singleSourceSource;
        this.globalSourceSource = globalSourceSource;
        this.singleSourceSourceByTable = singleSourceSourceByTable;
    }

    public void setAgeOfLastShippedOp(long timestamp, String walGroup) {
        long age = EnvironmentEdgeManager.currentTime() - timestamp;
        this.singleSourceSource.setLastShippedAge(age);
        this.globalSourceSource.setLastShippedAge(Math.max(age, this.globalSourceSource.getLastShippedAge()));
        this.lastTimeStamps.put(walGroup, timestamp);
    }

    public void setAgeOfLastShippedOpByTable(long timestamp, String tableName) {
        long age = EnvironmentEdgeManager.currentTime() - timestamp;
        if (!this.getSingleSourceSourceByTable().containsKey(tableName)) {
            this.getSingleSourceSourceByTable().put(tableName, CompatibilitySingletonFactory.getInstance(MetricsReplicationSourceFactory.class).getSource(tableName));
        }
        this.singleSourceSourceByTable.get(tableName).setLastShippedAge(age);
    }

    public void refreshAgeOfLastShippedOp(String walGroupId) {
        Long lastTimestamp = this.lastTimeStamps.get(walGroupId);
        if (lastTimestamp == null) {
            this.lastTimeStamps.put(walGroupId, 0L);
            lastTimestamp = 0L;
        }
        if (lastTimestamp > 0L) {
            this.setAgeOfLastShippedOp(lastTimestamp, walGroupId);
        }
    }

    public void incrSizeOfLogQueue() {
        this.singleSourceSource.incrSizeOfLogQueue(1);
        this.globalSourceSource.incrSizeOfLogQueue(1);
    }

    public void decrSizeOfLogQueue() {
        this.singleSourceSource.decrSizeOfLogQueue(1);
        this.globalSourceSource.decrSizeOfLogQueue(1);
    }

    private void incrLogEditsRead(long delta) {
        this.singleSourceSource.incrLogReadInEdits(delta);
        this.globalSourceSource.incrLogReadInEdits(delta);
    }

    public void incrLogEditsRead() {
        this.incrLogEditsRead(1L);
    }

    public void incrLogEditsFiltered(long delta) {
        this.singleSourceSource.incrLogEditsFiltered(delta);
        this.globalSourceSource.incrLogEditsFiltered(delta);
    }

    public void incrLogEditsFiltered() {
        this.incrLogEditsFiltered(1L);
    }

    public void shipBatch(long batchSize, int sizeInBytes) {
        this.singleSourceSource.incrBatchesShipped(1);
        this.globalSourceSource.incrBatchesShipped(1);
        this.singleSourceSource.incrOpsShipped(batchSize);
        this.globalSourceSource.incrOpsShipped(batchSize);
        this.singleSourceSource.incrShippedBytes(sizeInBytes);
        this.globalSourceSource.incrShippedBytes(sizeInBytes);
    }

    public void shipBatch(long batchSize, int sizeInBytes, long hfiles) {
        this.shipBatch(batchSize, sizeInBytes);
        this.singleSourceSource.incrHFilesShipped(hfiles);
        this.globalSourceSource.incrHFilesShipped(hfiles);
    }

    public void incrLogReadInBytes(long readInBytes) {
        this.singleSourceSource.incrLogReadInBytes(readInBytes);
        this.globalSourceSource.incrLogReadInBytes(readInBytes);
    }

    public void clear() {
        int lastQueueSize = this.singleSourceSource.getSizeOfLogQueue();
        this.globalSourceSource.decrSizeOfLogQueue(lastQueueSize);
        this.singleSourceSource.decrSizeOfLogQueue(lastQueueSize);
        this.singleSourceSource.clear();
        this.globalSourceSource.decrSizeOfHFileRefsQueue(this.lastHFileRefsQueueSize);
        this.lastTimeStamps.clear();
        this.lastHFileRefsQueueSize = 0L;
    }

    public Long getAgeOfLastShippedOp() {
        return this.singleSourceSource.getLastShippedAge();
    }

    public int getSizeOfLogQueue() {
        return this.singleSourceSource.getSizeOfLogQueue();
    }

    public long getTimeStampOfLastShippedOp() {
        long lastTimestamp = 0L;
        for (long ts : this.lastTimeStamps.values()) {
            if (ts <= lastTimestamp) continue;
            lastTimestamp = ts;
        }
        return lastTimestamp;
    }

    public String getPeerID() {
        return this.id;
    }

    public void incrSizeOfHFileRefsQueue(long size) {
        this.singleSourceSource.incrSizeOfHFileRefsQueue(size);
        this.globalSourceSource.incrSizeOfHFileRefsQueue(size);
        this.lastHFileRefsQueueSize = size;
    }

    public void decrSizeOfHFileRefsQueue(int size) {
        this.singleSourceSource.decrSizeOfHFileRefsQueue(size);
        this.globalSourceSource.decrSizeOfHFileRefsQueue(size);
        this.lastHFileRefsQueueSize -= (long)size;
        if (this.lastHFileRefsQueueSize < 0L) {
            this.lastHFileRefsQueueSize = 0L;
        }
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.singleSourceSource.incrUnknownFileLengthForClosedWAL();
        this.globalSourceSource.incrUnknownFileLengthForClosedWAL();
    }

    public void incrUncleanlyClosedWALs() {
        this.singleSourceSource.incrUncleanlyClosedWALs();
        this.globalSourceSource.incrUncleanlyClosedWALs();
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.singleSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
        this.globalSourceSource.incrBytesSkippedInUncleanlyClosedWALs(bytes);
    }

    public void incrRestartedWALReading() {
        this.singleSourceSource.incrRestartedWALReading();
        this.globalSourceSource.incrRestartedWALReading();
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.singleSourceSource.incrRepeatedFileBytes(bytes);
        this.globalSourceSource.incrRepeatedFileBytes(bytes);
    }

    public void incrCompletedWAL() {
        this.singleSourceSource.incrCompletedWAL();
        this.globalSourceSource.incrCompletedWAL();
    }

    public void incrCompletedRecoveryQueue() {
        this.singleSourceSource.incrCompletedRecoveryQueue();
        this.globalSourceSource.incrCompletedRecoveryQueue();
    }

    public void incrFailedRecoveryQueue() {
        this.globalSourceSource.incrFailedRecoveryQueue();
    }

    public Map<String, MetricsReplicationSourceSource> getSingleSourceSourceByTable() {
        return this.singleSourceSourceByTable;
    }
}

