/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.SequenceId;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
public class WALKey
implements SequenceId,
Comparable<WALKey> {
    private static final Log LOG = LogFactory.getLog(WALKey.class);
    private static final String PREFIX_CLUSTER_KEY = ".";
    @InterfaceAudience.Private
    protected static final Version VERSION = Version.COMPRESSED;
    public static final long NO_SEQUENCE_ID = -1L;
    @InterfaceAudience.Private
    protected byte[] encodedRegionName;
    @InterfaceAudience.Private
    protected TableName tablename;
    @InterfaceAudience.Private
    protected long logSeqNum;
    private long origLogSeqNum = 0L;
    private CountDownLatch seqNumAssignedLatch = new CountDownLatch(1);
    @InterfaceAudience.Private
    protected long writeTime;
    @InterfaceAudience.Private
    protected List<UUID> clusterIds;
    private NavigableMap<byte[], Integer> scopes;
    private long nonceGroup = 0L;
    private long nonce = 0L;
    private MultiVersionConcurrencyControl mvcc;
    private MultiVersionConcurrencyControl.WriteEntry writeEntry;
    public static final List<UUID> EMPTY_UUIDS = Collections.unmodifiableList(new ArrayList());
    @InterfaceAudience.Private
    protected CompressionContext compressionContext;

    @InterfaceAudience.Private
    public MultiVersionConcurrencyControl getMvcc() {
        return this.mvcc;
    }

    @InterfaceAudience.Private
    public MultiVersionConcurrencyControl.WriteEntry getWriteEntry() throws InterruptedIOException {
        try {
            this.seqNumAssignedLatch.await();
        }
        catch (InterruptedException ie) {
            MultiVersionConcurrencyControl mvcc = this.getMvcc();
            LOG.debug((Object)("mvcc=" + mvcc + ", writeEntry=" + this.writeEntry));
            if (mvcc != null && this.writeEntry != null) {
                mvcc.complete(this.writeEntry);
            }
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
        return this.writeEntry;
    }

    @InterfaceAudience.Private
    public void setWriteEntry(MultiVersionConcurrencyControl.WriteEntry writeEntry) {
        this.writeEntry = writeEntry;
        this.seqNumAssignedLatch.countDown();
    }

    public WALKey() {
        this.init(null, null, 0L, Long.MAX_VALUE, new ArrayList<UUID>(), 0L, 0L, null);
    }

    @VisibleForTesting
    public WALKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, UUID clusterId) {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        clusterIds.add(clusterId);
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, 0L, 0L, null);
    }

    public WALKey(byte[] encodedRegionName, TableName tablename) {
        this(encodedRegionName, tablename, System.currentTimeMillis());
    }

    public WALKey(byte[] encodedRegionName, TableName tablename, long now) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, null);
    }

    public WALKey(byte[] encodedRegionName, TableName tablename, long now, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, -1L, now, EMPTY_UUIDS, 0L, 0L, mvcc);
    }

    public WALKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, logSeqNum, now, clusterIds, nonceGroup, nonce, mvcc);
    }

    public WALKey(byte[] encodedRegionName, TableName tablename, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, -1L, now, clusterIds, nonceGroup, nonce, mvcc);
    }

    public WALKey(byte[] encodedRegionName, TableName tablename, long logSeqNum, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.init(encodedRegionName, tablename, logSeqNum, EnvironmentEdgeManager.currentTime(), EMPTY_UUIDS, nonceGroup, nonce, mvcc);
    }

    @InterfaceAudience.Private
    protected void init(byte[] encodedRegionName, TableName tablename, long logSeqNum, long now, List<UUID> clusterIds, long nonceGroup, long nonce, MultiVersionConcurrencyControl mvcc) {
        this.logSeqNum = logSeqNum;
        this.writeTime = now;
        this.clusterIds = clusterIds;
        this.encodedRegionName = encodedRegionName;
        this.tablename = tablename;
        this.nonceGroup = nonceGroup;
        this.nonce = nonce;
        this.mvcc = mvcc;
    }

    public void setCompressionContext(CompressionContext compressionContext) {
        this.compressionContext = compressionContext;
    }

    public byte[] getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public TableName getTablename() {
        return this.tablename;
    }

    public long getLogSeqNum() {
        return this.logSeqNum;
    }

    @InterfaceAudience.Private
    public void setLogSeqNum(long sequence) {
        this.logSeqNum = sequence;
    }

    public void setOrigLogSeqNum(long seqId) {
        this.origLogSeqNum = seqId;
    }

    public long getOrigLogSeqNum() {
        return this.origLogSeqNum;
    }

    @Override
    public long getSequenceId() throws IOException {
        return this.getSequenceId(-1L);
    }

    public long getSequenceId(long maxWaitForSeqId) throws IOException {
        try {
            if (maxWaitForSeqId < 0L) {
                this.seqNumAssignedLatch.await();
            } else if (!this.seqNumAssignedLatch.await(maxWaitForSeqId, TimeUnit.MILLISECONDS)) {
                throw new TimeoutIOException("Failed to get sequenceid after " + maxWaitForSeqId + "ms; WAL system stuck or has gone away?");
            }
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)"Thread interrupted waiting for next log sequence number");
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
        return this.logSeqNum;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public NavigableMap<byte[], Integer> getScopes() {
        return this.scopes;
    }

    public long getNonceGroup() {
        return this.nonceGroup;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setScopes(NavigableMap<byte[], Integer> scopes) {
        this.scopes = scopes;
    }

    public void readOlderScopes(NavigableMap<byte[], Integer> scopes) {
        if (scopes != null) {
            Iterator iterator = scopes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry scope = iterator.next();
                String key = Bytes.toString((byte[])scope.getKey());
                if (!key.startsWith(PREFIX_CLUSTER_KEY)) continue;
                this.addClusterId(UUID.fromString(key.substring(PREFIX_CLUSTER_KEY.length())));
                iterator.remove();
            }
            if (scopes.size() > 0) {
                this.scopes = scopes;
            }
        }
    }

    public void addClusterId(UUID clusterId) {
        if (!this.clusterIds.contains(clusterId)) {
            this.clusterIds.add(clusterId);
        }
    }

    public List<UUID> getClusterIds() {
        return this.clusterIds;
    }

    public UUID getOriginatingClusterId() {
        return this.clusterIds.isEmpty() ? HConstants.DEFAULT_CLUSTER_ID : this.clusterIds.get(0);
    }

    public String toString() {
        return this.tablename + "/" + Bytes.toString(this.encodedRegionName) + "/" + this.logSeqNum;
    }

    public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", this.tablename);
        stringMap.put("region", Bytes.toStringBinary(this.encodedRegionName));
        stringMap.put("sequence", this.logSeqNum);
        return stringMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((WALKey)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.encodedRegionName);
        result = (int)((long)result ^ this.logSeqNum);
        result = (int)((long)result ^ this.writeTime);
        return result;
    }

    @Override
    public int compareTo(WALKey o) {
        int result = Bytes.compareTo(this.encodedRegionName, o.encodedRegionName);
        if (result == 0) {
            if (this.logSeqNum < o.logSeqNum) {
                result = -1;
            } else if (this.logSeqNum > o.logSeqNum) {
                result = 1;
            }
            if (result == 0) {
                if (this.writeTime < o.writeTime) {
                    result = -1;
                } else if (this.writeTime > o.writeTime) {
                    return 1;
                }
            }
        }
        return result;
    }

    void internTableName(TableName tablename) {
        assert (tablename.equals(this.tablename));
        this.tablename = tablename;
    }

    void internEncodedRegionName(byte[] encodedRegionName) {
        assert (Bytes.equals(this.encodedRegionName, encodedRegionName));
        this.encodedRegionName = encodedRegionName;
    }

    public WALProtos.WALKey.Builder getBuilder(WALCellCodec.ByteStringCompressor compressor) throws IOException {
        WALProtos.WALKey.Builder builder = WALProtos.WALKey.newBuilder();
        if (this.compressionContext == null) {
            builder.setEncodedRegionName(ByteStringer.wrap(this.encodedRegionName));
            builder.setTableName(ByteStringer.wrap(this.tablename.getName()));
        } else {
            builder.setEncodedRegionName(compressor.compress(this.encodedRegionName, this.compressionContext.regionDict));
            builder.setTableName(compressor.compress(this.tablename.getName(), this.compressionContext.tableDict));
        }
        builder.setLogSequenceNumber(this.logSeqNum);
        builder.setWriteTime(this.writeTime);
        if (this.origLogSeqNum > 0L) {
            builder.setOrigSequenceNumber(this.origLogSeqNum);
        }
        if (this.nonce != 0L) {
            builder.setNonce(this.nonce);
        }
        if (this.nonceGroup != 0L) {
            builder.setNonceGroup(this.nonceGroup);
        }
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        for (UUID uUID : this.clusterIds) {
            uuidBuilder.setLeastSigBits(uUID.getLeastSignificantBits());
            uuidBuilder.setMostSigBits(uUID.getMostSignificantBits());
            builder.addClusterIds(uuidBuilder.build());
        }
        if (this.scopes != null) {
            for (Map.Entry entry : this.scopes.entrySet()) {
                ByteString family = this.compressionContext == null ? ByteStringer.wrap((byte[])entry.getKey()) : compressor.compress((byte[])entry.getKey(), this.compressionContext.familyDict);
                builder.addScopes(WALProtos.FamilyScope.newBuilder().setFamily(family).setScopeType(WALProtos.ScopeType.valueOf((Integer)entry.getValue())));
            }
        }
        return builder;
    }

    public void readFieldsFromPb(WALProtos.WALKey walKey, WALCellCodec.ByteStringUncompressor uncompressor) throws IOException {
        if (this.compressionContext != null) {
            this.encodedRegionName = uncompressor.uncompress(walKey.getEncodedRegionName(), this.compressionContext.regionDict);
            byte[] tablenameBytes = uncompressor.uncompress(walKey.getTableName(), this.compressionContext.tableDict);
            this.tablename = TableName.valueOf(tablenameBytes);
        } else {
            this.encodedRegionName = walKey.getEncodedRegionName().toByteArray();
            this.tablename = TableName.valueOf(walKey.getTableName().toByteArray());
        }
        this.clusterIds.clear();
        if (walKey.hasClusterId()) {
            this.clusterIds.add(new UUID(walKey.getClusterId().getMostSigBits(), walKey.getClusterId().getLeastSigBits()));
        }
        for (HBaseProtos.UUID clusterId : walKey.getClusterIdsList()) {
            this.clusterIds.add(new UUID(clusterId.getMostSigBits(), clusterId.getLeastSigBits()));
        }
        if (walKey.hasNonceGroup()) {
            this.nonceGroup = walKey.getNonceGroup();
        }
        if (walKey.hasNonce()) {
            this.nonce = walKey.getNonce();
        }
        this.scopes = null;
        if (walKey.getScopesCount() > 0) {
            this.scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (WALProtos.FamilyScope scope : walKey.getScopesList()) {
                byte[] family = this.compressionContext == null ? scope.getFamily().toByteArray() : uncompressor.uncompress(scope.getFamily(), this.compressionContext.familyDict);
                this.scopes.put(family, scope.getScopeType().getNumber());
            }
        }
        this.logSeqNum = walKey.getLogSequenceNumber();
        this.writeTime = walKey.getWriteTime();
        if (walKey.hasOrigSequenceNumber()) {
            this.origLogSeqNum = walKey.getOrigSequenceNumber();
        }
    }

    public long estimatedSerializedSizeOf() {
        long size = this.encodedRegionName != null ? (long)this.encodedRegionName.length : 0L;
        size += this.tablename != null ? (long)this.tablename.toBytes().length : 0L;
        if (this.clusterIds != null) {
            size += (long)(16 * this.clusterIds.size());
        }
        if (this.nonceGroup != 0L) {
            size += 8L;
        }
        if (this.nonce != 0L) {
            size += 8L;
        }
        if (this.scopes != null) {
            for (Map.Entry scope : this.scopes.entrySet()) {
                size += (long)((byte[])scope.getKey()).length;
                size += 4L;
            }
        }
        size += 8L;
        size += 8L;
        if (this.origLogSeqNum > 0L) {
            size += 8L;
        }
        return size;
    }

    @InterfaceAudience.Private
    protected static enum Version {
        UNVERSIONED(0),
        INITIAL(-1),
        COMPRESSED(-2);

        public final int code;
        static final Version[] byCode;

        private Version(int code) {
            this.code = code;
        }

        public boolean atLeast(Version other) {
            return this.code <= other.code;
        }

        public static Version fromCode(int code) {
            return byCode[code * -1];
        }

        static {
            byCode = Version.values();
            for (int i = 0; i < byCode.length; ++i) {
                if (Version.byCode[i].code != -1 * i) {
                    throw new AssertionError((Object)"Values in this enum should be descending by one");
                }
            }
        }
    }
}

