/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.Serializable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class BlockCacheKey
implements HeapSize,
Serializable {
    private static final long serialVersionUID = -5199992013113130534L;
    private final String hfileName;
    private final long offset;
    private final BlockType blockType;
    private final boolean isPrimaryReplicaBlock;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 1 + ClassSize.REFERENCE + ClassSize.REFERENCE + 8);

    public BlockCacheKey(String hfileName, long offset) {
        this(hfileName, offset, true, BlockType.DATA);
    }

    public BlockCacheKey(String hfileName, long offset, boolean isPrimaryReplica, BlockType blockType) {
        this.isPrimaryReplicaBlock = isPrimaryReplica;
        this.hfileName = hfileName;
        this.offset = offset;
        this.blockType = blockType;
    }

    public int hashCode() {
        return this.hfileName.hashCode() * 127 + (int)(this.offset ^ this.offset >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof BlockCacheKey) {
            BlockCacheKey k = (BlockCacheKey)o;
            return this.offset == k.offset && (this.hfileName == null ? k.hfileName == null : this.hfileName.equals(k.hfileName));
        }
        return false;
    }

    public String toString() {
        return String.format("%s_%d", this.hfileName, this.offset);
    }

    @Override
    public long heapSize() {
        return ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.STRING + (long)(2 * this.hfileName.length()));
    }

    public String getHfileName() {
        return this.hfileName;
    }

    public boolean isPrimary() {
        return this.isPrimaryReplicaBlock;
    }

    public long getOffset() {
        return this.offset;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }
}

