/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CallDroppedException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
@InterfaceStability.Evolving
public class CallRunner {
    private static final Log LOG = LogFactory.getLog(CallRunner.class);
    private static final CallDroppedException CALL_DROPPED_EXCEPTION = new CallDroppedException();
    private RpcServer.Call call;
    private RpcServerInterface rpcServer;
    private MonitoredRPCHandler status;
    private volatile boolean sucessful;

    CallRunner(RpcServerInterface rpcServer, RpcServer.Call call) {
        this.call = call;
        this.rpcServer = rpcServer;
        if (call != null && rpcServer != null) {
            this.rpcServer.addCallSize(call.getSize());
        }
    }

    public RpcServer.Call getCall() {
        return this.call;
    }

    public void setStatus(MonitoredRPCHandler status) {
        this.status = status;
    }

    private void cleanup() {
        this.call = null;
        this.rpcServer = null;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop() {
        try {
            if (!this.call.connection.channel.isOpen()) {
                if (RpcServer.LOG.isDebugEnabled()) {
                    RpcServer.LOG.debug((Object)(Thread.currentThread().getName() + ": skipped " + this.call));
                }
                return;
            }
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            this.call.setResponse(null, null, CALL_DROPPED_EXCEPTION, "Call dropped, server " + (address != null ? address : "(channel closed)") + " is overloaded, please retry.");
            this.call.sendResponseIfReady();
        }
        catch (ClosedChannelException cce) {
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            RpcServer.LOG.warn((Object)(Thread.currentThread().getName() + ": caught a ClosedChannelException, " + "this means that the server " + (address != null ? address : "(channel closed)") + " was processing a request but the client went away. The error message was: " + cce.getMessage()));
        }
        catch (Exception e) {
            RpcServer.LOG.warn((Object)(Thread.currentThread().getName() + ": caught: " + StringUtils.stringifyException(e)));
        }
        finally {
            if (!this.sucessful) {
                this.rpcServer.addCallSize(this.call.getSize() * -1L);
            }
            this.cleanup();
        }
    }
}

