/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
@SuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="Synchronization on concurrent map is intended")
public class ServerManager {
    public static final String WAIT_ON_REGIONSERVERS_MAXTOSTART = "hbase.master.wait.on.regionservers.maxtostart";
    public static final String WAIT_ON_REGIONSERVERS_MINTOSTART = "hbase.master.wait.on.regionservers.mintostart";
    public static final String WAIT_ON_REGIONSERVERS_TIMEOUT = "hbase.master.wait.on.regionservers.timeout";
    public static final String WAIT_ON_REGIONSERVERS_INTERVAL = "hbase.master.wait.on.regionservers.interval";
    private static final Log LOG = LogFactory.getLog(ServerManager.class);
    private volatile boolean clusterShutdown = false;
    private final ConcurrentNavigableMap<byte[], Long> flushedSequenceIdByRegion = new ConcurrentSkipListMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentNavigableMap<byte[], ConcurrentNavigableMap<byte[], Long>> storeFlushedSequenceIdsByRegion = new ConcurrentSkipListMap<byte[], ConcurrentNavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentNavigableMap<ServerName, ServerLoad> onlineServers = new ConcurrentSkipListMap<ServerName, ServerLoad>();
    private final Map<ServerName, AdminProtos.AdminService.BlockingInterface> rsAdmins = new HashMap<ServerName, AdminProtos.AdminService.BlockingInterface>();
    private final ArrayList<ServerName> drainingServers = new ArrayList();
    private final Server master;
    private final MasterServices services;
    private final ClusterConnection connection;
    private final DeadServer deadservers = new DeadServer();
    private final long maxSkew;
    private final long warningSkew;
    private final RetryCounterFactory pingRetryCounterFactory;
    private final RpcControllerFactory rpcControllerFactory;
    private Set<ServerName> queuedDeadServers = new HashSet<ServerName>();
    private Map<ServerName, Boolean> requeuedDeadServers = new ConcurrentHashMap<ServerName, Boolean>();
    private List<ServerListener> listeners = new CopyOnWriteArrayList<ServerListener>();

    public ServerManager(Server master, MasterServices services) throws IOException {
        this(master, services, true);
    }

    ServerManager(Server master, MasterServices services, boolean connect) throws IOException {
        this.master = master;
        this.services = services;
        Configuration c = master.getConfiguration();
        this.maxSkew = c.getLong("hbase.master.maxclockskew", 30000L);
        this.warningSkew = c.getLong("hbase.master.warningclockskew", 10000L);
        this.connection = connect ? (ClusterConnection)ConnectionFactory.createConnection(c) : null;
        int pingMaxAttempts = Math.max(1, master.getConfiguration().getInt("hbase.master.maximum.ping.server.attempts", 10));
        int pingSleepInterval = Math.max(1, master.getConfiguration().getInt("hbase.master.ping.server.retry.sleep.interval", 100));
        this.pingRetryCounterFactory = new RetryCounterFactory(pingMaxAttempts, pingSleepInterval);
        this.rpcControllerFactory = this.connection == null ? null : this.connection.getRpcControllerFactory();
    }

    public void registerListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(ServerListener listener) {
        return this.listeners.remove(listener);
    }

    ServerName regionServerStartup(RegionServerStatusProtos.RegionServerStartupRequest request, InetAddress ia) throws IOException {
        String hostname = request.hasUseThisHostnameInstead() ? request.getUseThisHostnameInstead() : ia.getHostName();
        ServerName sn = ServerName.valueOf(hostname, request.getPort(), request.getServerStartCode());
        this.checkClockSkew(sn, request.getServerCurrentTime());
        this.checkIsDead(sn, "STARTUP");
        if (!this.checkAndRecordNewServer(sn, ServerLoad.EMPTY_SERVERLOAD)) {
            LOG.warn((Object)("THIS SHOULD NOT HAPPEN, RegionServerStartup could not record the server: " + sn));
        }
        return sn;
    }

    private ConcurrentNavigableMap<byte[], Long> getOrCreateStoreFlushedSequenceId(byte[] regionName) {
        ConcurrentSkipListMap storeFlushedSequenceId = (ConcurrentSkipListMap)this.storeFlushedSequenceIdsByRegion.get(regionName);
        if (storeFlushedSequenceId != null) {
            return storeFlushedSequenceId;
        }
        storeFlushedSequenceId = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
        ConcurrentNavigableMap alreadyPut = this.storeFlushedSequenceIdsByRegion.putIfAbsent(regionName, storeFlushedSequenceId);
        return alreadyPut == null ? storeFlushedSequenceId : alreadyPut;
    }

    private void updateLastFlushedSequenceIds(ServerName sn, ServerLoad hsl) {
        Map<byte[], RegionLoad> regionsLoad = hsl.getRegionsLoad();
        for (Map.Entry<byte[], RegionLoad> entry : regionsLoad.entrySet()) {
            byte[] encodedRegionName = Bytes.toBytes(HRegionInfo.encodeRegionName(entry.getKey()));
            Long existingValue = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
            long l = entry.getValue().getCompleteSequenceId();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(Bytes.toString(encodedRegionName) + ", existingValue=" + existingValue + ", completeSequenceId=" + l));
            }
            if (existingValue == null || l != -1L && l > existingValue) {
                this.flushedSequenceIdByRegion.put(encodedRegionName, l);
            } else if (l != -1L && l < existingValue) {
                LOG.warn((Object)("RegionServer " + sn + " indicates a last flushed sequence id (" + l + ") that is less than the previous last flushed sequence id (" + existingValue + ") for region " + Bytes.toString(entry.getKey()) + " Ignoring."));
            }
            ConcurrentNavigableMap<byte[], Long> storeFlushedSequenceId = this.getOrCreateStoreFlushedSequenceId(encodedRegionName);
            for (ClusterStatusProtos.StoreSequenceId storeSeqId : entry.getValue().getStoreCompleteSequenceId()) {
                byte[] family = storeSeqId.getFamilyName().toByteArray();
                existingValue = (Long)storeFlushedSequenceId.get(family);
                l = storeSeqId.getSequenceId();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(Bytes.toString(encodedRegionName) + ", family=" + Bytes.toString(family) + ", existingValue=" + existingValue + ", completeSequenceId=" + l));
                }
                if (existingValue != null && (l == -1L || l <= existingValue)) continue;
                storeFlushedSequenceId.put(family, l);
            }
        }
    }

    void regionServerReport(ServerName sn, ServerLoad sl) throws YouAreDeadException {
        this.checkIsDead(sn, "REPORT");
        if (null == this.onlineServers.replace(sn, sl) && !this.checkAndRecordNewServer(sn, sl)) {
            LOG.info((Object)("RegionServerReport ignored, could not record the server: " + sn));
            return;
        }
        this.updateLastFlushedSequenceIds(sn, sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAndRecordNewServer(ServerName serverName, ServerLoad sl) {
        ServerName existingServer = null;
        ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            existingServer = this.findServerWithSameHostnamePortWithLock(serverName);
            if (existingServer != null && existingServer.getStartcode() > serverName.getStartcode()) {
                LOG.info((Object)("Server serverName=" + serverName + " rejected; we already have " + existingServer.toString() + " registered with same hostname and port"));
                return false;
            }
            this.recordNewServerWithLock(serverName, sl);
        }
        if (!this.listeners.isEmpty()) {
            for (ServerListener listener : this.listeners) {
                listener.serverAdded(serverName);
            }
        }
        if (existingServer != null && existingServer.getStartcode() < serverName.getStartcode()) {
            LOG.info((Object)("Triggering server recovery; existingServer " + existingServer + " looks stale, new server:" + serverName));
            this.expireServer(existingServer);
        }
        return true;
    }

    private void checkClockSkew(ServerName serverName, long serverCurrentTime) throws ClockOutOfSyncException {
        long skew = Math.abs(System.currentTimeMillis() - serverCurrentTime);
        if (skew > this.maxSkew) {
            String message = "Server " + serverName + " has been " + "rejected; Reported time is too far out of sync with master.  " + "Time difference of " + skew + "ms > max allowed of " + this.maxSkew + "ms";
            LOG.warn((Object)message);
            throw new ClockOutOfSyncException(message);
        }
        if (skew > this.warningSkew) {
            String message = "Reported time for server " + serverName + " is out of sync with master " + "by " + skew + "ms. (Warning threshold is " + this.warningSkew + "ms; " + "error threshold is " + this.maxSkew + "ms)";
            LOG.warn((Object)message);
        }
    }

    private void checkIsDead(ServerName serverName, String what) throws YouAreDeadException {
        if (this.deadservers.isDeadServer(serverName)) {
            String message = "Server " + what + " rejected; currently processing " + serverName + " as dead server";
            LOG.debug((Object)message);
            throw new YouAreDeadException(message);
        }
        if ((this.services == null || ((HMaster)this.services).isInitialized()) && this.deadservers.cleanPreviousInstance(serverName)) {
            LOG.debug((Object)(what + ":" + " Server " + serverName + " came back up," + " removed it from the dead servers list"));
        }
    }

    private ServerName findServerWithSameHostnamePortWithLock(ServerName serverName) {
        ServerName end = ServerName.valueOf(serverName.getHostname(), serverName.getPort(), Long.MAX_VALUE);
        ServerName r = this.onlineServers.lowerKey(end);
        if (r != null && ServerName.isSameHostnameAndPort(r, serverName)) {
            return r;
        }
        return null;
    }

    @VisibleForTesting
    void recordNewServerWithLock(ServerName serverName, ServerLoad sl) {
        LOG.info((Object)("Registering server=" + serverName));
        this.onlineServers.put(serverName, sl);
        this.rsAdmins.remove(serverName);
    }

    public ClusterStatusProtos.RegionStoreSequenceIds getLastFlushedSequenceId(byte[] encodedRegionName) {
        ClusterStatusProtos.RegionStoreSequenceIds.Builder builder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        Long seqId = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
        builder.setLastFlushedSequenceId(seqId != null ? seqId : -1L);
        Map storeFlushedSequenceId = (Map)this.storeFlushedSequenceIdsByRegion.get(encodedRegionName);
        if (storeFlushedSequenceId != null) {
            for (Map.Entry entry : storeFlushedSequenceId.entrySet()) {
                builder.addStoreSequenceId(ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(ByteString.copyFrom((byte[])entry.getKey())).setSequenceId((Long)entry.getValue()).build());
            }
        }
        return builder.build();
    }

    public ServerLoad getLoad(ServerName serverName) {
        return (ServerLoad)this.onlineServers.get(serverName);
    }

    public double getAverageLoad() {
        int totalLoad = 0;
        int numServers = 0;
        for (ServerLoad sl : this.onlineServers.values()) {
            ++numServers;
            totalLoad += sl.getNumberOfRegions();
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    public int countOfRegionServers() {
        return this.onlineServers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServerName, ServerLoad> getOnlineServers() {
        ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            return Collections.unmodifiableMap(this.onlineServers);
        }
    }

    public DeadServer getDeadServers() {
        return this.deadservers;
    }

    public boolean areDeadServersInProgress() {
        return this.deadservers.areDeadServersInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void letRegionServersShutdown() {
        int onlineServersCt;
        long previousLogTime = 0L;
        ServerName sn = this.master.getServerName();
        ZooKeeperWatcher zkw = this.master.getZooKeeper();
        while ((onlineServersCt = this.onlineServers.size()) > 0) {
            block17: {
                if (System.currentTimeMillis() > previousLogTime + 1000L) {
                    Set remainingServers = this.onlineServers.keySet();
                    ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
                    synchronized (concurrentNavigableMap) {
                        if (remainingServers.size() == 1 && remainingServers.contains(sn)) {
                            return;
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    for (ServerName key : remainingServers) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(key);
                    }
                    LOG.info((Object)("Waiting on regionserver(s) to go down " + sb.toString()));
                    previousLogTime = System.currentTimeMillis();
                }
                try {
                    List<String> servers = ZKUtil.listChildrenNoWatch(zkw, zkw.rsZNode);
                    if (servers == null || servers.size() == 0 || servers.size() == 1 && servers.contains(sn.toString())) {
                        LOG.info((Object)"ZK shows there is only the master self online, exiting now");
                    }
                    break block17;
                }
                catch (KeeperException ke) {
                    LOG.warn((Object)"Failed to list regionservers", (Throwable)ke);
                }
                break;
            }
            ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
            synchronized (concurrentNavigableMap) {
                try {
                    if (onlineServersCt == this.onlineServers.size()) {
                        this.onlineServers.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private List<String> getRegionServersInZK(ZooKeeperWatcher zkw) throws KeeperException {
        return ZKUtil.listChildrenNoWatch(zkw, zkw.rsZNode);
    }

    public synchronized void expireServer(ServerName serverName) {
        if (serverName.equals(this.master.getServerName())) {
            if (!this.master.isAborted() && !this.master.isStopped()) {
                this.master.stop("We lost our znode?");
            }
            return;
        }
        if (!this.services.isServerCrashProcessingEnabled()) {
            LOG.info((Object)("Master doesn't enable ServerShutdownHandler during initialization, delay expiring server " + serverName));
            this.queuedDeadServers.add(serverName);
            return;
        }
        if (this.deadservers.isDeadServer(serverName)) {
            LOG.warn((Object)("Expiration of " + serverName + " but server shutdown already in progress"));
            return;
        }
        this.moveFromOnlineToDeadServers(serverName);
        if (this.clusterShutdown) {
            LOG.info((Object)("Cluster shutdown set; " + serverName + " expired; onlineServers=" + this.onlineServers.size()));
            if (this.onlineServers.isEmpty()) {
                this.master.stop("Cluster shutdown set; onlineServer=0");
            }
            return;
        }
        boolean carryingMeta = this.services.getAssignmentManager().isCarryingMeta(serverName) == AssignmentManager.ServerHostRegion.HOSTING_REGION;
        ProcedureExecutor<MasterProcedureEnv> procExec = this.services.getMasterProcedureExecutor();
        procExec.submitProcedure(new ServerCrashProcedure(procExec.getEnvironment(), serverName, true, carryingMeta));
        LOG.debug((Object)("Added=" + serverName + " to dead servers, submitted shutdown handler to be executed meta=" + carryingMeta));
        if (!this.listeners.isEmpty()) {
            for (ServerListener listener : this.listeners) {
                listener.serverRemoved(serverName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void moveFromOnlineToDeadServers(ServerName sn) {
        ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            if (!this.onlineServers.containsKey(sn)) {
                LOG.warn((Object)("Expiration of " + sn + " but server not online"));
            }
            this.deadservers.add(sn);
            this.onlineServers.remove(sn);
            this.onlineServers.notifyAll();
        }
        this.rsAdmins.remove(sn);
    }

    public synchronized void processDeadServer(ServerName serverName, boolean shouldSplitWal) {
        if (!this.services.getAssignmentManager().isFailoverCleanupDone()) {
            this.requeuedDeadServers.put(serverName, shouldSplitWal);
            return;
        }
        this.deadservers.add(serverName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.services.getMasterProcedureExecutor();
        procExec.submitProcedure(new ServerCrashProcedure(procExec.getEnvironment(), serverName, shouldSplitWal, false));
    }

    synchronized void processQueuedDeadServers() {
        if (!this.services.isServerCrashProcessingEnabled()) {
            LOG.info((Object)"Master hasn't enabled ServerShutdownHandler");
        }
        Iterator<ServerName> serverIterator = this.queuedDeadServers.iterator();
        while (serverIterator.hasNext()) {
            ServerName tmpServerName = serverIterator.next();
            this.expireServer(tmpServerName);
            serverIterator.remove();
            this.requeuedDeadServers.remove(tmpServerName);
        }
        if (!this.services.getAssignmentManager().isFailoverCleanupDone()) {
            LOG.info((Object)"AssignmentManager hasn't finished failover cleanup; waiting");
        }
        for (Map.Entry<ServerName, Boolean> entry : this.requeuedDeadServers.entrySet()) {
            this.processDeadServer(entry.getKey(), entry.getValue());
        }
        this.requeuedDeadServers.clear();
    }

    public boolean removeServerFromDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn((Object)("Server " + sn + " is not currently online. " + "Removing from draining list anyway, as requested."));
        }
        return this.drainingServers.remove(sn);
    }

    public boolean addServerToDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn((Object)("Server " + sn + " is not currently online. " + "Ignoring request to add it to draining list."));
            return false;
        }
        if (this.drainingServers.contains(sn)) {
            LOG.warn((Object)("Server " + sn + " is already in the draining server list." + "Ignoring request to add it again."));
            return false;
        }
        LOG.info((Object)("Server " + sn + " added to draining server list."));
        return this.drainingServers.add(sn);
    }

    public RegionOpeningState sendRegionOpen(ServerName server, HRegionInfo region, int versionOfOfflineNode, List<ServerName> favoredNodes) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
        if (admin == null) {
            LOG.warn((Object)("Attempting to send OPEN RPC to server " + server.toString() + " failed because no RPC connection found to this server"));
            return RegionOpeningState.FAILED_OPENING;
        }
        AdminProtos.OpenRegionRequest request = RequestConverter.buildOpenRegionRequest(server, region, versionOfOfflineNode, favoredNodes, ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.services.getMasterFileSystem().getLogRecoveryMode());
        try {
            AdminProtos.OpenRegionResponse response = admin.openRegion(null, request);
            return ResponseConverter.getRegionOpeningState(response);
        }
        catch (ServiceException se) {
            this.checkForRSznode(server, se);
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    private void checkForRSznode(ServerName serverName, ServiceException se) {
        if (se.getCause() == null) {
            return;
        }
        Throwable t = se.getCause();
        if (!(t instanceof ConnectException)) {
            if (!(t instanceof IOException)) {
                return;
            }
            if (t.getCause() == null) {
                return;
            }
            if (!(t.getCause() instanceof FailedServerException)) {
                return;
            }
        }
        if (!this.isServerOnline(serverName)) {
            return;
        }
        List<String> servers = null;
        try {
            servers = this.getRegionServersInZK(this.master.getZooKeeper());
        }
        catch (KeeperException ke) {
            LOG.warn((Object)"Failed to list regionservers", (Throwable)ke);
        }
        boolean found = false;
        if (servers != null) {
            for (String serverNameAsStr : servers) {
                ServerName sn = ServerName.valueOf(serverNameAsStr);
                if (!sn.equals(serverName)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            LOG.warn((Object)("Online server " + serverName.toString() + " has no corresponding " + "ephemeral znode (Did it die before registering in zk?); " + "calling expire to clean it up!"));
            this.expireServer(serverName);
        }
    }

    public List<RegionOpeningState> sendRegionOpen(ServerName server, List<Triple<HRegionInfo, Integer, List<ServerName>>> regionOpenInfos) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
        if (admin == null) {
            LOG.warn((Object)("Attempting to send OPEN RPC to server " + server.toString() + " failed because no RPC connection found to this server"));
            return null;
        }
        AdminProtos.OpenRegionRequest request = RequestConverter.buildOpenRegionRequest(server, regionOpenInfos, ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY == this.services.getMasterFileSystem().getLogRecoveryMode());
        try {
            AdminProtos.OpenRegionResponse response = admin.openRegion(null, request);
            return ResponseConverter.getRegionOpeningStateList(response);
        }
        catch (ServiceException se) {
            this.checkForRSznode(server, se);
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    private HBaseRpcController newRpcController() {
        return this.rpcControllerFactory == null ? null : this.rpcControllerFactory.newController();
    }

    public boolean sendRegionClose(ServerName server, HRegionInfo region, int versionOfClosingNode, ServerName dest, boolean transitionInZK) throws IOException {
        if (server == null) {
            throw new NullPointerException("Passed server is null");
        }
        AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
        if (admin == null) {
            throw new IOException("Attempting to send CLOSE RPC to server " + server.toString() + " for region " + region.getRegionNameAsString() + " failed because no RPC connection found to this server");
        }
        HBaseRpcController controller = this.newRpcController();
        return ProtobufUtil.closeRegion(controller, admin, server, region.getRegionName(), versionOfClosingNode, dest, transitionInZK);
    }

    public boolean sendRegionClose(ServerName server, HRegionInfo region, int versionOfClosingNode) throws IOException {
        return this.sendRegionClose(server, region, versionOfClosingNode, null, true);
    }

    public void sendRegionWarmup(ServerName server, HRegionInfo region) {
        if (server == null) {
            return;
        }
        try {
            AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
            HBaseRpcController controller = this.newRpcController();
            ProtobufUtil.warmupRegion(controller, admin, region);
        }
        catch (IOException e) {
            LOG.error((Object)("Received exception in RPC for warmup server:" + server + "region: " + region + "exception: " + e));
        }
    }

    public static void closeRegionSilentlyAndWait(ClusterConnection connection, ServerName server, HRegionInfo region, long timeout) throws IOException, InterruptedException {
        AdminProtos.AdminService.BlockingInterface rs = connection.getAdmin(server);
        HBaseRpcController controller = connection.getRpcControllerFactory().newController();
        try {
            ProtobufUtil.closeRegion(controller, rs, server, region.getRegionName(), false);
        }
        catch (IOException e) {
            LOG.warn((Object)("Exception when closing region: " + region.getRegionNameAsString()), (Throwable)e);
        }
        long expiration = timeout + System.currentTimeMillis();
        while (System.currentTimeMillis() < expiration) {
            controller.reset();
            try {
                HRegionInfo rsRegion = ProtobufUtil.getRegionInfo(controller, rs, region.getRegionName());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof NotServingRegionException) {
                    return;
                }
                LOG.warn((Object)("Exception when retrieving regioninfo from: " + region.getRegionNameAsString()), (Throwable)ioe);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to close within" + " timeout " + timeout);
    }

    public void sendRegionsMerge(ServerName server, HRegionInfo region_a, HRegionInfo region_b, boolean forcible, User user) throws IOException {
        if (server == null) {
            throw new NullPointerException("Passed server is null");
        }
        if (region_a == null || region_b == null) {
            throw new NullPointerException("Passed region is null");
        }
        AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
        if (admin == null) {
            throw new IOException("Attempting to send MERGE REGIONS RPC to server " + server.toString() + " for region " + region_a.getRegionNameAsString() + "," + region_b.getRegionNameAsString() + " failed because no RPC connection found to this server");
        }
        HBaseRpcController controller = this.newRpcController();
        ProtobufUtil.mergeRegions(controller, admin, region_a, region_b, forcible, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerReachable(ServerName server) {
        if (server == null) {
            throw new NullPointerException("Passed server is null");
        }
        RetryCounter retryCounter = this.pingRetryCounterFactory.create();
        while (retryCounter.shouldRetry()) {
            ConcurrentNavigableMap<ServerName, ServerLoad> concurrentNavigableMap = this.onlineServers;
            synchronized (concurrentNavigableMap) {
                if (this.deadservers.isDeadServer(server)) {
                    return false;
                }
            }
            try {
                HBaseRpcController controller = this.newRpcController();
                AdminProtos.AdminService.BlockingInterface admin = this.getRsAdmin(server);
                if (admin == null) continue;
                AdminProtos.ServerInfo info = ProtobufUtil.getServerInfo(controller, admin);
                return info != null && info.hasServerName() && server.getStartcode() == info.getServerName().getStartCode();
            }
            catch (IOException ioe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Couldn't reach " + server + ", try=" + retryCounter.getAttemptTimes() + " of " + retryCounter.getMaxAttempts()), (Throwable)ioe);
                }
                try {
                    retryCounter.sleepUntilNextRetry();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return false;
    }

    private AdminProtos.AdminService.BlockingInterface getRsAdmin(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.rsAdmins.get(sn);
        if (admin == null) {
            LOG.debug((Object)("New admin connection to " + sn.toString()));
            admin = sn.equals(this.master.getServerName()) && this.master instanceof HRegionServer ? ((HRegionServer)this.master).getRSRpcServices() : this.connection.getAdmin(sn);
            this.rsAdmins.put(sn, admin);
        }
        return admin;
    }

    private int getMinToStart() {
        int minToStart;
        int requiredMinToStart = 1;
        if (BaseLoadBalancer.tablesOnMaster(this.master.getConfiguration()) && !BaseLoadBalancer.userTablesOnMaster(this.master.getConfiguration())) {
            requiredMinToStart = 2;
        }
        return (minToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MINTOSTART, -1)) == -1 || minToStart < requiredMinToStart ? requiredMinToStart : minToStart;
    }

    public void waitForRegionServers(MonitoredTask status) throws InterruptedException {
        long now;
        long interval = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_INTERVAL, 1500L);
        long timeout = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_TIMEOUT, 4500L);
        int minToStart = this.getMinToStart();
        int maxToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MAXTOSTART, Integer.MAX_VALUE);
        if (maxToStart < minToStart) {
            LOG.warn((Object)String.format("The value of '%s' (%d) is set less than '%s' (%d), ignoring.", WAIT_ON_REGIONSERVERS_MAXTOSTART, maxToStart, WAIT_ON_REGIONSERVERS_MINTOSTART, minToStart));
            maxToStart = Integer.MAX_VALUE;
        }
        long startTime = now = System.currentTimeMillis();
        long slept = 0L;
        long lastLogTime = 0L;
        long lastCountChange = startTime;
        int count = this.countOfRegionServers();
        int oldCount = 0;
        for (ServerListener listener : this.listeners) {
            listener.waiting();
        }
        while (!(this.master.isStopped() || count >= maxToStart || lastCountChange + interval <= now && timeout <= slept && count >= minToStart)) {
            if (oldCount != count || lastLogTime + interval < now) {
                lastLogTime = now;
                String msg = "Waiting on RegionServer count=" + count + " to settle; waited=" + slept + "ms, expecting min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s), " + "timeout=" + timeout + "ms, lastChange=" + (lastCountChange - now) + "ms";
                LOG.info((Object)msg);
                status.setStatus(msg);
            }
            long sleepTime = 50L;
            Thread.sleep(50L);
            now = System.currentTimeMillis();
            slept = now - startTime;
            oldCount = count;
            count = this.countOfRegionServers();
            if (count == oldCount) continue;
            lastCountChange = now;
        }
        LOG.info((Object)("Finished wait on RegionServer count=" + count + "; waited=" + slept + "ms," + " expected min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s)," + " master is " + (this.master.isStopped() ? "stopped." : "running")));
    }

    private String getStrForMax(int max) {
        return max == Integer.MAX_VALUE ? "NO_LIMIT" : Integer.toString(max);
    }

    public List<ServerName> getOnlineServersList() {
        return new ArrayList<ServerName>(this.onlineServers.keySet());
    }

    public List<ServerName> getDrainingServersList() {
        return new ArrayList<ServerName>(this.drainingServers);
    }

    Set<ServerName> getDeadNotExpiredServers() {
        return new HashSet<ServerName>(this.queuedDeadServers);
    }

    void removeRequeuedDeadServers() {
        this.requeuedDeadServers.clear();
    }

    Map<ServerName, Boolean> getRequeuedDeadServers() {
        return Collections.unmodifiableMap(this.requeuedDeadServers);
    }

    public boolean isServerOnline(ServerName serverName) {
        return serverName != null && this.onlineServers.containsKey(serverName);
    }

    public boolean isServerWithSameHostnamePortOnline(ServerName serverName) {
        return this.findServerWithSameHostnamePortWithLock(serverName) != null;
    }

    public synchronized boolean isServerDead(ServerName serverName) {
        return serverName == null || this.deadservers.isDeadServer(serverName) || this.queuedDeadServers.contains(serverName) || this.requeuedDeadServers.containsKey(serverName);
    }

    public void shutdownCluster() {
        this.clusterShutdown = true;
        this.master.stop("Cluster shutdown requested");
    }

    public boolean isClusterShutdown() {
        return this.clusterShutdown;
    }

    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Attempt to close connection to master failed", (Throwable)e);
            }
        }
    }

    public List<ServerName> createDestinationServersList(List<ServerName> serversToExclude) {
        List<ServerName> drainingServersCopy;
        List<ServerName> destServers = this.getOnlineServersList();
        if (serversToExclude != null) {
            destServers.removeAll(serversToExclude);
        }
        if (!(drainingServersCopy = this.getDrainingServersList()).isEmpty()) {
            for (ServerName server : drainingServersCopy) {
                destServers.remove(server);
            }
        }
        this.removeDeadNotExpiredServers(destServers);
        return destServers;
    }

    public List<ServerName> createDestinationServersList() {
        return this.createDestinationServersList(null);
    }

    void removeDeadNotExpiredServers(List<ServerName> servers) {
        Set<ServerName> deadNotExpiredServersCopy = this.getDeadNotExpiredServers();
        if (!deadNotExpiredServersCopy.isEmpty()) {
            for (ServerName server : deadNotExpiredServersCopy) {
                LOG.debug((Object)("Removing dead but not expired server: " + server + " from eligible server pool."));
                servers.remove(server);
            }
        }
    }

    void clearDeadServersWithSameHostNameAndPortOfOnlineServer() {
        for (ServerName serverName : this.getOnlineServersList()) {
            this.deadservers.cleanAllPreviousInstances(serverName);
        }
    }

    public void removeRegion(HRegionInfo regionInfo) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        this.storeFlushedSequenceIdsByRegion.remove(encodedName);
        this.flushedSequenceIdByRegion.remove(encodedName);
    }

    @VisibleForTesting
    public boolean isRegionInServerManagerStates(HRegionInfo hri) {
        byte[] encodedName = hri.getEncodedNameAsBytes();
        return this.storeFlushedSequenceIdsByRegion.containsKey(encodedName) || this.flushedSequenceIdByRegion.containsKey(encodedName);
    }

    public void removeRegions(List<HRegionInfo> regions) {
        for (HRegionInfo hri : regions) {
            this.removeRegion(hri);
        }
    }
}

