/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureEnv {
    private static final Log LOG = LogFactory.getLog(MasterProcedureEnv.class);
    private final MasterProcedureScheduler procSched;
    private final MasterServices master;

    public MasterProcedureEnv(MasterServices master) {
        this.master = master;
        this.procSched = new MasterProcedureScheduler(master.getConfiguration(), master.getTableLockManager());
    }

    public User getRequestUser() {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = Superusers.getSystemUser();
        }
        return user;
    }

    public MasterServices getMasterServices() {
        return this.master;
    }

    public Configuration getMasterConfiguration() {
        return this.master.getConfiguration();
    }

    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.master.getMasterCoprocessorHost();
    }

    public MasterProcedureScheduler getProcedureQueue() {
        return this.procSched;
    }

    public boolean isRunning() {
        return this.master.getMasterProcedureExecutor().isRunning();
    }

    public boolean isInitialized() {
        return this.master.isInitialized();
    }

    public boolean waitInitialized(Procedure proc) {
        return this.procSched.waitEvent(((HMaster)this.master).getInitializedEvent(), proc);
    }

    public boolean waitServerCrashProcessingEnabled(Procedure proc) {
        return this.procSched.waitEvent(((HMaster)this.master).getServerCrashProcessingEnabledEvent(), proc);
    }

    public void wake(MasterProcedureScheduler.ProcedureEvent event) {
        this.procSched.wake(event);
    }

    public void suspend(MasterProcedureScheduler.ProcedureEvent event) {
        this.procSched.suspend(event);
    }

    public void setEventReady(MasterProcedureScheduler.ProcedureEvent event, boolean isReady) {
        if (isReady) {
            this.procSched.wake(event);
        } else {
            this.procSched.suspend(event);
        }
    }

    @InterfaceAudience.Private
    public static class MasterProcedureStoreListener
    implements ProcedureStore.ProcedureStoreListener {
        private final HMaster master;

        public MasterProcedureStoreListener(HMaster master) {
            this.master = master;
        }

        @Override
        public void postSync() {
        }

        @Override
        public void abortProcess() {
            this.master.abort("The Procedure Store lost the lease");
        }
    }

    @InterfaceAudience.Private
    public static class WALStoreLeaseRecovery
    implements WALProcedureStore.LeaseRecovery {
        private final HMaster master;

        public WALStoreLeaseRecovery(HMaster master) {
            this.master = master;
        }

        @Override
        public void recoverFileLease(FileSystem fs, final Path path) throws IOException {
            Configuration conf = this.master.getConfiguration();
            FSUtils fsUtils = FSUtils.getInstance(fs, conf);
            fsUtils.recoverFileLease(fs, path, conf, new CancelableProgressable(){

                @Override
                public boolean progress() {
                    LOG.debug((Object)("Recover Procedure Store log lease: " + path));
                    return WALStoreLeaseRecovery.this.master.isActiveMaster();
                }
            });
        }
    }
}

