/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.metrics.MetricsInfoImpl;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.CacheLoader;
import org.apache.hadoop.hbase.shaded.com.google.common.cache.LoadingCache;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class Interns {
    private static LoadingCache<String, ConcurrentHashMap<String, MetricsInfo>> infoCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<String, ConcurrentHashMap<String, MetricsInfo>>(){

        @Override
        public ConcurrentHashMap<String, MetricsInfo> load(String key) {
            return new ConcurrentHashMap<String, MetricsInfo>();
        }
    });
    private static LoadingCache<MetricsInfo, ConcurrentHashMap<String, MetricsTag>> tagCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build(new CacheLoader<MetricsInfo, ConcurrentHashMap<String, MetricsTag>>(){

        @Override
        public ConcurrentHashMap<String, MetricsTag> load(MetricsInfo key) {
            return new ConcurrentHashMap<String, MetricsTag>();
        }
    });

    private Interns() {
    }

    public static MetricsInfo info(String name, String description) {
        Map map = infoCache.getUnchecked(name);
        MetricsInfo info = (MetricsInfo)map.get(description);
        if (info == null) {
            info = new MetricsInfoImpl(name, description);
            map.put(description, info);
        }
        return info;
    }

    public static MetricsTag tag(MetricsInfo info, String value) {
        Map map = tagCache.getUnchecked(info);
        MetricsTag tag = (MetricsTag)map.get(value);
        if (tag == null) {
            tag = new MetricsTag(info, value);
            map.put(value, tag);
        }
        return tag;
    }

    public static MetricsTag tag(String name, String description, String value) {
        return Interns.tag(Interns.info(name, description), value);
    }
}

