/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class StateMachineProcedure<TEnvironment, TState>
extends Procedure<TEnvironment> {
    private Flow stateFlow = Flow.HAS_MORE_STATE;
    private int stateCount = 0;
    private int[] states = null;
    private ArrayList<Procedure> subProcList = null;

    protected abstract Flow executeFromState(TEnvironment var1, TState var2) throws ProcedureYieldException, InterruptedException;

    protected abstract void rollbackState(TEnvironment var1, TState var2) throws IOException, InterruptedException;

    protected abstract TState getState(int var1);

    protected abstract int getStateId(TState var1);

    protected abstract TState getInitialState();

    protected void setNextState(TState state) {
        this.setNextState(this.getStateId(state));
    }

    protected boolean isYieldBeforeExecuteFromState(TEnvironment env, TState state) {
        return false;
    }

    protected void addChildProcedure(Procedure ... subProcedure) {
        if (this.subProcList == null) {
            this.subProcList = new ArrayList(subProcedure.length);
        }
        for (int i = 0; i < subProcedure.length; ++i) {
            this.subProcList.add(subProcedure[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure[] execute(TEnvironment env) throws ProcedureYieldException, InterruptedException {
        this.updateTimestamp();
        try {
            Procedure[] procedureArray;
            if (!this.hasMoreState()) {
                Procedure[] procedureArray2 = null;
                return procedureArray2;
            }
            TState state = this.getCurrentState();
            if (this.stateCount == 0) {
                this.setNextState(this.getStateId(state));
            }
            this.stateFlow = this.executeFromState(env, state);
            if (this.subProcList != null && this.subProcList.size() != 0) {
                Procedure[] subProcedures = this.subProcList.toArray(new Procedure[this.subProcList.size()]);
                this.subProcList = null;
                Procedure[] procedureArray3 = subProcedures;
                return procedureArray3;
            }
            if (this.isWaiting() || this.isFailed() || !this.hasMoreState()) {
                procedureArray = null;
            } else {
                Procedure[] procedureArray4 = new Procedure[1];
                procedureArray = procedureArray4;
                procedureArray4[0] = this;
            }
            Procedure[] procedureArray5 = procedureArray;
            return procedureArray5;
        }
        finally {
            this.updateTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollback(TEnvironment env) throws IOException, InterruptedException {
        try {
            this.updateTimestamp();
            this.rollbackState(env, this.getCurrentState());
            --this.stateCount;
        }
        finally {
            this.updateTimestamp();
        }
    }

    @Override
    protected boolean isYieldAfterExecutionStep(TEnvironment env) {
        return this.isYieldBeforeExecuteFromState(env, this.getCurrentState());
    }

    private boolean hasMoreState() {
        return this.stateFlow != Flow.NO_MORE_STATE;
    }

    private TState getCurrentState() {
        return this.stateCount > 0 ? this.getState(this.states[this.stateCount - 1]) : this.getInitialState();
    }

    private void setNextState(int stateId) {
        if (this.states == null || this.states.length == this.stateCount) {
            int newCapacity = this.stateCount + 8;
            this.states = this.states != null ? Arrays.copyOf(this.states, newCapacity) : new int[newCapacity];
        }
        this.states[this.stateCount++] = stateId;
    }

    @Override
    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        if (!this.isFinished() && this.getCurrentState() != null) {
            builder.append(":").append(this.getCurrentState());
        }
    }

    @Override
    protected void serializeStateData(OutputStream stream) throws IOException {
        ProcedureProtos.StateMachineProcedureData.Builder data = ProcedureProtos.StateMachineProcedureData.newBuilder();
        for (int i = 0; i < this.stateCount; ++i) {
            data.addState(this.states[i]);
        }
        data.build().writeDelimitedTo(stream);
    }

    @Override
    protected void deserializeStateData(InputStream stream) throws IOException {
        ProcedureProtos.StateMachineProcedureData data = ProcedureProtos.StateMachineProcedureData.parseDelimitedFrom(stream);
        this.stateCount = data.getStateCount();
        if (this.stateCount > 0) {
            this.states = new int[this.stateCount];
            for (int i = 0; i < this.stateCount; ++i) {
                this.states[i] = data.getState(i);
            }
        } else {
            this.states = null;
        }
    }

    protected static enum Flow {
        HAS_MORE_STATE,
        NO_MORE_STATE;

    }
}

