/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionMergeRequest;
import org.apache.hadoop.hbase.regionserver.SplitRequest;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.throttle.CompactionThroughputControllerFactory;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.StealJobQueue;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class CompactSplitThread
implements CompactionRequestor,
PropagatingConfigurationObserver {
    private static final Log LOG = LogFactory.getLog(CompactSplitThread.class);
    public static final String LARGE_COMPACTION_THREADS = "hbase.regionserver.thread.compaction.large";
    public static final int LARGE_COMPACTION_THREADS_DEFAULT = 1;
    public static final String SMALL_COMPACTION_THREADS = "hbase.regionserver.thread.compaction.small";
    public static final int SMALL_COMPACTION_THREADS_DEFAULT = 1;
    public static final String SPLIT_THREADS = "hbase.regionserver.thread.split";
    public static final int SPLIT_THREADS_DEFAULT = 1;
    public static final String MERGE_THREADS = "hbase.regionserver.thread.merge";
    public static final int MERGE_THREADS_DEFAULT = 1;
    public static final String REGION_SERVER_REGION_SPLIT_LIMIT = "hbase.regionserver.regionSplitLimit";
    public static final int DEFAULT_REGION_SERVER_REGION_SPLIT_LIMIT = 1000;
    private final HRegionServer server;
    private final Configuration conf;
    private final ThreadPoolExecutor longCompactions;
    private final ThreadPoolExecutor shortCompactions;
    private final ThreadPoolExecutor splits;
    private final ThreadPoolExecutor mergePool;
    private volatile ThroughputController compactionThroughputController;
    private int regionSplitLimit;

    CompactSplitThread(HRegionServer server) {
        this.server = server;
        this.conf = server.getConfiguration();
        this.regionSplitLimit = this.conf.getInt(REGION_SERVER_REGION_SPLIT_LIMIT, 1000);
        int largeThreads = Math.max(1, this.conf.getInt(LARGE_COMPACTION_THREADS, 1));
        int smallThreads = this.conf.getInt(SMALL_COMPACTION_THREADS, 1);
        int splitThreads = this.conf.getInt(SPLIT_THREADS, 1);
        Preconditions.checkArgument(largeThreads > 0 && smallThreads > 0);
        final String n = Thread.currentThread().getName();
        StealJobQueue<Runnable> stealJobQueue = new StealJobQueue<Runnable>();
        this.longCompactions = new ThreadPoolExecutor(largeThreads, largeThreads, 60L, TimeUnit.SECONDS, stealJobQueue, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-longCompactions-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.longCompactions.setRejectedExecutionHandler(new Rejection());
        this.longCompactions.prestartAllCoreThreads();
        this.shortCompactions = new ThreadPoolExecutor(smallThreads, smallThreads, 60L, TimeUnit.SECONDS, stealJobQueue.getStealFromQueue(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-shortCompactions-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.shortCompactions.setRejectedExecutionHandler(new Rejection());
        this.splits = (ThreadPoolExecutor)Executors.newFixedThreadPool(splitThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-splits-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        int mergeThreads = this.conf.getInt(MERGE_THREADS, 1);
        this.mergePool = (ThreadPoolExecutor)Executors.newFixedThreadPool(mergeThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = n + "-merges-" + System.currentTimeMillis();
                return new Thread(r, name);
            }
        });
        this.compactionThroughputController = CompactionThroughputControllerFactory.create(server, this.conf);
    }

    public String toString() {
        return "compaction_queue=(" + this.longCompactions.getQueue().size() + ":" + this.shortCompactions.getQueue().size() + ")" + ", split_queue=" + this.splits.getQueue().size() + ", merge_queue=" + this.mergePool.getQueue().size();
    }

    public String dumpQueue() {
        StringBuffer queueLists = new StringBuffer();
        queueLists.append("Compaction/Split Queue dump:\n");
        queueLists.append("  LargeCompation Queue:\n");
        BlockingQueue<Runnable> lq = this.longCompactions.getQueue();
        Iterator it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + ((Runnable)it.next()).toString());
            queueLists.append("\n");
        }
        if (this.shortCompactions != null) {
            queueLists.append("\n");
            queueLists.append("  SmallCompation Queue:\n");
            lq = this.shortCompactions.getQueue();
            it = lq.iterator();
            while (it.hasNext()) {
                queueLists.append("    " + ((Runnable)it.next()).toString());
                queueLists.append("\n");
            }
        }
        queueLists.append("\n");
        queueLists.append("  Split Queue:\n");
        lq = this.splits.getQueue();
        it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + ((Runnable)it.next()).toString());
            queueLists.append("\n");
        }
        queueLists.append("\n");
        queueLists.append("  Region Merge Queue:\n");
        lq = this.mergePool.getQueue();
        it = lq.iterator();
        while (it.hasNext()) {
            queueLists.append("    " + ((Runnable)it.next()).toString());
            queueLists.append("\n");
        }
        return queueLists.toString();
    }

    public synchronized void requestRegionsMerge(Region a, Region b, boolean forcible, long masterSystemTime, User user) {
        try {
            this.mergePool.execute(new RegionMergeRequest(a, b, this.server, forcible, masterSystemTime, user));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Region merge requested for " + a + "," + b + ", forcible=" + forcible + ".  " + this));
            }
        }
        catch (RejectedExecutionException ree) {
            LOG.warn((Object)("Could not execute merge for " + a + "," + b + ", forcible=" + forcible), (Throwable)ree);
        }
    }

    public synchronized boolean requestSplit(Region r) {
        byte[] midKey;
        if (this.shouldSplitRegion() && ((HRegion)r).getCompactPriority() >= 1 && (midKey = ((HRegion)r).checkSplit()) != null) {
            this.requestSplit(r, midKey);
            return true;
        }
        return false;
    }

    public synchronized void requestSplit(Region r, byte[] midKey) {
        this.requestSplit(r, midKey, null);
    }

    public synchronized void requestSplit(Region r, byte[] midKey, User user) {
        if (midKey == null) {
            LOG.debug((Object)("Region " + r.getRegionInfo().getRegionNameAsString() + " not splittable because midkey=null"));
            if (((HRegion)r).shouldForceSplit()) {
                ((HRegion)r).clearSplit();
            }
            return;
        }
        try {
            this.splits.execute(new SplitRequest(r, midKey, this.server, user));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Split requested for " + r + ".  " + this));
            }
        }
        catch (RejectedExecutionException ree) {
            LOG.info((Object)("Could not execute split for " + r), (Throwable)ree);
        }
    }

    @Override
    public synchronized List<CompactionRequest> requestCompaction(Region r, String why) throws IOException {
        return this.requestCompaction(r, why, null);
    }

    @Override
    public synchronized List<CompactionRequest> requestCompaction(Region r, String why, List<Pair<CompactionRequest, Store>> requests) throws IOException {
        return this.requestCompaction(r, why, Integer.MIN_VALUE, requests, null);
    }

    @Override
    public synchronized CompactionRequest requestCompaction(Region r, Store s, String why, CompactionRequest request) throws IOException {
        return this.requestCompaction(r, s, why, Integer.MIN_VALUE, request, null);
    }

    @Override
    public synchronized List<CompactionRequest> requestCompaction(Region r, String why, int p, List<Pair<CompactionRequest, Store>> requests, User user) throws IOException {
        return this.requestCompactionInternal(r, why, p, requests, true, user);
    }

    private List<CompactionRequest> requestCompactionInternal(Region r, String why, int p, List<Pair<CompactionRequest, Store>> requests, boolean selectNow, User user) throws IOException {
        ArrayList<CompactionRequest> ret = null;
        if (requests == null) {
            ret = selectNow ? new ArrayList<CompactionRequest>(r.getStores().size()) : null;
            for (Store s : r.getStores()) {
                CompactionRequest cr = this.requestCompactionInternal(r, s, why, p, null, selectNow, user);
                if (!selectNow) continue;
                ret.add(cr);
            }
        } else {
            Preconditions.checkArgument(selectNow);
            ret = new ArrayList(requests.size());
            for (Pair<CompactionRequest, Store> pair : requests) {
                ret.add(this.requestCompaction(r, pair.getSecond(), why, p, pair.getFirst(), user));
            }
        }
        return ret;
    }

    @Override
    public CompactionRequest requestCompaction(Region r, Store s, String why, int priority, CompactionRequest request, User user) throws IOException {
        return this.requestCompactionInternal(r, s, why, priority, request, true, user);
    }

    public synchronized void requestSystemCompaction(Region r, String why) throws IOException {
        this.requestCompactionInternal(r, why, Integer.MIN_VALUE, null, false, null);
    }

    public void requestSystemCompaction(Region r, Store s, String why) throws IOException {
        this.requestCompactionInternal(r, s, why, Integer.MIN_VALUE, null, false, null);
    }

    private synchronized CompactionRequest requestCompactionInternal(Region r, Store s, String why, int priority, CompactionRequest request, boolean selectNow, User user) throws IOException {
        if (this.server.isStopped() || r.getTableDesc() != null && !r.getTableDesc().isCompactionEnabled()) {
            return null;
        }
        CompactionContext compaction = null;
        if (selectNow && (compaction = this.selectCompaction(r, s, priority, request, user)) == null) {
            return null;
        }
        ThreadPoolExecutor pool = selectNow && s.throttleCompaction(compaction.getRequest().getSize()) ? this.longCompactions : this.shortCompactions;
        pool.execute(new CompactionRunner(s, r, compaction, pool, user));
        ((HRegion)r).incrementCompactionsQueuedCount();
        if (LOG.isDebugEnabled()) {
            String type = pool == this.shortCompactions ? "Small " : "Large ";
            LOG.debug((Object)(type + "Compaction requested: " + (selectNow ? compaction.toString() : "system") + (why != null && !why.isEmpty() ? "; Because: " + why : "") + "; " + this));
        }
        return selectNow ? compaction.getRequest() : null;
    }

    private CompactionContext selectCompaction(Region r, Store s, int priority, CompactionRequest request, User user) throws IOException {
        CompactionContext compaction = s.requestCompaction(priority, request, user);
        if (compaction == null) {
            if (LOG.isDebugEnabled() && r.getRegionInfo() != null) {
                LOG.debug((Object)("Not compacting " + r.getRegionInfo().getRegionNameAsString() + " because compaction request was cancelled"));
            }
            return null;
        }
        assert (compaction.hasSelection());
        if (priority != Integer.MIN_VALUE) {
            compaction.getRequest().setPriority(priority);
        }
        return compaction;
    }

    void interruptIfNecessary() {
        this.splits.shutdown();
        this.mergePool.shutdown();
        this.longCompactions.shutdown();
        this.shortCompactions.shutdown();
    }

    private void waitFor(ThreadPoolExecutor t, String name) {
        boolean done = false;
        while (!done) {
            try {
                done = t.awaitTermination(60L, TimeUnit.SECONDS);
                LOG.info((Object)("Waiting for " + name + " to finish..."));
                if (done) continue;
                t.shutdownNow();
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Interrupted waiting for " + name + " to finish..."));
            }
        }
    }

    void join() {
        this.waitFor(this.splits, "Split Thread");
        this.waitFor(this.mergePool, "Merge Thread");
        this.waitFor(this.longCompactions, "Large Compaction Thread");
        this.waitFor(this.shortCompactions, "Small Compaction Thread");
    }

    public int getCompactionQueueSize() {
        return this.longCompactions.getQueue().size() + this.shortCompactions.getQueue().size();
    }

    public int getLargeCompactionQueueSize() {
        return this.longCompactions.getQueue().size();
    }

    public int getSmallCompactionQueueSize() {
        return this.shortCompactions.getQueue().size();
    }

    public int getSplitQueueSize() {
        return this.splits.getQueue().size();
    }

    private boolean shouldSplitRegion() {
        if ((double)this.server.getNumberOfOnlineRegions() > 0.9 * (double)this.regionSplitLimit) {
            LOG.warn((Object)("Total number of regions is approaching the upper limit " + this.regionSplitLimit + ". " + "Please consider taking a look at http://hbase.apache.org/book.html#ops.regionmgt"));
        }
        return this.regionSplitLimit > this.server.getNumberOfOnlineRegions();
    }

    public int getRegionSplitLimit() {
        return this.regionSplitLimit;
    }

    @Override
    public void onConfigurationChange(Configuration newConf) {
        ThroughputController old;
        int largeThreads = Math.max(1, newConf.getInt(LARGE_COMPACTION_THREADS, 1));
        if (this.longCompactions.getCorePoolSize() != largeThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.compaction.large from " + this.longCompactions.getCorePoolSize() + " to " + largeThreads));
            if (this.longCompactions.getCorePoolSize() < largeThreads) {
                this.longCompactions.setMaximumPoolSize(largeThreads);
                this.longCompactions.setCorePoolSize(largeThreads);
            } else {
                this.longCompactions.setCorePoolSize(largeThreads);
                this.longCompactions.setMaximumPoolSize(largeThreads);
            }
        }
        int smallThreads = newConf.getInt(SMALL_COMPACTION_THREADS, 1);
        if (this.shortCompactions.getCorePoolSize() != smallThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.compaction.small from " + this.shortCompactions.getCorePoolSize() + " to " + smallThreads));
            if (this.shortCompactions.getCorePoolSize() < smallThreads) {
                this.shortCompactions.setMaximumPoolSize(smallThreads);
                this.shortCompactions.setCorePoolSize(smallThreads);
            } else {
                this.shortCompactions.setCorePoolSize(smallThreads);
                this.shortCompactions.setMaximumPoolSize(smallThreads);
            }
        }
        int splitThreads = newConf.getInt(SPLIT_THREADS, 1);
        if (this.splits.getCorePoolSize() != splitThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.split from " + this.splits.getCorePoolSize() + " to " + splitThreads));
            if (this.splits.getCorePoolSize() < splitThreads) {
                this.splits.setMaximumPoolSize(splitThreads);
                this.splits.setCorePoolSize(splitThreads);
            } else {
                this.splits.setCorePoolSize(splitThreads);
                this.splits.setMaximumPoolSize(splitThreads);
            }
        }
        int mergeThreads = newConf.getInt(MERGE_THREADS, 1);
        if (this.mergePool.getCorePoolSize() != mergeThreads) {
            LOG.info((Object)("Changing the value of hbase.regionserver.thread.merge from " + this.mergePool.getCorePoolSize() + " to " + mergeThreads));
            if (this.mergePool.getCorePoolSize() < mergeThreads) {
                this.mergePool.setMaximumPoolSize(mergeThreads);
                this.mergePool.setCorePoolSize(mergeThreads);
            } else {
                this.mergePool.setCorePoolSize(mergeThreads);
                this.mergePool.setMaximumPoolSize(mergeThreads);
            }
        }
        if ((old = this.compactionThroughputController) != null) {
            old.stop("configuration change");
        }
        this.compactionThroughputController = CompactionThroughputControllerFactory.create(this.server, newConf);
        this.conf.reloadConfiguration();
    }

    protected int getSmallCompactionThreadNum() {
        return this.shortCompactions.getCorePoolSize();
    }

    protected int getLargeCompactionThreadNum() {
        return this.longCompactions.getCorePoolSize();
    }

    protected int getSplitThreadNum() {
        return this.splits.getCorePoolSize();
    }

    protected int getMergeThreadNum() {
        return this.mergePool.getCorePoolSize();
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
    }

    @VisibleForTesting
    public ThroughputController getCompactionThroughputController() {
        return this.compactionThroughputController;
    }

    @VisibleForTesting
    void shutdownLongCompactions() {
        this.longCompactions.shutdown();
    }

    private static class Rejection
    implements RejectedExecutionHandler {
        private Rejection() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor pool) {
            if (runnable instanceof CompactionRunner) {
                CompactionRunner runner = (CompactionRunner)runnable;
                LOG.debug((Object)("Compaction Rejected: " + runner));
                runner.store.cancelRequestedCompaction(runner.compaction);
            }
        }
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Contrived use of compareTo")
    private class CompactionRunner
    implements Runnable,
    Comparable<CompactionRunner> {
        private final Store store;
        private final HRegion region;
        private CompactionContext compaction;
        private int queuedPriority;
        private ThreadPoolExecutor parent;
        private User user;
        private long time;

        public CompactionRunner(Store store, Region region, CompactionContext compaction, ThreadPoolExecutor parent, User user) {
            this.store = store;
            this.region = (HRegion)region;
            this.compaction = compaction;
            this.queuedPriority = this.compaction == null ? store.getCompactPriority() : compaction.getRequest().getPriority();
            this.parent = parent;
            this.user = user;
            this.time = System.currentTimeMillis();
        }

        public String toString() {
            return this.compaction != null ? "Request = " + this.compaction.getRequest() : "regionName = " + this.region.toString() + ", storeName = " + this.store.toString() + ", priority = " + this.queuedPriority + ", time = " + this.time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCompaction(User user) {
            if (this.compaction == null) {
                ThreadPoolExecutor pool;
                int oldPriority = this.queuedPriority;
                this.queuedPriority = this.store.getCompactPriority();
                if (this.queuedPriority > oldPriority) {
                    this.parent.execute(this);
                    return;
                }
                try {
                    this.compaction = CompactSplitThread.this.selectCompaction(this.region, this.store, this.queuedPriority, null, user);
                }
                catch (IOException ex) {
                    LOG.error((Object)("Compaction selection failed " + this), (Throwable)ex);
                    CompactSplitThread.this.server.checkFileSystem();
                    this.region.decrementCompactionsQueuedCount();
                    return;
                }
                if (this.compaction == null) {
                    this.region.decrementCompactionsQueuedCount();
                    return;
                }
                assert (this.compaction.hasSelection());
                ThreadPoolExecutor threadPoolExecutor = pool = this.store.throttleCompaction(this.compaction.getRequest().getSize()) ? CompactSplitThread.this.longCompactions : CompactSplitThread.this.shortCompactions;
                if (this.parent == CompactSplitThread.this.shortCompactions && pool == CompactSplitThread.this.longCompactions) {
                    this.store.cancelRequestedCompaction(this.compaction);
                    this.compaction = null;
                    this.parent = pool;
                    this.parent.execute(this);
                    return;
                }
            }
            assert (this.compaction != null);
            this.compaction.getRequest().beforeExecute();
            try {
                long start = EnvironmentEdgeManager.currentTime();
                boolean completed = this.region.compact(this.compaction, this.store, CompactSplitThread.this.compactionThroughputController, user);
                long now = EnvironmentEdgeManager.currentTime();
                LOG.info((Object)((completed ? "Completed" : "Aborted") + " compaction: " + this + "; duration=" + StringUtils.formatTimeDiff(now, start)));
                if (completed) {
                    if (this.store.getCompactPriority() <= 0) {
                        CompactSplitThread.this.requestSystemCompaction(this.region, this.store, "Recursive enqueue");
                    } else {
                        CompactSplitThread.this.requestSplit(this.region);
                    }
                }
            }
            catch (IOException ex) {
                IOException remoteEx = RemoteExceptionHandler.checkIOException(ex);
                LOG.error((Object)("Compaction failed " + this), (Throwable)remoteEx);
                if (remoteEx != ex) {
                    LOG.info((Object)("Compaction failed at original callstack: " + this.formatStackTrace(ex)));
                }
                this.region.reportCompactionRequestFailure();
                CompactSplitThread.this.server.checkFileSystem();
            }
            catch (Exception ex) {
                LOG.error((Object)("Compaction failed " + this), (Throwable)ex);
                this.region.reportCompactionRequestFailure();
                CompactSplitThread.this.server.checkFileSystem();
            }
            finally {
                this.region.decrementCompactionsQueuedCount();
                LOG.debug((Object)("CompactSplitThread Status: " + CompactSplitThread.this));
            }
            this.compaction.getRequest().afterExecute();
        }

        @Override
        public void run() {
            Preconditions.checkNotNull(CompactSplitThread.this.server);
            if (CompactSplitThread.this.server.isStopped() || this.region.getTableDesc() != null && !this.region.getTableDesc().isCompactionEnabled()) {
                this.region.decrementCompactionsQueuedCount();
                return;
            }
            this.doCompaction(this.user);
        }

        private String formatStackTrace(Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }

        @Override
        public int compareTo(CompactionRunner o) {
            int compareVal = this.queuedPriority - o.queuedPriority;
            if (compareVal != 0) {
                return compareVal;
            }
            CompactionContext tc = this.compaction;
            CompactionContext oc = o.compaction;
            return tc == null ? (oc == null ? 0 : 1) : (oc == null ? -1 : tc.getRequest().compareTo(oc.getRequest()));
        }
    }
}

