/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.metrics2.MetricsExecutor;

@InterfaceAudience.Private
class MetricsRegionServerWrapperImpl
implements MetricsRegionServerWrapper {
    private static final Log LOG = LogFactory.getLog(MetricsRegionServerWrapperImpl.class);
    private final HRegionServer regionServer;
    private BlockCache blockCache;
    private volatile long numStores = 0L;
    private volatile long numWALFiles = 0L;
    private volatile long walFileSize = 0L;
    private volatile long numStoreFiles = 0L;
    private volatile long memstoreSize = 0L;
    private volatile long storeFileSize = 0L;
    private volatile long maxStoreFileAge = 0L;
    private volatile long minStoreFileAge = 0L;
    private volatile long avgStoreFileAge = 0L;
    private volatile long numReferenceFiles = 0L;
    private volatile double requestsPerSecond = 0.0;
    private volatile long readRequestsCount = 0L;
    private volatile long writeRequestsCount = 0L;
    private volatile long checkAndMutateChecksFailed = 0L;
    private volatile long checkAndMutateChecksPassed = 0L;
    private volatile long storefileIndexSize = 0L;
    private volatile long totalStaticIndexSize = 0L;
    private volatile long totalStaticBloomSize = 0L;
    private volatile long numMutationsWithoutWAL = 0L;
    private volatile long dataInMemoryWithoutWAL = 0L;
    private volatile double percentFileLocal = 0.0;
    private volatile double percentFileLocalSecondaryRegions = 0.0;
    private volatile long flushedCellsCount = 0L;
    private volatile long compactedCellsCount = 0L;
    private volatile long majorCompactedCellsCount = 0L;
    private volatile long flushedCellsSize = 0L;
    private volatile long compactedCellsSize = 0L;
    private volatile long majorCompactedCellsSize = 0L;
    private volatile long blockedRequestsCount = 0L;
    private volatile long averageRegionSize = 0L;
    private CacheStats cacheStats;
    private CacheStats l1Stats = null;
    private CacheStats l2Stats = null;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;

    public MetricsRegionServerWrapperImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.initBlockCache();
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L);
        this.executor = CompatibilitySingletonFactory.getInstance(MetricsExecutor.class).getExecutor();
        this.runnable = new RegionServerMetricsWrapperRunnable();
        this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Computing regionserver metrics every " + this.period + " milliseconds"));
        }
    }

    private synchronized void initBlockCache() {
        CacheConfig cacheConfig = this.regionServer.cacheConfig;
        if (cacheConfig != null) {
            this.l1Stats = cacheConfig.getL1Stats();
            this.l2Stats = cacheConfig.getL2Stats();
            if (this.blockCache == null) {
                this.blockCache = cacheConfig.getBlockCache();
            }
        }
        if (this.blockCache != null && this.cacheStats == null) {
            this.cacheStats = this.blockCache.getStats();
        }
    }

    @Override
    public String getClusterId() {
        return this.regionServer.getClusterId();
    }

    @Override
    public long getStartCode() {
        return this.regionServer.getStartcode();
    }

    @Override
    public String getZookeeperQuorum() {
        ZooKeeperWatcher zk = this.regionServer.getZooKeeper();
        if (zk == null) {
            return "";
        }
        return zk.getQuorum();
    }

    @Override
    public String getCoprocessors() {
        Object[] coprocessors = this.regionServer.getRegionServerCoprocessors();
        if (coprocessors == null || coprocessors.length == 0) {
            return "";
        }
        return StringUtils.join(coprocessors, ", ");
    }

    @Override
    public String getServerName() {
        ServerName serverName = this.regionServer.getServerName();
        if (serverName == null) {
            return "";
        }
        return serverName.getServerName();
    }

    @Override
    public long getNumOnlineRegions() {
        Collection<Region> onlineRegionsLocalContext = this.regionServer.getOnlineRegionsLocalContext();
        if (onlineRegionsLocalContext == null) {
            return 0L;
        }
        return onlineRegionsLocalContext.size();
    }

    @Override
    public long getTotalRequestCount() {
        return this.regionServer.rpcServices.requestCount.get();
    }

    @Override
    public long getTotalRowActionRequestCount() {
        return this.readRequestsCount + this.writeRequestsCount;
    }

    @Override
    public int getSplitQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSplitQueueSize();
    }

    @Override
    public int getCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getCompactionQueueSize();
    }

    @Override
    public int getSmallCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getSmallCompactionQueueSize();
    }

    @Override
    public int getLargeCompactionQueueSize() {
        if (this.regionServer.compactSplitThread == null) {
            return 0;
        }
        return this.regionServer.compactSplitThread.getLargeCompactionQueueSize();
    }

    @Override
    public int getFlushQueueSize() {
        if (this.regionServer.cacheFlusher == null) {
            return 0;
        }
        return this.regionServer.cacheFlusher.getFlushQueueSize();
    }

    @Override
    public long getBlockCacheCount() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getBlockCount();
    }

    @Override
    public long getBlockCacheSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getCurrentSize();
    }

    @Override
    public long getBlockCacheFreeSize() {
        if (this.blockCache == null) {
            return 0L;
        }
        return this.blockCache.getFreeSize();
    }

    @Override
    public long getBlockCacheHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getHitCount();
    }

    @Override
    public long getBlockCachePrimaryHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryHitCount();
    }

    @Override
    public long getBlockCacheMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMissCount();
    }

    @Override
    public long getBlockCachePrimaryMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryMissCount();
    }

    @Override
    public long getBlockCacheEvictedCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getEvictedCount();
    }

    @Override
    public long getBlockCachePrimaryEvictedCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getPrimaryEvictedCount();
    }

    @Override
    public double getBlockCacheHitPercent() {
        if (this.cacheStats == null) {
            return 0.0;
        }
        double ratio = this.cacheStats.getHitRatio();
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public double getBlockCacheHitCachingPercent() {
        if (this.cacheStats == null) {
            return 0.0;
        }
        double ratio = this.cacheStats.getHitCachingRatio();
        if (Double.isNaN(ratio)) {
            ratio = 0.0;
        }
        return ratio * 100.0;
    }

    @Override
    public long getBlockCacheFailedInsertions() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFailedInserts();
    }

    @Override
    public long getL1CacheHitCount() {
        return 200L;
    }

    @Override
    public long getL1CacheMissCount() {
        if (this.l1Stats == null) {
            return 0L;
        }
        return this.l1Stats.getMissCount();
    }

    @Override
    public double getL1CacheHitRatio() {
        if (this.l1Stats == null) {
            return 0.0;
        }
        return this.l1Stats.getHitRatio();
    }

    @Override
    public double getL1CacheMissRatio() {
        if (this.l1Stats == null) {
            return 0.0;
        }
        return this.l1Stats.getMissRatio();
    }

    @Override
    public long getL2CacheHitCount() {
        if (this.l2Stats == null) {
            return 0L;
        }
        return this.l2Stats.getHitCount();
    }

    @Override
    public long getL2CacheMissCount() {
        if (this.l2Stats == null) {
            return 0L;
        }
        return this.l2Stats.getMissCount();
    }

    @Override
    public double getL2CacheHitRatio() {
        if (this.l2Stats == null) {
            return 0.0;
        }
        return this.l2Stats.getHitRatio();
    }

    @Override
    public double getL2CacheMissRatio() {
        if (this.l2Stats == null) {
            return 0.0;
        }
        return this.l2Stats.getMissRatio();
    }

    @Override
    public void forceRecompute() {
        this.runnable.run();
    }

    @Override
    public long getNumStores() {
        return this.numStores;
    }

    @Override
    public long getNumWALFiles() {
        return this.numWALFiles;
    }

    @Override
    public long getWALFileSize() {
        return this.walFileSize;
    }

    @Override
    public long getNumStoreFiles() {
        return this.numStoreFiles;
    }

    @Override
    public long getMaxStoreFileAge() {
        return this.maxStoreFileAge;
    }

    @Override
    public long getMinStoreFileAge() {
        return this.minStoreFileAge;
    }

    @Override
    public long getAvgStoreFileAge() {
        return this.avgStoreFileAge;
    }

    @Override
    public long getNumReferenceFiles() {
        return this.numReferenceFiles;
    }

    @Override
    public long getMemstoreSize() {
        return this.memstoreSize;
    }

    @Override
    public long getStoreFileSize() {
        return this.storeFileSize;
    }

    @Override
    public double getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Override
    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    @Override
    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    @Override
    public long getRpcGetRequestsCount() {
        return this.regionServer.rpcServices.rpcGetRequestCount.get();
    }

    @Override
    public long getRpcScanRequestsCount() {
        return this.regionServer.rpcServices.rpcScanRequestCount.get();
    }

    @Override
    public long getRpcMultiRequestsCount() {
        return this.regionServer.rpcServices.rpcMultiRequestCount.get();
    }

    @Override
    public long getRpcMutateRequestsCount() {
        return this.regionServer.rpcServices.rpcMutateRequestCount.get();
    }

    @Override
    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed;
    }

    @Override
    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed;
    }

    @Override
    public long getStoreFileIndexSize() {
        return this.storefileIndexSize;
    }

    @Override
    public long getTotalStaticIndexSize() {
        return this.totalStaticIndexSize;
    }

    @Override
    public long getTotalStaticBloomSize() {
        return this.totalStaticBloomSize;
    }

    @Override
    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL;
    }

    @Override
    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL;
    }

    @Override
    public double getPercentFileLocal() {
        return this.percentFileLocal;
    }

    @Override
    public double getPercentFileLocalSecondaryRegions() {
        return this.percentFileLocalSecondaryRegions;
    }

    @Override
    public long getUpdatesBlockedTime() {
        if (this.regionServer.cacheFlusher == null) {
            return 0L;
        }
        return this.regionServer.cacheFlusher.getUpdatesBlockedMsHighWater().get();
    }

    @Override
    public long getFlushedCellsCount() {
        return this.flushedCellsCount;
    }

    @Override
    public long getCompactedCellsCount() {
        return this.compactedCellsCount;
    }

    @Override
    public long getMajorCompactedCellsCount() {
        return this.majorCompactedCellsCount;
    }

    @Override
    public long getFlushedCellsSize() {
        return this.flushedCellsSize;
    }

    @Override
    public long getCompactedCellsSize() {
        return this.compactedCellsSize;
    }

    @Override
    public long getMajorCompactedCellsSize() {
        return this.majorCompactedCellsSize;
    }

    @Override
    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount;
    }

    @Override
    public long getAverageRegionSize() {
        return this.averageRegionSize;
    }

    @Override
    public long getDataMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDataMissCount();
    }

    @Override
    public long getLeafIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getLeafIndexMissCount();
    }

    @Override
    public long getBloomChunkMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getBloomChunkMissCount();
    }

    @Override
    public long getMetaMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMetaMissCount();
    }

    @Override
    public long getRootIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getRootIndexMissCount();
    }

    @Override
    public long getIntermediateIndexMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getIntermediateIndexMissCount();
    }

    @Override
    public long getFileInfoMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFileInfoMissCount();
    }

    @Override
    public long getGeneralBloomMetaMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getGeneralBloomMetaMissCount();
    }

    @Override
    public long getDeleteFamilyBloomMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDeleteFamilyBloomMissCount();
    }

    @Override
    public long getTrailerMissCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getTrailerMissCount();
    }

    @Override
    public long getDataHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDataHitCount();
    }

    @Override
    public long getLeafIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getLeafIndexHitCount();
    }

    @Override
    public long getBloomChunkHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getBloomChunkHitCount();
    }

    @Override
    public long getMetaHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getMetaHitCount();
    }

    @Override
    public long getRootIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getRootIndexHitCount();
    }

    @Override
    public long getIntermediateIndexHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getIntermediateIndexHitCount();
    }

    @Override
    public long getFileInfoHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getFileInfoHitCount();
    }

    @Override
    public long getGeneralBloomMetaHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getGeneralBloomMetaHitCount();
    }

    @Override
    public long getDeleteFamilyBloomHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getDeleteFamilyBloomHitCount();
    }

    @Override
    public long getTrailerHitCount() {
        if (this.cacheStats == null) {
            return 0L;
        }
        return this.cacheStats.getTrailerHitCount();
    }

    public class RegionServerMetricsWrapperRunnable
    implements Runnable {
        private long lastRan = 0L;
        private long lastRequestCount = 0L;

        @Override
        public synchronized void run() {
            try {
                MetricsRegionServerWrapperImpl.this.initBlockCache();
                HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
                HDFSBlocksDistribution hdfsBlocksDistributionSecondaryRegions = new HDFSBlocksDistribution();
                long tempNumStores = 0L;
                long tempNumStoreFiles = 0L;
                long tempMemstoreSize = 0L;
                long tempStoreFileSize = 0L;
                long tempMaxStoreFileAge = 0L;
                long tempNumReferenceFiles = 0L;
                long avgAgeNumerator = 0L;
                long numHFiles = 0L;
                long tempMinStoreFileAge = Long.MAX_VALUE;
                long tempReadRequestsCount = 0L;
                long tempWriteRequestsCount = 0L;
                long tempCheckAndMutateChecksFailed = 0L;
                long tempCheckAndMutateChecksPassed = 0L;
                long tempStorefileIndexSize = 0L;
                long tempTotalStaticIndexSize = 0L;
                long tempTotalStaticBloomSize = 0L;
                long tempNumMutationsWithoutWAL = 0L;
                long tempDataInMemoryWithoutWAL = 0L;
                double tempPercentFileLocal = 0.0;
                double tempPercentFileLocalSecondaryRegions = 0.0;
                long tempFlushedCellsCount = 0L;
                long tempCompactedCellsCount = 0L;
                long tempMajorCompactedCellsCount = 0L;
                long tempFlushedCellsSize = 0L;
                long tempCompactedCellsSize = 0L;
                long tempMajorCompactedCellsSize = 0L;
                long tempBlockedRequestsCount = 0L;
                int regionCount = 0;
                for (Region r : MetricsRegionServerWrapperImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                    tempNumMutationsWithoutWAL += r.getNumMutationsWithoutWAL();
                    tempDataInMemoryWithoutWAL += r.getDataInMemoryWithoutWAL();
                    tempReadRequestsCount += r.getReadRequestsCount();
                    tempWriteRequestsCount += r.getWriteRequestsCount();
                    tempCheckAndMutateChecksFailed += r.getCheckAndMutateChecksFailed();
                    tempCheckAndMutateChecksPassed += r.getCheckAndMutateChecksPassed();
                    tempBlockedRequestsCount += r.getBlockedRequestsCount();
                    List<Store> storeList = r.getStores();
                    tempNumStores += (long)storeList.size();
                    for (Store store : storeList) {
                        tempNumStoreFiles += (long)store.getStorefilesCount();
                        tempMemstoreSize += store.getMemStoreSize();
                        tempStoreFileSize += store.getStorefilesSize();
                        long storeMaxStoreFileAge = store.getMaxStoreFileAge();
                        tempMaxStoreFileAge = storeMaxStoreFileAge > tempMaxStoreFileAge ? storeMaxStoreFileAge : tempMaxStoreFileAge;
                        long storeMinStoreFileAge = store.getMinStoreFileAge();
                        tempMinStoreFileAge = storeMinStoreFileAge < tempMinStoreFileAge ? storeMinStoreFileAge : tempMinStoreFileAge;
                        long storeHFiles = store.getNumHFiles();
                        avgAgeNumerator += store.getAvgStoreFileAge() * storeHFiles;
                        numHFiles += storeHFiles;
                        tempNumReferenceFiles += store.getNumReferenceFiles();
                        tempStorefileIndexSize += store.getStorefilesIndexSize();
                        tempTotalStaticBloomSize += store.getTotalStaticBloomSize();
                        tempTotalStaticIndexSize += store.getTotalStaticIndexSize();
                        tempFlushedCellsCount += store.getFlushedCellsCount();
                        tempCompactedCellsCount += store.getCompactedCellsCount();
                        tempMajorCompactedCellsCount += store.getMajorCompactedCellsCount();
                        tempFlushedCellsSize += store.getFlushedCellsSize();
                        tempCompactedCellsSize += store.getCompactedCellsSize();
                        tempMajorCompactedCellsSize += store.getMajorCompactedCellsSize();
                    }
                    HDFSBlocksDistribution distro = r.getHDFSBlocksDistribution();
                    hdfsBlocksDistribution.add(distro);
                    if (r.getRegionInfo().getReplicaId() != 0) {
                        hdfsBlocksDistributionSecondaryRegions.add(distro);
                    }
                    ++regionCount;
                }
                float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocal = Double.isNaN(tempBlockedRequestsCount) ? 0.0 : (double)(localityIndex * 100.0f);
                float localityIndexSecondaryRegions = hdfsBlocksDistributionSecondaryRegions.getBlockLocalityIndex(MetricsRegionServerWrapperImpl.this.regionServer.getServerName().getHostname());
                tempPercentFileLocalSecondaryRegions = Double.isNaN(localityIndexSecondaryRegions) ? 0.0 : (double)(localityIndexSecondaryRegions * 100.0f);
                long currentTime = EnvironmentEdgeManager.currentTime();
                if (this.lastRan == 0L) {
                    this.lastRan = currentTime - MetricsRegionServerWrapperImpl.this.period;
                }
                if (currentTime - this.lastRan > 0L) {
                    long currentRequestCount = MetricsRegionServerWrapperImpl.this.getTotalRequestCount();
                    MetricsRegionServerWrapperImpl.this.requestsPerSecond = (double)(currentRequestCount - this.lastRequestCount) / ((double)(currentTime - this.lastRan) / 1000.0);
                    this.lastRequestCount = currentRequestCount;
                }
                this.lastRan = currentTime;
                WALProvider provider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getWALProvider();
                WALProvider metaProvider = ((MetricsRegionServerWrapperImpl)MetricsRegionServerWrapperImpl.this).regionServer.walFactory.getMetaWALProvider();
                MetricsRegionServerWrapperImpl.this.numWALFiles = (provider == null ? 0L : provider.getNumLogFiles()) + (metaProvider == null ? 0L : metaProvider.getNumLogFiles());
                MetricsRegionServerWrapperImpl.this.walFileSize = (provider == null ? 0L : provider.getLogFileSize()) + (provider == null ? 0L : provider.getLogFileSize());
                MetricsRegionServerWrapperImpl.this.numStores = tempNumStores;
                MetricsRegionServerWrapperImpl.this.numStoreFiles = tempNumStoreFiles;
                MetricsRegionServerWrapperImpl.this.memstoreSize = tempMemstoreSize;
                MetricsRegionServerWrapperImpl.this.storeFileSize = tempStoreFileSize;
                MetricsRegionServerWrapperImpl.this.maxStoreFileAge = tempMaxStoreFileAge;
                if (regionCount > 0) {
                    MetricsRegionServerWrapperImpl.this.averageRegionSize = (MetricsRegionServerWrapperImpl.this.memstoreSize + MetricsRegionServerWrapperImpl.this.storeFileSize) / (long)regionCount;
                }
                if (tempMinStoreFileAge != Long.MAX_VALUE) {
                    MetricsRegionServerWrapperImpl.this.minStoreFileAge = tempMinStoreFileAge;
                }
                if (numHFiles != 0L) {
                    MetricsRegionServerWrapperImpl.this.avgStoreFileAge = avgAgeNumerator / numHFiles;
                }
                MetricsRegionServerWrapperImpl.this.numReferenceFiles = tempNumReferenceFiles;
                MetricsRegionServerWrapperImpl.this.readRequestsCount = tempReadRequestsCount;
                MetricsRegionServerWrapperImpl.this.writeRequestsCount = tempWriteRequestsCount;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksFailed = tempCheckAndMutateChecksFailed;
                MetricsRegionServerWrapperImpl.this.checkAndMutateChecksPassed = tempCheckAndMutateChecksPassed;
                MetricsRegionServerWrapperImpl.this.storefileIndexSize = tempStorefileIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticIndexSize = tempTotalStaticIndexSize;
                MetricsRegionServerWrapperImpl.this.totalStaticBloomSize = tempTotalStaticBloomSize;
                MetricsRegionServerWrapperImpl.this.numMutationsWithoutWAL = tempNumMutationsWithoutWAL;
                MetricsRegionServerWrapperImpl.this.dataInMemoryWithoutWAL = tempDataInMemoryWithoutWAL;
                MetricsRegionServerWrapperImpl.this.percentFileLocal = tempPercentFileLocal;
                MetricsRegionServerWrapperImpl.this.percentFileLocalSecondaryRegions = tempPercentFileLocalSecondaryRegions;
                MetricsRegionServerWrapperImpl.this.flushedCellsCount = tempFlushedCellsCount;
                MetricsRegionServerWrapperImpl.this.compactedCellsCount = tempCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsCount = tempMajorCompactedCellsCount;
                MetricsRegionServerWrapperImpl.this.flushedCellsSize = tempFlushedCellsSize;
                MetricsRegionServerWrapperImpl.this.compactedCellsSize = tempCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.majorCompactedCellsSize = tempMajorCompactedCellsSize;
                MetricsRegionServerWrapperImpl.this.blockedRequestsCount = tempBlockedRequestsCount;
            }
            catch (Throwable e) {
                LOG.warn((Object)"Caught exception! Will suppress and retry.", e);
            }
        }
    }
}

