/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.querymatcher.DropDeletesCompactionScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;

@InterfaceAudience.Private
public class StripeCompactionScanQueryMatcher
extends DropDeletesCompactionScanQueryMatcher {
    private final byte[] dropDeletesFromRow;
    private final byte[] dropDeletesToRow;
    private DropDeletesInOutput dropDeletesInOutput = DropDeletesInOutput.BEFORE;

    public StripeCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) {
        super(scanInfo, deletes, readPointToUse, earliestPutTs, oldestUnexpiredTS, now);
        this.dropDeletesFromRow = dropDeletesFromRow;
        this.dropDeletesToRow = dropDeletesToRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ScanQueryMatcher.MatchCode match(Cell cell) throws IOException {
        ScanQueryMatcher.MatchCode returnCode = this.preCheck(cell);
        if (returnCode != null) {
            return returnCode;
        }
        long mvccVersion = cell.getSequenceId();
        byte typeByte = cell.getTypeByte();
        if (CellUtil.isDelete(typeByte)) {
            if (mvccVersion > this.maxReadPointToTrackVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            this.trackDelete(cell);
            if (this.dropDeletesInOutput != DropDeletesInOutput.IN) return ScanQueryMatcher.MatchCode.INCLUDE;
            this.trackDelete(cell);
            returnCode = this.tryDropDelete(cell);
            if (returnCode == null) return this.columns.checkVersions(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), typeByte, mvccVersion > this.maxReadPointToTrackVersions);
            return returnCode;
        }
        returnCode = this.checkDeleted(this.deletes, cell);
        if (returnCode == null) return this.columns.checkVersions(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), typeByte, mvccVersion > this.maxReadPointToTrackVersions);
        return returnCode;
    }

    private boolean entered() {
        return this.dropDeletesFromRow.length == 0 || this.rowComparator.compareRows(this.currentRow, this.dropDeletesFromRow, 0, this.dropDeletesFromRow.length) >= 0;
    }

    private boolean left() {
        return this.dropDeletesToRow.length > 0 && this.rowComparator.compareRows(this.currentRow, this.dropDeletesToRow, 0, this.dropDeletesToRow.length) >= 0;
    }

    @Override
    protected void reset() {
        super.reset();
        switch (this.dropDeletesInOutput) {
            case BEFORE: {
                if (!this.entered()) break;
                if (this.left()) {
                    this.dropDeletesInOutput = DropDeletesInOutput.AFTER;
                    break;
                }
                this.dropDeletesInOutput = DropDeletesInOutput.IN;
                break;
            }
            case IN: {
                if (!this.left()) break;
                this.dropDeletesInOutput = DropDeletesInOutput.AFTER;
                break;
            }
        }
    }

    private static enum DropDeletesInOutput {
        BEFORE,
        IN,
        AFTER;

    }
}

