/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Predicate;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate {
    private static final Log LOG = LogFactory.getLog(ReplicationLogCleaner.class);
    private ZooKeeperWatcher zkw;
    private ReplicationQueuesClient replicationQueues;
    private boolean stopped = false;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        Set<String> wals;
        if (this.getConf() == null) {
            return files;
        }
        try {
            wals = this.loadWALsFromQueues();
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed to read zookeeper, skipping checking deletable files");
            return Collections.emptyList();
        }
        return Iterables.filter(files, new Predicate<FileStatus>(){

            @Override
            public boolean apply(FileStatus file) {
                String wal = file.getPath().getName();
                boolean logInReplicationQueue = wals.contains(wal);
                if (LOG.isDebugEnabled()) {
                    if (logInReplicationQueue) {
                        LOG.debug((Object)("Found log in ZK, keeping: " + wal));
                    } else {
                        LOG.debug((Object)("Didn't find this log in ZK, deleting: " + wal));
                    }
                }
                return !logInReplicationQueue;
            }
        });
    }

    private Set<String> loadWALsFromQueues() throws KeeperException {
        int retry = 0;
        while (true) {
            int v0 = this.replicationQueues.getQueuesZNodeCversion();
            List<String> rss = this.replicationQueues.getListOfReplicators();
            if (rss == null || rss.isEmpty()) {
                LOG.debug((Object)"Didn't find any region server that replicates, won't prevent any deletions.");
                return ImmutableSet.of();
            }
            HashSet<String> wals = Sets.newHashSet();
            for (String rs : rss) {
                List<String> listOfPeers = this.replicationQueues.getAllQueues(rs);
                if (listOfPeers == null) continue;
                for (String id : listOfPeers) {
                    List<String> peersWals = this.replicationQueues.getLogsInQueue(rs, id);
                    if (peersWals == null) continue;
                    wals.addAll(peersWals);
                }
            }
            int v1 = this.replicationQueues.getQueuesZNodeCversion();
            if (v0 == v1) {
                return wals;
            }
            LOG.info((Object)String.format("Replication queue node cversion changed from %d to %d, retry = %d", v0, v1, retry));
            ++retry;
        }
    }

    @Override
    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", true)) {
            LOG.warn((Object)"Not configured - allowing all wals to be deleted");
            return;
        }
        Configuration conf = new Configuration(config);
        try {
            this.setConf(conf, new ZooKeeperWatcher(conf, "replicationLogCleaner", null));
        }
        catch (IOException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
    }

    @VisibleForTesting
    public void setConf(Configuration conf, ZooKeeperWatcher zk) {
        super.setConf(conf);
        try {
            this.zkw = zk;
            this.replicationQueues = ReplicationFactory.getReplicationQueuesClient(this.zkw, conf, new WarnOnlyAbortable());
            this.replicationQueues.init();
        }
        catch (ReplicationException e) {
            LOG.error((Object)("Error while configuring " + this.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info((Object)("Stopping " + this.zkw));
            this.zkw.close();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    private static class WarnOnlyAbortable
    implements Abortable {
        private WarnOnlyAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            LOG.warn((Object)("ReplicationLogCleaner received abort, ignoring.  Reason: " + why));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
        }

        @Override
        public boolean isAborted() {
            return false;
        }
    }
}

