/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ReplicationSyncUp
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog((String)ReplicationSyncUp.class.getName());
    private static Configuration conf;
    private static final long SLEEP_TIME = 10000L;

    public static void setConfigure(Configuration config) {
        conf = config;
    }

    public static void main(String[] args) throws Exception {
        if (conf == null) {
            conf = HBaseConfiguration.create();
        }
        int ret = ToolRunner.run(conf, new ReplicationSyncUp(), args);
        System.exit(ret);
    }

    @Override
    public int run(String[] args) throws Exception {
        Abortable abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "syncupReplication" + System.currentTimeMillis(), abortable, true);
        Path walRootDir = FSUtils.getWALRootDir(conf);
        FileSystem fs = FSUtils.getWALFileSystem(conf);
        Path oldLogDir = new Path(walRootDir, "oldWALs");
        Path logDir = new Path(walRootDir, "WALs");
        System.out.println("Start Replication Server start");
        Replication replication = new Replication(new DummyServer(zkw), fs, logDir, oldLogDir);
        ReplicationSourceManager manager = replication.getReplicationManager();
        manager.init();
        try {
            int numberOfOldSource = 1;
            while (numberOfOldSource > 0) {
                Thread.sleep(10000L);
                numberOfOldSource = manager.getOldSources().size();
            }
        }
        catch (InterruptedException e) {
            System.err.println("didn't wait long enough:" + e);
            return -1;
        }
        manager.join();
        zkw.close();
        return 0;
    }

    static class DummyServer
    implements Server {
        String hostname;
        ZooKeeperWatcher zkw;

        DummyServer(ZooKeeperWatcher zkw) {
            this.hostname = System.currentTimeMillis() + ".SyncUpTool.replication.org";
            this.zkw = zkw;
        }

        DummyServer(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public Configuration getConfiguration() {
            return conf;
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return this.zkw;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf(this.hostname, 1234, 1L);
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

