/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagRewriteCell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseMasterAndRegionObserver;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AuthResult;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.access.ZKPermissionWatcher;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ListMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.MapMaker;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Service;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class AccessController
extends BaseMasterAndRegionObserver
implements RegionServerObserver,
AccessControlProtos.AccessControlService.Interface,
CoprocessorService,
EndpointObserver,
BulkLoadObserver {
    private static final Log LOG = LogFactory.getLog(AccessController.class);
    private static final Log AUDITLOG = LogFactory.getLog((String)("SecurityLogger." + AccessController.class.getName()));
    private static final String CHECK_COVERING_PERM = "check_covering_perm";
    private static final String TAG_CHECK_PASSED = "tag_check_passed";
    private static final byte[] TRUE = Bytes.toBytes(true);
    TableAuthManager authManager = null;
    boolean aclRegion = false;
    private RegionCoprocessorEnvironment regionEnv;
    private Map<InternalScanner, String> scannerOwners = new MapMaker().weakKeys().makeMap();
    private Map<TableName, List<UserPermission>> tableAcls;
    private UserProvider userProvider;
    boolean authorizationEnabled;
    boolean cellFeaturesEnabled;
    boolean shouldCheckExecPermission;
    boolean compatibleEarlyTermination;
    private volatile boolean initialized = false;
    private volatile boolean aclTabAvailable = false;

    public static boolean isAuthorizationSupported(Configuration conf) {
        return conf.getBoolean("hbase.security.authorization", true);
    }

    public static boolean isCellAuthorizationSupported(Configuration conf) {
        return AccessController.isAuthorizationSupported(conf) && HFile.getFormatVersion(conf) >= 3;
    }

    public Region getRegion() {
        return this.regionEnv != null ? this.regionEnv.getRegion() : null;
    }

    public TableAuthManager getAuthManager() {
        return this.authManager;
    }

    void initialize(RegionCoprocessorEnvironment e) throws IOException {
        Region region = e.getRegion();
        Configuration conf = e.getConfiguration();
        Map<byte[], ListMultimap<String, TablePermission>> tables = AccessControlLists.loadAll(region);
        for (Map.Entry<byte[], ListMultimap<String, TablePermission>> t : tables.entrySet()) {
            byte[] entry = t.getKey();
            ListMultimap<String, TablePermission> perms = t.getValue();
            byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
            this.authManager.getZKPermissionWatcher().writeToZookeeper(entry, serialized);
        }
        this.initialized = true;
    }

    void updateACL(RegionCoprocessorEnvironment e, Map<byte[], List<Cell>> familyMap) {
        TreeSet<byte[]> entries = new TreeSet<byte[]>(Bytes.BYTES_RAWCOMPARATOR);
        for (Map.Entry<byte[], List<Cell>> f : familyMap.entrySet()) {
            List<Cell> cells = f.getValue();
            for (Cell cell : cells) {
                if (!Bytes.equals(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength(), AccessControlLists.ACL_LIST_FAMILY, 0, AccessControlLists.ACL_LIST_FAMILY.length)) continue;
                entries.add(CellUtil.cloneRow(cell));
            }
        }
        ZKPermissionWatcher zkw = this.authManager.getZKPermissionWatcher();
        Configuration conf = this.regionEnv.getConfiguration();
        for (byte[] entry : entries) {
            try {
                HTableInterface t = this.regionEnv.getTable(AccessControlLists.ACL_TABLE_NAME);
                Throwable throwable = null;
                try {
                    ListMultimap<String, TablePermission> perms = AccessControlLists.getPermissions(conf, entry, t);
                    byte[] serialized = AccessControlLists.writePermissionsAsBytes(perms, conf);
                    zkw.writeToZookeeper(entry, serialized);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (t == null) continue;
                    if (throwable != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    t.close();
                }
            }
            catch (IOException ex) {
                LOG.error((Object)("Failed updating permissions mirror for '" + Bytes.toString(entry) + "'"), (Throwable)ex);
            }
        }
    }

    AuthResult permissionGranted(String request, User user, Permission.Action permRequest, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families) {
        HRegionInfo hri = e.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (hri.isMetaRegion() && permRequest == Permission.Action.READ) {
            return AuthResult.allow(request, "All users allowed", user, permRequest, tableName, families);
        }
        if (user == null) {
            return AuthResult.deny(request, "No user associated with request!", null, permRequest, tableName, families);
        }
        if (this.authManager.authorize(user, tableName, (byte[])null, permRequest)) {
            return AuthResult.allow(request, "Table permission granted", user, permRequest, tableName, families);
        }
        if (families != null && families.size() > 0) {
            for (Map.Entry<byte[], Collection<?>> family : families.entrySet()) {
                if (this.authManager.authorize(user, tableName, family.getKey(), permRequest)) continue;
                if (family.getValue() != null && family.getValue().size() > 0) {
                    if (family.getValue() instanceof Set) {
                        Set familySet = (Set)family.getValue();
                        for (byte[] qualifier : familySet) {
                            if (this.authManager.authorize(user, tableName, family.getKey(), qualifier, permRequest)) continue;
                            return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), qualifier));
                        }
                        continue;
                    }
                    if (!(family.getValue() instanceof List)) continue;
                    List kvList = (List)family.getValue();
                    for (KeyValue kv : kvList) {
                        if (this.authManager.authorize(user, tableName, family.getKey(), kv.getQualifier(), permRequest)) continue;
                        return AuthResult.deny(request, "Failed qualifier check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), kv.getQualifier()));
                    }
                    continue;
                }
                return AuthResult.deny(request, "Failed family check", user, permRequest, tableName, this.makeFamilyMap(family.getKey(), null));
            }
            return AuthResult.allow(request, "All family checks passed", user, permRequest, tableName, families);
        }
        return AuthResult.deny(request, "No families to check and table permission failed", user, permRequest, tableName, families);
    }

    AuthResult permissionGranted(OpType opType, User user, RegionCoprocessorEnvironment e, Map<byte[], ? extends Collection<?>> families, Permission.Action ... actions) {
        AuthResult result = null;
        for (Permission.Action action : actions) {
            result = this.permissionGranted(opType.toString(), user, action, e, families);
            if (result.isAllowed()) continue;
            return result;
        }
        return result;
    }

    private void logResult(AuthResult result) {
        if (AUDITLOG.isTraceEnabled()) {
            InetAddress remoteAddr = RpcServer.getRemoteAddress();
            AUDITLOG.trace((Object)("Access " + (result.isAllowed() ? "allowed" : "denied") + " for user " + (result.getUser() != null ? result.getUser().getShortName() : "UNKNOWN") + "; reason: " + result.getReason() + "; remote address: " + (remoteAddr != null ? remoteAddr : "") + "; request: " + result.getRequest() + "; context: " + result.toContextString()));
        }
    }

    private User getActiveUser() throws IOException {
        User user = RpcServer.getRequestUser();
        if (user == null) {
            user = this.userProvider.getCurrent();
        }
        return user;
    }

    private void requirePermission(String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, family, qualifier, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, family, qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requireTablePermission(String request, TableName tableName, byte[] family, byte[] qualifier, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, tableName, null, null, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                result.getParams().setFamily(family).setQualifier(qualifier);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, family, qualifier);
            result.getParams().setFamily(family).setQualifier(qualifier);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requireAccess(String request, TableName tableName, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.hasAccess(user, tableName, permission)) {
                result = AuthResult.allow(request, "Table permission granted", user, permission, tableName, null, null);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, tableName, null, null);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private void requirePermission(String request, Permission.Action perm) throws IOException {
        this.requireGlobalPermission(request, perm, null, null);
    }

    private void requireGlobalPermission(String request, Permission.Action perm, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        if (this.authManager.authorize(user, perm)) {
            result = AuthResult.allow(request, "Global check allowed", user, perm, tableName, familyMap);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
            this.logResult(result);
        } else {
            result = AuthResult.deny(request, "Global check failed", user, perm, tableName, familyMap);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
            this.logResult(result);
            if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
            }
        }
    }

    private void requireGlobalPermission(String request, Permission.Action perm, String namespace) throws IOException {
        User user = this.getActiveUser();
        AuthResult authResult = null;
        if (this.authManager.authorize(user, perm)) {
            authResult = AuthResult.allow(request, "Global check allowed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            this.logResult(authResult);
        } else {
            authResult = AuthResult.deny(request, "Global check failed", user, perm, null);
            authResult.getParams().setNamespace(namespace);
            this.logResult(authResult);
            if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (global, action=" + perm.toString() + ")");
            }
        }
    }

    public void requireNamespacePermission(String request, String namespace, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    public void requireNamespacePermission(String request, String namespace, TableName tableName, Map<byte[], ? extends Collection<byte[]>> familyMap, Permission.Action ... permissions) throws IOException {
        User user = this.getActiveUser();
        AuthResult result = null;
        for (Permission.Action permission : permissions) {
            if (this.authManager.authorize(user, namespace, permission)) {
                result = AuthResult.allow(request, "Namespace permission granted", user, permission, namespace);
                result.getParams().setTableName(tableName).setFamilies(familyMap);
                break;
            }
            result = AuthResult.deny(request, "Insufficient permissions", user, permission, namespace);
            result.getParams().setTableName(tableName).setFamilies(familyMap);
        }
        this.logResult(result);
        if (this.authorizationEnabled && !result.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + result.toContextString());
        }
    }

    private boolean hasFamilyQualifierPermission(User user, Permission.Action perm, RegionCoprocessorEnvironment env, Map<byte[], ? extends Collection<byte[]>> familyMap) throws IOException {
        HRegionInfo hri = env.getRegion().getRegionInfo();
        TableName tableName = hri.getTable();
        if (user == null) {
            return false;
        }
        if (familyMap != null && familyMap.size() > 0) {
            for (Map.Entry<byte[], ? extends Collection<byte[]>> family : familyMap.entrySet()) {
                if (family.getValue() != null && !family.getValue().isEmpty()) {
                    for (byte[] qualifier : family.getValue()) {
                        if (!this.authManager.matchPermission(user, tableName, family.getKey(), qualifier, perm)) continue;
                        return true;
                    }
                    continue;
                }
                if (!this.authManager.matchPermission(user, tableName, family.getKey(), perm)) continue;
                return true;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Empty family map passed for permission check");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCoveringPermission(OpType request, RegionCoprocessorEnvironment e, byte[] row, Map<byte[], ? extends Collection<?>> familyMap, long opTs, Permission.Action ... actions) throws IOException {
        boolean considerCellTs;
        if (!this.cellFeaturesEnabled) {
            return false;
        }
        long cellGrants = 0L;
        User user = this.getActiveUser();
        long latestCellTs = 0L;
        Get get = new Get(row);
        boolean bl = considerCellTs = request == OpType.PUT || request == OpType.DELETE;
        if (considerCellTs) {
            get.setMaxVersions();
        } else {
            get.setMaxVersions(1);
        }
        boolean diffCellTsFromOpTs = false;
        for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
            byte[] col = entry.getKey();
            if (entry.getValue() instanceof Set) {
                Set set = (Set)entry.getValue();
                if (set == null || set.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                for (byte[] qual : set) {
                    get.addColumn(col, qual);
                }
                continue;
            }
            if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                if (list == null || list.isEmpty()) {
                    get.addFamily(col);
                    continue;
                }
                for (Cell cell : list) {
                    if (cell.getQualifierLength() == 0 && (cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode() || cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode())) {
                        get.addFamily(col);
                    } else {
                        get.addColumn(col, CellUtil.cloneQualifier(cell));
                    }
                    if (!considerCellTs) continue;
                    long cellTs = cell.getTimestamp();
                    latestCellTs = Math.max(latestCellTs, cellTs);
                    diffCellTsFromOpTs = diffCellTsFromOpTs || opTs != cellTs;
                }
                continue;
            }
            if (entry.getValue() == null) {
                get.addFamily(col);
                continue;
            }
            throw new RuntimeException("Unhandled collection type " + entry.getValue().getClass().getName());
        }
        long latestTs = Math.max(opTs, latestCellTs);
        if (latestTs == 0L || latestTs == Long.MAX_VALUE) {
            latestTs = EnvironmentEdgeManager.currentTime();
        }
        get.setTimeRange(0L, latestTs + 1L);
        if (!diffCellTsFromOpTs && request == OpType.PUT) {
            get.setMaxVersions(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scanning for cells with " + get));
        }
        HashMap<SimpleMutableByteRange, List> familyMap1 = new HashMap<SimpleMutableByteRange, List>();
        for (Map.Entry<byte[], Collection<?>> entry : familyMap.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            familyMap1.put(new SimpleMutableByteRange(entry.getKey()), (List)entry.getValue());
        }
        RegionScanner scanner = this.getRegion(e).getScanner(new Scan(get));
        ArrayList<Cell> cells = Lists.newArrayList();
        Cell prevCell = null;
        SimpleMutableByteRange curFam = new SimpleMutableByteRange();
        boolean curColAllVersions = request == OpType.DELETE;
        long curColCheckTs = opTs;
        boolean foundColumn = false;
        try {
            boolean more = false;
            ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(1).build();
            do {
                cells.clear();
                more = scanner.next(cells, scannerContext);
                for (Cell cell : cells) {
                    boolean colChange;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Found cell " + cell));
                    }
                    boolean bl2 = colChange = prevCell == null || !CellUtil.matchingColumn(prevCell, cell);
                    if (colChange) {
                        foundColumn = false;
                    }
                    prevCell = cell;
                    if (!curColAllVersions && foundColumn) continue;
                    if (colChange && considerCellTs) {
                        curFam.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
                        List cols = (List)familyMap1.get(curFam);
                        for (Cell col : cols) {
                            if ((col.getQualifierLength() != 0 || request != OpType.DELETE) && !CellUtil.matchingQualifier(cell, col)) continue;
                            byte type = col.getTypeByte();
                            if (considerCellTs) {
                                curColCheckTs = col.getTimestamp();
                            }
                            curColAllVersions = KeyValue.Type.DeleteColumn.getCode() == type || KeyValue.Type.DeleteFamily.getCode() == type;
                            break;
                        }
                    }
                    if (cell.getTimestamp() > curColCheckTs) continue;
                    foundColumn = true;
                    for (Permission.Action action : actions) {
                        if (this.authManager.authorize(user, this.getTableName(e), cell, action)) continue;
                        boolean bl3 = false;
                        return bl3;
                    }
                    ++cellGrants;
                }
            } while (more);
        }
        catch (AccessDeniedException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error((Object)"Exception while getting cells to calculate covering permission", (Throwable)ex);
        }
        finally {
            scanner.close();
        }
        return cellGrants > 0L;
    }

    private static void addCellPermissions(byte[] perms, Map<byte[], List<Cell>> familyMap) {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            ArrayList<TagRewriteCell> newCells = Lists.newArrayList();
            for (Cell cell : e.getValue()) {
                ArrayList<Tag> tags = Lists.newArrayList(new Tag(1, perms));
                if (cell.getTagsLength() > 0) {
                    Iterator<Tag> tagIterator = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
                    while (tagIterator.hasNext()) {
                        tags.add(tagIterator.next());
                    }
                }
                newCells.add(new TagRewriteCell(cell, Tag.fromList(tags)));
            }
            e.setValue(newCells);
        }
    }

    private void checkForReservedTagPresence(User user, Mutation m) throws IOException {
        if (!this.authorizationEnabled) {
            m.setAttribute(TAG_CHECK_PASSED, TRUE);
            return;
        }
        if (Superusers.isSuperUser(user)) {
            m.setAttribute(TAG_CHECK_PASSED, TRUE);
            return;
        }
        if (m.getAttribute(TAG_CHECK_PASSED) != null) {
            return;
        }
        CellScanner cellScanner = m.cellScanner();
        while (cellScanner.advance()) {
            Cell cell = cellScanner.current();
            if (cell.getTagsLength() <= 0) continue;
            Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
            while (tagsItr.hasNext()) {
                if (tagsItr.next().getType() != 1) continue;
                throw new AccessDeniedException("Mutation contains cell with reserved type tag");
            }
        }
        m.setAttribute(TAG_CHECK_PASSED, TRUE);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        CompoundConfiguration conf = new CompoundConfiguration();
        conf.add(env.getConfiguration());
        this.authorizationEnabled = AccessController.isAuthorizationSupported(conf);
        if (!this.authorizationEnabled) {
            LOG.warn((Object)"The AccessController has been loaded with authorization checks disabled.");
        }
        this.shouldCheckExecPermission = conf.getBoolean("hbase.security.exec.permission.checks", false);
        boolean bl = this.cellFeaturesEnabled = HFile.getFormatVersion(conf) >= 3;
        if (!this.cellFeaturesEnabled) {
            LOG.info((Object)"A minimum HFile version of 3 is required to persist cell ACLs. Consider setting hfile.format.version accordingly.");
        }
        ZooKeeperWatcher zk = null;
        if (env instanceof MasterCoprocessorEnvironment) {
            MasterCoprocessorEnvironment mEnv = (MasterCoprocessorEnvironment)env;
            zk = mEnv.getMasterServices().getZooKeeper();
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            RegionServerCoprocessorEnvironment rsEnv = (RegionServerCoprocessorEnvironment)env;
            zk = rsEnv.getRegionServerServices().getZooKeeper();
        } else if (env instanceof RegionCoprocessorEnvironment) {
            this.regionEnv = (RegionCoprocessorEnvironment)env;
            conf.addStringMap(this.regionEnv.getRegion().getTableDesc().getConfiguration());
            zk = this.regionEnv.getRegionServerServices().getZooKeeper();
            this.compatibleEarlyTermination = conf.getBoolean("hbase.security.access.early_out", true);
        }
        this.userProvider = UserProvider.instantiate(env.getConfiguration());
        if (zk != null) {
            try {
                this.authManager = TableAuthManager.getOrCreate(zk, env.getConfiguration());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error obtaining TableAuthManager", ioe);
            }
        } else {
            throw new RuntimeException("Error obtaining TableAuthManager, zk found null.");
        }
        this.tableAcls = new MapMaker().weakValues().makeMap();
    }

    @Override
    public void stop(CoprocessorEnvironment env) {
        if (this.authManager != null) {
            TableAuthManager.release(this.authManager);
        }
    }

    @Override
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        Set<byte[]> families = desc.getFamiliesKeys();
        TreeMap<byte[], Object> familyMap = new TreeMap<byte[], Object>(Bytes.BYTES_COMPARATOR);
        for (byte[] family : families) {
            familyMap.put(family, null);
        }
        this.requireNamespacePermission("createTable", desc.getTableName().getNamespaceAsString(), desc.getTableName(), familyMap, Permission.Action.CREATE);
    }

    @Override
    public void postCreateTableHandler(final ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (AccessControlLists.isAclTable(desc)) {
            this.aclTabAvailable = true;
        } else if (!TableName.NAMESPACE_TABLE_NAME.equals(desc.getTableName())) {
            if (!this.aclTabAvailable) {
                LOG.warn((Object)("Not adding owner permission for table " + desc.getTableName() + ". " + AccessControlLists.ACL_TABLE_NAME + " is not yet created. " + this.getClass().getSimpleName() + " should be configured as the first Coprocessor"));
            } else {
                String owner = desc.getOwnerString();
                if (owner == null) {
                    owner = this.getActiveUser().getShortName();
                }
                final UserPermission userperm = new UserPermission(Bytes.toBytes(owner), desc.getTableName(), null, Permission.Action.values());
                User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        AccessControlLists.addUserPermission(((MasterCoprocessorEnvironment)c.getEnvironment()).getConfiguration(), userperm, ((MasterCoprocessorEnvironment)c.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                        return null;
                    }
                });
            }
        }
    }

    @Override
    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("deleteTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDeleteTable(final ObserverContext<MasterCoprocessorEnvironment> c, final TableName tableName) throws IOException {
        final Configuration conf = c.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AccessControlLists.removeTablePermissions(conf, tableName, ((MasterCoprocessorEnvironment)c.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                return null;
            }
        });
        this.authManager.getZKPermissionWatcher().deleteTableACLNode(tableName);
    }

    @Override
    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> c, final TableName tableName) throws IOException {
        this.requirePermission("truncateTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        final Configuration conf = c.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                List<UserPermission> acls = AccessControlLists.getUserTablePermissions(conf, tableName);
                if (acls != null) {
                    AccessController.this.tableAcls.put(tableName, acls);
                }
                return null;
            }
        });
    }

    @Override
    public void postTruncateTable(final ObserverContext<MasterCoprocessorEnvironment> ctx, final TableName tableName) throws IOException {
        final Configuration conf = ctx.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                List perms = (List)AccessController.this.tableAcls.get(tableName);
                if (perms != null) {
                    for (UserPermission perm : perms) {
                        AccessControlLists.addUserPermission(conf, perm, ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                    }
                }
                AccessController.this.tableAcls.remove(tableName);
                return null;
            }
        });
    }

    @Override
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        this.requirePermission("modifyTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postModifyTable(final ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, final HTableDescriptor htd) throws IOException {
        final Configuration conf = c.getEnvironment().getConfiguration();
        final String owner = htd.getOwnerString() != null ? htd.getOwnerString() : this.getActiveUser().getShortName();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                UserPermission userperm = new UserPermission(Bytes.toBytes(owner), htd.getTableName(), null, Permission.Action.values());
                AccessControlLists.addUserPermission(conf, userperm, ((MasterCoprocessorEnvironment)c.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                return null;
            }
        });
    }

    @Override
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        this.requireTablePermission("addColumn", tableName, column.getName(), null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        this.requirePermission("modifyColumn", tableName, descriptor.getName(), null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        this.requirePermission("deleteColumn", tableName, col, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void postDeleteColumn(final ObserverContext<MasterCoprocessorEnvironment> c, final TableName tableName, final byte[] col) throws IOException {
        final Configuration conf = c.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AccessControlLists.removeTablePermissions(conf, tableName, col, ((MasterCoprocessorEnvironment)c.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                return null;
            }
        });
    }

    @Override
    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        this.requirePermission("enableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (Bytes.equals(tableName.getName(), AccessControlLists.ACL_GLOBAL_NAME)) {
            throw new AccessDeniedException("Not allowed to disable " + AccessControlLists.ACL_TABLE_NAME + " table with AccessController installed");
        }
        this.requirePermission("disableTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx, ProcedureExecutor<MasterProcedureEnv> procEnv, long procId) throws IOException {
        if (!procEnv.isProcedureOwner(procId, this.getActiveUser())) {
            this.requirePermission("abortProcedure", Permission.Action.ADMIN);
        }
    }

    @Override
    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void preListProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public void postListProcedures(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ProcedureInfo> procInfoList) throws IOException {
        if (procInfoList.isEmpty()) {
            return;
        }
        Iterator<ProcedureInfo> itr = procInfoList.iterator();
        User user = this.getActiveUser();
        while (itr.hasNext()) {
            ProcedureInfo procInfo = itr.next();
            try {
                if (ProcedureInfo.isProcedureOwner(procInfo, user)) continue;
                this.requirePermission("listProcedures", Permission.Action.ADMIN);
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        this.requirePermission("move", region.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("assign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        this.requirePermission("unassign", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        this.requirePermission("regionOffline", regionInfo.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public boolean preSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, Admin.MasterSwitchType switchType) throws IOException {
        this.requirePermission("setSplitOrMergeEnabled", Permission.Action.ADMIN);
        return false;
    }

    @Override
    public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean newValue, Admin.MasterSwitchType switchType) throws IOException {
    }

    @Override
    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("balance", Permission.Action.ADMIN);
    }

    @Override
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        this.requirePermission("balanceSwitch", Permission.Action.ADMIN);
        return newValue;
    }

    @Override
    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("shutdown", Permission.Action.ADMIN);
    }

    @Override
    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        this.requirePermission("stopMaster", Permission.Action.ADMIN);
    }

    @Override
    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (!MetaTableAccessor.tableExists(ctx.getEnvironment().getMasterServices().getConnection(), AccessControlLists.ACL_TABLE_NAME)) {
            AccessControlLists.createACLTable(ctx.getEnvironment().getMasterServices());
        } else {
            this.aclTabAvailable = true;
        }
    }

    @Override
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        this.requirePermission("snapshot " + snapshot.getName(), hTableDescriptor.getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        User user = this.getActiveUser();
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user)) {
            AuthResult result = AuthResult.allow("listSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, null, null);
            this.logResult(result);
        } else {
            this.requirePermission("listSnapshot " + snapshot.getName(), Permission.Action.ADMIN);
        }
    }

    @Override
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        User user = this.getActiveUser();
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user) && hTableDescriptor.getNameAsString().equals(snapshot.getTable())) {
            AuthResult result = AuthResult.allow("cloneSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, hTableDescriptor.getTableName(), null);
            this.logResult(result);
        } else {
            this.requirePermission("cloneSnapshot " + snapshot.getName(), Permission.Action.ADMIN);
        }
    }

    @Override
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, this.getActiveUser())) {
            this.requirePermission("restoreSnapshot " + snapshot.getName(), hTableDescriptor.getTableName(), null, null, Permission.Action.ADMIN);
        } else {
            this.requirePermission("restoreSnapshot " + snapshot.getName(), Permission.Action.ADMIN);
        }
    }

    @Override
    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        User user = this.getActiveUser();
        if (SnapshotDescriptionUtils.isSnapshotOwner(snapshot, user)) {
            AuthResult result = AuthResult.allow("deleteSnapshot " + snapshot.getName(), "Snapshot owner check allowed", user, null, null, null);
            this.logResult(result);
        } else {
            this.requirePermission("deleteSnapshot " + snapshot.getName(), Permission.Action.ADMIN);
        }
    }

    @Override
    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("createNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireGlobalPermission("deleteNamespace", Permission.Action.ADMIN, namespace);
    }

    @Override
    public void postDeleteNamespace(final ObserverContext<MasterCoprocessorEnvironment> ctx, final String namespace) throws IOException {
        final Configuration conf = ctx.getEnvironment().getConfiguration();
        User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                AccessControlLists.removeNamespacePermissions(conf, namespace, ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getTable(AccessControlLists.ACL_TABLE_NAME));
                return null;
            }
        });
        this.authManager.getZKPermissionWatcher().deleteNamespaceACLNode(namespace);
        LOG.info((Object)(namespace + " entry deleted in " + AccessControlLists.ACL_TABLE_NAME + " table."));
    }

    @Override
    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.requireGlobalPermission("modifyNamespace", Permission.Action.ADMIN, ns.getName());
    }

    @Override
    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        this.requireNamespacePermission("getNamespaceDescriptor", namespace, Permission.Action.ADMIN);
    }

    @Override
    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        Iterator<NamespaceDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            NamespaceDescriptor desc = itr.next();
            try {
                this.requireNamespacePermission("listNamespaces", desc.getName(), Permission.Action.ADMIN);
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        this.requirePermission("flushTable", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in preOpen()");
        } else {
            HRegionInfo regionInfo = region.getRegionInfo();
            if (regionInfo.getTable().isSystemTable()) {
                this.checkSystemOrSuperUser();
            } else {
                this.requirePermission("preOpen", Permission.Action.ADMIN);
            }
        }
    }

    @Override
    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Region region = env.getRegion();
        if (region == null) {
            LOG.error((Object)"NULL region from RegionCoprocessorEnvironment in postOpen()");
            return;
        }
        if (AccessControlLists.isAclRegion(region)) {
            this.aclRegion = true;
            if (!region.isRecovering()) {
                try {
                    this.initialize(env);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to initialize permissions cache", ex);
                }
            }
        } else {
            this.initialized = true;
        }
    }

    @Override
    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (this.aclRegion) {
            try {
                this.initialize(c.getEnvironment());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to initialize permissions cache", ex);
            }
        }
    }

    @Override
    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("flush", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e, byte[] splitRow) throws IOException {
        this.requirePermission("split", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN);
    }

    @Override
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        this.requirePermission("compact", this.getTableName(e.getEnvironment()), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
        return scanner;
    }

    @Override
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        assert (family != null);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, null);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.GET_CLOSEST_ROW_BEFORE, user, env, families, Permission.Action.READ);
        if (!authResult.isAllowed() && this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            authResult.setAllowed(this.checkCoveringPermission(OpType.GET_CLOSEST_ROW_BEFORE, env, row, families, Long.MAX_VALUE, Permission.Action.READ));
            authResult.setReason("Covering cell set");
        }
        this.logResult(authResult);
        if (this.authorizationEnabled && !authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
        }
    }

    private void internalPreRead(ObserverContext<RegionCoprocessorEnvironment> c, Query query, OpType opType) throws IOException {
        Filter filter = query.getFilter();
        if (filter != null && filter instanceof AccessControlFilter) {
            return;
        }
        User user = this.getActiveUser();
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], NavigableSet<byte[]>> families = null;
        switch (opType) {
            case GET: 
            case EXISTS: {
                families = ((Get)query).getFamilyMap();
                break;
            }
            case SCAN: {
                families = ((Scan)query).getFamilyMap();
                break;
            }
            default: {
                throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
            }
        }
        AuthResult authResult = this.permissionGranted(opType, user, env, families, Permission.Action.READ);
        Region region = this.getRegion(env);
        TableName table = this.getTableName(region);
        HashMap<ByteRange, Integer> cfVsMaxVersions = Maps.newHashMap();
        for (HColumnDescriptor hcd : region.getTableDesc().getFamilies()) {
            cfVsMaxVersions.put(new SimpleMutableByteRange(hcd.getName()), hcd.getMaxVersions());
        }
        if (!authResult.isAllowed()) {
            Filter ourFilter;
            if (!this.cellFeaturesEnabled || this.compatibleEarlyTermination) {
                if (this.hasFamilyQualifierPermission(user, Permission.Action.READ, env, families)) {
                    authResult.setAllowed(true);
                    authResult.setReason("Access allowed with filter");
                    if (this.authorizationEnabled) {
                        ourFilter = new AccessControlFilter(this.authManager, user, table, AccessControlFilter.Strategy.CHECK_TABLE_AND_CF_ONLY, cfVsMaxVersions);
                        if (filter != null) {
                            ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(ourFilter, filter));
                        }
                        switch (opType) {
                            case GET: 
                            case EXISTS: {
                                ((Get)query).setFilter(ourFilter);
                                break;
                            }
                            case SCAN: {
                                ((Scan)query).setFilter(ourFilter);
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                            }
                        }
                    }
                }
            } else {
                authResult.setAllowed(true);
                authResult.setReason("Access allowed with filter");
                if (this.authorizationEnabled) {
                    ourFilter = new AccessControlFilter(this.authManager, user, table, AccessControlFilter.Strategy.CHECK_CELL_DEFAULT, cfVsMaxVersions);
                    if (filter != null) {
                        ourFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, Lists.newArrayList(ourFilter, filter));
                    }
                    switch (opType) {
                        case GET: 
                        case EXISTS: {
                            ((Get)query).setFilter(ourFilter);
                            break;
                        }
                        case SCAN: {
                            ((Scan)query).setFilter(ourFilter);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled operation " + (Object)((Object)opType));
                        }
                    }
                }
            }
        }
        this.logResult(authResult);
        if (this.authorizationEnabled && !authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions for user '" + (user != null ? user.getShortName() : "null") + "' (table=" + table + ", action=READ)");
        }
    }

    @Override
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        this.internalPreRead(c, get, OpType.GET);
    }

    @Override
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        this.internalPreRead(c, get, OpType.EXISTS);
        return exists;
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = put.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.PUT, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
    }

    @Override
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), put.getFamilyCellMap());
        }
    }

    @Override
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on delete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = delete.getFamilyCellMap();
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.DELETE, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            for (int i = 0; i < miniBatchOp.size(); ++i) {
                OpType opType;
                Mutation m = miniBatchOp.getOperation(i);
                if (m.getAttribute(CHECK_COVERING_PERM) == null) continue;
                if (m instanceof Put) {
                    this.checkForReservedTagPresence(this.getActiveUser(), m);
                    opType = OpType.PUT;
                } else {
                    opType = OpType.DELETE;
                }
                AuthResult authResult = null;
                authResult = this.checkCoveringPermission(opType, c.getEnvironment(), m.getRow(), m.getFamilyCellMap(), m.getTimeStamp(), Permission.Action.WRITE) ? AuthResult.allow(opType.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, m.getFamilyCellMap()) : AuthResult.deny(opType.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, m.getFamilyCellMap());
                this.logResult(authResult);
                if (!this.authorizationEnabled || authResult.isAllowed()) continue;
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
    }

    @Override
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (this.aclRegion) {
            this.updateACL(c.getEnvironment(), delete.getFamilyCellMap());
        }
    }

    @Override
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, put);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_PUT, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                put.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = put.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, put.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        if (put.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.CHECK_AND_PUT, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_PUT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_PUT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families);
            this.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute("acl") != null) {
            throw new DoNotRetryIOException("ACL on checkAndDelete has no effect: " + delete.toString());
        }
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.CHECK_AND_DELETE, user, env, families, Permission.Action.READ, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                delete.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        if (delete.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.CHECK_AND_DELETE, c.getEnvironment(), row, families, Long.MAX_VALUE, Permission.Action.READ) ? AuthResult.allow(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families) : AuthResult.deny(OpType.CHECK_AND_DELETE.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.READ, table, families);
            this.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return result;
    }

    @Override
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        RegionCoprocessorEnvironment env = c.getEnvironment();
        Map<byte[], ? extends Collection<byte[]>> families = this.makeFamilyMap(family, qualifier);
        User user = this.getActiveUser();
        AuthResult authResult = this.permissionGranted(OpType.INCREMENT_COLUMN_VALUE, user, env, families, Permission.Action.WRITE);
        if (!authResult.isAllowed() && this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
            authResult.setAllowed(this.checkCoveringPermission(OpType.INCREMENT_COLUMN_VALUE, env, row, families, Long.MAX_VALUE, Permission.Action.WRITE));
            authResult.setReason("Covering cell set");
        }
        this.logResult(authResult);
        if (this.authorizationEnabled && !authResult.isAllowed()) {
            throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
        }
        return -1L;
    }

    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, append);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = append.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.APPEND, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                append.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = append.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, append.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        if (append.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.APPEND, c.getEnvironment(), append.getRow(), append.getFamilyCellMap(), Long.MAX_VALUE, Permission.Action.WRITE) ? AuthResult.allow(OpType.APPEND.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, append.getFamilyCellMap()) : AuthResult.deny(OpType.APPEND.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, append.getFamilyCellMap());
            this.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return null;
    }

    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        byte[] bytes;
        User user = this.getActiveUser();
        this.checkForReservedTagPresence(user, increment);
        RegionCoprocessorEnvironment env = c.getEnvironment();
        NavigableMap<byte[], List<Cell>> families = increment.getFamilyCellMap();
        AuthResult authResult = this.permissionGranted(OpType.INCREMENT, user, env, families, Permission.Action.WRITE);
        this.logResult(authResult);
        if (!authResult.isAllowed()) {
            if (this.cellFeaturesEnabled && !this.compatibleEarlyTermination) {
                increment.setAttribute(CHECK_COVERING_PERM, TRUE);
            } else if (this.authorizationEnabled) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        if ((bytes = increment.getAttribute("acl")) != null) {
            if (this.cellFeaturesEnabled) {
                AccessController.addCellPermissions(bytes, increment.getFamilyCellMap());
            } else {
                throw new DoNotRetryIOException("Cell ACLs cannot be persisted");
            }
        }
        return null;
    }

    @Override
    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        if (increment.getAttribute(CHECK_COVERING_PERM) != null) {
            TableName table = c.getEnvironment().getRegion().getRegionInfo().getTable();
            AuthResult authResult = null;
            authResult = this.checkCoveringPermission(OpType.INCREMENT, c.getEnvironment(), increment.getRow(), increment.getFamilyCellMap(), increment.getTimeRange().getMax(), Permission.Action.WRITE) ? AuthResult.allow(OpType.INCREMENT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, increment.getFamilyCellMap()) : AuthResult.deny(OpType.INCREMENT.toString(), "Covering cell set", this.getActiveUser(), Permission.Action.WRITE, table, increment.getFamilyCellMap());
            this.logResult(authResult);
            if (this.authorizationEnabled && !authResult.isAllowed()) {
                throw new AccessDeniedException("Insufficient permissions " + authResult.toContextString());
            }
        }
        return null;
    }

    @Override
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        byte[] aclBytes;
        if (!this.cellFeaturesEnabled) {
            return newCell;
        }
        ArrayList<Tag> tags = Lists.newArrayList();
        ArrayListMultimap<String, Permission> perms = ArrayListMultimap.create();
        if (oldCell != null && oldCell.getTagsLength() > 0) {
            Iterator<Tag> tagIterator = CellUtil.tagsIterator(oldCell.getTagsArray(), oldCell.getTagsOffset(), oldCell.getTagsLength());
            while (tagIterator.hasNext()) {
                Tag tag = tagIterator.next();
                if (tag.getType() != 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Carrying forward tag from " + oldCell + ": type " + tag.getType() + " length " + tag.getTagLength()));
                    }
                    tags.add(tag);
                    continue;
                }
                AccessControlProtos.UsersAndPermissions.Builder builder = AccessControlProtos.UsersAndPermissions.newBuilder();
                ProtobufUtil.mergeFrom(builder, tag.getBuffer(), tag.getTagOffset(), tag.getTagLength());
                ListMultimap<String, Permission> kvPerms = ProtobufUtil.toUsersAndPermissions(builder.build());
                perms.putAll(kvPerms);
            }
        }
        if ((aclBytes = mutation.getACL()) != null) {
            tags.add(new Tag(1, aclBytes));
        } else if (perms != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Carrying forward ACLs from " + oldCell + ": " + perms));
            }
            tags.add(new Tag(1, ProtobufUtil.toUsersAndPermissions(perms).toByteArray()));
        }
        if (tags.isEmpty()) {
            return newCell;
        }
        TagRewriteCell rewriteCell = new TagRewriteCell(newCell, Tag.fromList(tags));
        return rewriteCell;
    }

    @Override
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.internalPreRead(c, scan, OpType.SCAN);
        return s;
    }

    @Override
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        User user = this.getActiveUser();
        if (user != null && user.getShortName() != null) {
            this.scannerOwners.put(s, user.getShortName());
        }
        return s;
    }

    @Override
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        this.requireScannerOwner(s);
        return hasNext;
    }

    @Override
    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.requireScannerOwner(s);
    }

    @Override
    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.scannerOwners.remove(s);
    }

    private void requireScannerOwner(InternalScanner s) throws AccessDeniedException {
        if (!RpcServer.isInRpcCallContext()) {
            return;
        }
        String requestUserName = RpcServer.getRequestUserName();
        String owner = this.scannerOwners.get(s);
        if (this.authorizationEnabled && owner != null && !owner.equals(requestUserName)) {
            throw new AccessDeniedException("User '" + requestUserName + "' is not the scanner owner!");
        }
    }

    @Override
    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        for (Pair<byte[], String> el : familyPaths) {
            this.requirePermission("preBulkLoadHFile", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), el.getFirst(), null, Permission.Action.CREATE);
        }
    }

    @Override
    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.PrepareBulkLoadRequest request) throws IOException {
        this.requireAccess("prePareBulkLoad", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), Permission.Action.CREATE);
    }

    @Override
    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.CleanupBulkLoadRequest request) throws IOException {
        this.requireAccess("preCleanupBulkLoad", ctx.getEnvironment().getRegion().getTableDesc().getTableName(), Permission.Action.CREATE);
    }

    @Override
    public Message preEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request) throws IOException {
        if (this.shouldCheckExecPermission && !(service instanceof AccessControlProtos.AccessControlService)) {
            this.requirePermission("invoke(" + service.getDescriptorForType().getName() + "." + methodName + ")", this.getTableName(ctx.getEnvironment()), null, null, Permission.Action.EXEC);
        }
        return request;
    }

    @Override
    public void postEndpointInvocation(ObserverContext<RegionCoprocessorEnvironment> ctx, Service service, String methodName, Message request, Message.Builder responseBuilder) throws IOException {
    }

    @Override
    public void grant(RpcController controller, final AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        final UserPermission perm = ProtobufUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.GrantResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to grant access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("grant", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireNamespacePermission("grant", perm.getNamespace(), Permission.Action.ADMIN);
                    }
                }
                User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        AccessControlLists.addUserPermission(AccessController.this.regionEnv.getConfiguration(), perm, AccessController.this.regionEnv.getTable(AccessControlLists.ACL_TABLE_NAME), request.getMergeExistingPermissions());
                        return null;
                    }
                });
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Granted permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.GrantResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        final UserPermission perm = ProtobufUtil.toUserPermission(request.getUserPermission());
        AccessControlProtos.RevokeResponse response = null;
        try {
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received request to revoke access permission " + perm.toString()));
                }
                switch (request.getUserPermission().getPermission().getType()) {
                    case Global: 
                    case Table: {
                        this.requirePermission("revoke", perm.getTableName(), perm.getFamily(), perm.getQualifier(), Permission.Action.ADMIN);
                        break;
                    }
                    case Namespace: {
                        this.requireNamespacePermission("revoke", perm.getNamespace(), Permission.Action.ADMIN);
                    }
                }
                User.runAsLoginUser(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        AccessControlLists.removeUserPermission(AccessController.this.regionEnv.getConfiguration(), perm, null);
                        return null;
                    }
                });
                if (AUDITLOG.isTraceEnabled()) {
                    AUDITLOG.trace((Object)("Revoked permission " + perm.toString()));
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = AccessControlProtos.RevokeResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        AccessControlProtos.GetUserPermissionsResponse response = null;
        try {
            List<UserPermission> perms;
            if (this.aclRegion) {
                if (!this.initialized) {
                    throw new CoprocessorException("AccessController not yet initialized");
                }
                perms = null;
                if (request.getType() == AccessControlProtos.Permission.Type.Table) {
                    final TableName table = request.hasTableName() ? ProtobufUtil.toTableName(request.getTableName()) : null;
                    this.requirePermission("userPermissions", table, null, null, Permission.Action.ADMIN);
                    perms = User.runAsLoginUser(new PrivilegedExceptionAction<List<UserPermission>>(){

                        @Override
                        public List<UserPermission> run() throws Exception {
                            return AccessControlLists.getUserTablePermissions(AccessController.this.regionEnv.getConfiguration(), table);
                        }
                    });
                } else if (request.getType() == AccessControlProtos.Permission.Type.Namespace) {
                    final String namespace = request.getNamespaceName().toStringUtf8();
                    this.requireNamespacePermission("userPermissions", namespace, Permission.Action.ADMIN);
                    perms = User.runAsLoginUser(new PrivilegedExceptionAction<List<UserPermission>>(){

                        @Override
                        public List<UserPermission> run() throws Exception {
                            return AccessControlLists.getUserNamespacePermissions(AccessController.this.regionEnv.getConfiguration(), namespace);
                        }
                    });
                } else {
                    this.requirePermission("userPermissions", Permission.Action.ADMIN);
                    perms = User.runAsLoginUser(new PrivilegedExceptionAction<List<UserPermission>>(){

                        @Override
                        public List<UserPermission> run() throws Exception {
                            return AccessControlLists.getUserPermissions(AccessController.this.regionEnv.getConfiguration(), null);
                        }
                    });
                    for (String user : Superusers.getSuperUsers()) {
                        perms.add(new UserPermission(user.getBytes(), AccessControlLists.ACL_TABLE_NAME, null, Permission.Action.values()));
                    }
                }
            } else {
                throw new CoprocessorException(AccessController.class, "This method can only execute at " + AccessControlLists.ACL_TABLE_NAME + " table.");
            }
            response = ResponseConverter.buildGetUserPermissionsResponse(perms);
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        Permission[] permissions = new Permission[request.getPermissionCount()];
        for (int i = 0; i < request.getPermissionCount(); ++i) {
            permissions[i] = ProtobufUtil.toPermission(request.getPermission(i));
        }
        AccessControlProtos.CheckPermissionsResponse response = null;
        try {
            User user = this.getActiveUser();
            TableName tableName = this.regionEnv.getRegion().getTableDesc().getTableName();
            for (Permission permission : permissions) {
                if (permission instanceof TablePermission) {
                    TablePermission tperm = (TablePermission)permission;
                    for (Permission.Action action : permission.getActions()) {
                        if (!tperm.getTableName().equals(tableName)) {
                            throw new CoprocessorException(AccessController.class, String.format("This method can only execute at the table specified in TablePermission. Table of the region:%s , requested table:%s", tableName, tperm.getTableName()));
                        }
                        TreeMap<byte[], TreeSet<byte[]>> familyMap = new TreeMap<byte[], TreeSet<byte[]>>(Bytes.BYTES_COMPARATOR);
                        if (tperm.getFamily() != null) {
                            if (tperm.getQualifier() != null) {
                                TreeSet<byte[]> qualifiers = Sets.newTreeSet(Bytes.BYTES_COMPARATOR);
                                qualifiers.add(tperm.getQualifier());
                                familyMap.put(tperm.getFamily(), qualifiers);
                            } else {
                                familyMap.put(tperm.getFamily(), null);
                            }
                        }
                        AuthResult result = this.permissionGranted("checkPermissions", user, action, this.regionEnv, familyMap);
                        this.logResult(result);
                        if (result.isAllowed()) continue;
                        throw new AccessDeniedException("Insufficient permissions (table=" + tableName + (familyMap.size() > 0 ? ", family: " + result.toFamilyString() : "") + ", action=" + action.toString() + ")");
                    }
                    continue;
                }
                for (Permission.Action action : permission.getActions()) {
                    AuthResult result = this.authManager.authorize(user, action) ? AuthResult.allow("checkPermissions", "Global action allowed", user, action, null, null) : AuthResult.deny("checkPermissions", "Global action denied", user, action, null, null);
                    this.logResult(result);
                    if (result.isAllowed()) continue;
                    throw new AccessDeniedException("Insufficient permissions (action=" + action.toString() + ")");
                }
            }
            response = AccessControlProtos.CheckPermissionsResponse.getDefaultInstance();
        }
        catch (IOException ioe) {
            ResponseConverter.setControllerException(controller, ioe);
        }
        done.run(response);
    }

    @Override
    public Service getService() {
        return AccessControlProtos.AccessControlService.newReflectiveService(this);
    }

    private Region getRegion(RegionCoprocessorEnvironment e) {
        return e.getRegion();
    }

    private TableName getTableName(RegionCoprocessorEnvironment e) {
        Region region = e.getRegion();
        if (region != null) {
            return this.getTableName(region);
        }
        return null;
    }

    private TableName getTableName(Region region) {
        HRegionInfo regionInfo = region.getRegionInfo();
        if (regionInfo != null) {
            return regionInfo.getTable();
        }
        return null;
    }

    @Override
    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        this.requirePermission("preClose", Permission.Action.ADMIN);
    }

    private void checkSystemOrSuperUser() throws IOException {
        if (!this.authorizationEnabled) {
            return;
        }
        User activeUser = this.getActiveUser();
        if (!Superusers.isSuperUser(activeUser)) {
            throw new AccessDeniedException("User '" + (activeUser != null ? activeUser.getShortName() : "null") + "' is not system or super user.");
        }
    }

    @Override
    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        this.requirePermission("preStopRegionServer", Permission.Action.ADMIN);
    }

    private Map<byte[], ? extends Collection<byte[]>> makeFamilyMap(byte[] family, byte[] qualifier) {
        if (family == null) {
            return null;
        }
        TreeMap<byte[], ImmutableSet<byte[]>> familyMap = new TreeMap<byte[], ImmutableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, qualifier != null ? ImmutableSet.of(qualifier) : null);
        return familyMap;
    }

    @Override
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (regex == null && tableNamesList != null && !tableNamesList.isEmpty()) {
            MasterServices masterServices = ctx.getEnvironment().getMasterServices();
            for (TableName tableName : tableNamesList) {
                if (masterServices.getTableDescriptors().get(tableName) == null) continue;
                this.requirePermission("getTableDescriptors", tableName, null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
        }
    }

    @Override
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (regex == null && tableNamesList != null && !tableNamesList.isEmpty()) {
            return;
        }
        Iterator<HTableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            HTableDescriptor htd = itr.next();
            try {
                this.requirePermission("getTableDescriptors", htd.getTableName(), null, null, Permission.Action.ADMIN, Permission.Action.CREATE);
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
        Iterator<HTableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            HTableDescriptor htd = itr.next();
            try {
                this.requireAccess("getTableNames", htd.getTableName(), Permission.Action.values());
            }
            catch (AccessDeniedException e) {
                itr.remove();
            }
        }
    }

    @Override
    public void preDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionA, HRegionInfo regionB) throws IOException {
        this.requirePermission("mergeRegions", regionA.getTable(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission("clearDeadServers", Permission.Action.ADMIN);
    }

    @Override
    public void postClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ServerName> servers, List<ServerName> notClearedServers) throws IOException {
    }

    @Override
    public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        this.requirePermission("mergeRegions", regionA.getTableDesc().getTableName(), null, null, Permission.Action.ADMIN);
    }

    @Override
    public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, Region regionA, Region regionB, Region mergedRegion) throws IOException {
    }

    @Override
    public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, List<Mutation> metaEntries) throws IOException {
    }

    @Override
    public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, Region mergedRegion) throws IOException {
    }

    @Override
    public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
    }

    @Override
    public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
    }

    @Override
    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission("preRollLogWriterRequest", Permission.Action.ADMIN);
    }

    @Override
    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
    }

    @Override
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        return endpoint;
    }

    @Override
    public void preReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        this.requirePermission("replicateLogEntries", Permission.Action.WRITE);
    }

    @Override
    public void postReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
        this.requirePermission("setUserQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        this.requirePermission("setUserTableQuota", tableName, null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        this.requirePermission("setUserNamespaceQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        this.requirePermission("setTableQuota", tableName, null, null, Permission.Action.ADMIN);
    }

    @Override
    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        this.requirePermission("setNamespaceQuota", Permission.Action.ADMIN);
    }

    @Override
    public void preMoveServersAndTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, Set<TableName> tables, String targetGroup) throws IOException {
        this.requirePermission("moveServersAndTables", Permission.Action.ADMIN);
    }

    @Override
    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
        this.requirePermission("moveServers", Permission.Action.ADMIN);
    }

    @Override
    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
        this.requirePermission("moveTables", Permission.Action.ADMIN);
    }

    @Override
    public void preRemoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers) throws IOException {
        this.requirePermission("removeServers", Permission.Action.ADMIN);
    }

    @Override
    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        this.requirePermission("addRSGroup", Permission.Action.ADMIN);
    }

    @Override
    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
        this.requirePermission("removeRSGroup", Permission.Action.ADMIN);
    }

    @Override
    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
        this.requirePermission("balanceRSGroup", Permission.Action.ADMIN);
    }

    @Override
    public void preGetClusterStatus(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        this.requirePermission("getClusterStatus", Permission.Action.ADMIN);
    }

    private static enum OpType {
        GET_CLOSEST_ROW_BEFORE("getClosestRowBefore"),
        GET("get"),
        EXISTS("exists"),
        SCAN("scan"),
        PUT("put"),
        DELETE("delete"),
        CHECK_AND_PUT("checkAndPut"),
        CHECK_AND_DELETE("checkAndDelete"),
        INCREMENT_COLUMN_VALUE("incrementColumnValue"),
        APPEND("append"),
        INCREMENT("increment");

        private String type;

        private OpType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

