/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Version;
import org.apache.hadoop.hbase.shaded.org.jamon.AbstractTemplateImpl;
import org.apache.hadoop.hbase.shaded.org.jamon.TemplateManager;
import org.apache.hadoop.hbase.shaded.org.jamon.emit.StandardEmitter;
import org.apache.hadoop.hbase.shaded.org.jamon.escaping.Escaping;
import org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheViewTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.RegionListTmpl;
import org.apache.hadoop.hbase.tmpl.regionserver.ServerMetricsTmpl;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;

public class RSStatusTmplImpl
extends AbstractTemplateImpl
implements RSStatusTmpl.Intf {
    private final HRegionServer regionServer;
    private final String format;
    private final String filter;
    private final String bcn;
    private final String bcv;

    protected static RSStatusTmpl.ImplData __jamon_setOptionalArguments(RSStatusTmpl.ImplData p_implData) {
        if (!p_implData.getFormat__IsNotDefault()) {
            p_implData.setFormat("html");
        }
        if (!p_implData.getFilter__IsNotDefault()) {
            p_implData.setFilter("general");
        }
        if (!p_implData.getBcn__IsNotDefault()) {
            p_implData.setBcn("");
        }
        if (!p_implData.getBcv__IsNotDefault()) {
            p_implData.setBcv("");
        }
        return p_implData;
    }

    public RSStatusTmplImpl(TemplateManager p_templateManager, RSStatusTmpl.ImplData p_implData) {
        super(p_templateManager, RSStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
        this.format = p_implData.getFormat();
        this.filter = p_implData.getFilter();
        this.bcn = p_implData.getBcn();
        this.bcv = p_implData.getBcv();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        if (this.format.equals("json") && this.bcn != null && this.bcn.length() > 0) {
            jamonWriter.write("\n  ");
            BlockCacheViewTmpl __jamon__var_0 = new BlockCacheViewTmpl(this.getTemplateManager());
            __jamon__var_0.renderNoFlush(jamonWriter, this.regionServer.getCacheConfig(), this.regionServer.getConfiguration(), this.bcn, this.bcv);
            jamonWriter.write("\n  ");
            return;
        }
        if (this.format.equals("json")) {
            jamonWriter.write("\n  ");
            TaskMonitorTmpl __jamon__var_1 = new TaskMonitorTmpl(this.getTemplateManager());
            __jamon__var_1.setFilter(this.filter);
            __jamon__var_1.setFormat("json");
            __jamon__var_1.renderNoFlush(jamonWriter);
            jamonWriter.write("\n  ");
            return;
        }
        jamonWriter.write("\n");
        AdminProtos.ServerInfo serverInfo = ProtobufUtil.getServerInfo(null, this.regionServer.getRSRpcServices());
        ServerName serverName = ProtobufUtil.toServerName(serverInfo.getServerName());
        List<HRegionInfo> onlineRegions = ProtobufUtil.getOnlineRegions(this.regionServer.getRSRpcServices());
        MasterAddressTracker masterAddressTracker = this.regionServer.getMasterAddressTracker();
        ServerName masterServerName = masterAddressTracker == null ? null : masterAddressTracker.getMasterAddress();
        int infoPort = masterAddressTracker == null ? 0 : masterAddressTracker.getMasterInfoPort();
        jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HBase Region Server: ");
        Escaping.HTML.write(StandardEmitter.valueOf(serverName.getHostname()), jamonWriter);
        jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container-fluid\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/rs-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
        if (HBaseConfiguration.isShowConfInServlet()) {
            jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
        }
        jamonWriter.write("\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n  <div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>RegionServer <small>");
        Escaping.HTML.write(StandardEmitter.valueOf(serverName), jamonWriter);
        jamonWriter.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n\n    <section>\n    <h2>Server Metrics</h2>\n    ");
        ServerMetricsTmpl __jamon__var_2 = new ServerMetricsTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, this.regionServer.getRegionServerMetrics().getRegionServerWrapper(), this.regionServer.getRpcServer().getMetrics().getHBaseServerWrapper());
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Block Cache</h2>\n    ");
        BlockCacheTmpl __jamon__var_3 = new BlockCacheTmpl(this.getTemplateManager());
        __jamon__var_3.renderNoFlush(jamonWriter, this.regionServer.getCacheConfig(), this.regionServer.getConfiguration());
        jamonWriter.write("\n    </section>\n\n    <section>\n    ");
        TaskMonitorTmpl __jamon__var_4 = new TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_4.setFilter(this.filter);
        __jamon__var_4.renderNoFlush(jamonWriter);
        jamonWriter.write("\n    </section>\n\n    <section>\n    <h2>Regions</h2>\n    ");
        RegionListTmpl __jamon__var_5 = new RegionListTmpl(this.getTemplateManager());
        __jamon__var_5.renderNoFlush(jamonWriter, this.regionServer, onlineRegions);
        jamonWriter.write("\n    </section>\n\n\n    <section>\n    <h2>Software Attributes</h2>\n    <table id=\"attributes_table\" class=\"table table-striped\">\n        <tr>\n            <th>Attribute Name</th>\n            <th>Value</th>\n            <th>Description</th>\n        </tr>\n        <tr>\n            <td>HBase Version</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.HTML.write(StandardEmitter.valueOf(VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>HBase version and revision</td>\n        </tr>\n        <tr>\n            <td>HBase Compiled</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf(VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When HBase version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>HBase Source Checksum</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>HBase source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>Hadoop Version</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.HTML.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Hadoop version and revision</td>\n        </tr>\n        <tr>\n            <td>Hadoop Compiled</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
        jamonWriter.write(", ");
        Escaping.HTML.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When Hadoop version was compiled and by whom</td>\n        </tr>\n        <tr>\n            <td>Hadoop Source Checksum</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Hadoop source MD5 checksum</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Version</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(Version.getVersion()), jamonWriter);
        jamonWriter.write(", revision=");
        Escaping.HTML.write(StandardEmitter.valueOf(Version.getRevision()), jamonWriter);
        jamonWriter.write("</td>\n            <td>ZooKeeper client version and revision</td>\n        </tr>\n        <tr>\n            <td>ZooKeeper Client Compiled</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(Version.getBuildDate()), jamonWriter);
        jamonWriter.write("</td>\n            <td>When ZooKeeper client version was compiled</td>\n        </tr>\n        <tr>\n            <td>Zookeeper Quorum</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(this.regionServer.getZooKeeper().getQuorum()), jamonWriter);
        jamonWriter.write("</td>\n            <td>Addresses of all registered ZK servers</td>\n        </tr>\n        <tr>\n            <td>Coprocessors</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(Arrays.toString(this.regionServer.getRegionServerCoprocessors())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Coprocessors currently loaded by this regionserver</td>\n        </tr>\n        <tr>\n            <td>RS Start Time</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf(new Date(this.regionServer.getStartcode())), jamonWriter);
        jamonWriter.write("</td>\n            <td>Date stamp of when this region server was started</td>\n        </tr>\n        <tr>\n            <td>HBase Master</td>\n            <td>\n                ");
        if (masterServerName == null) {
            jamonWriter.write("\n                No master found\n                ");
        } else {
            jamonWriter.write("\n                ");
            String host = masterServerName.getHostname() + ":" + infoPort;
            String url = "//" + host + "/master-status";
            jamonWriter.write("<a href=\"");
            Escaping.HTML.write(StandardEmitter.valueOf(url), jamonWriter);
            jamonWriter.write("\">");
            Escaping.HTML.write(StandardEmitter.valueOf(host), jamonWriter);
            jamonWriter.write("</a>\n                ");
        }
        jamonWriter.write("\n            </td>\n            <td>Address of HBase Master</td>\n        </tr>\n    </table>\n    </section>\n    </div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n");
    }
}

