/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class HBaseFsckRepair {
    private static final Log LOG = LogFactory.getLog(HBaseFsckRepair.class);

    public static void fixMultiAssignment(HConnection connection, HRegionInfo region, List<ServerName> servers) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        for (ServerName server : servers) {
            HBaseFsckRepair.closeRegionSilentlyAndWait(connection, server, actualRegion);
        }
        HBaseFsckRepair.forceOfflineInZK(connection.getAdmin(), actualRegion);
    }

    public static void fixUnassigned(Admin admin, HRegionInfo region) throws IOException, KeeperException, InterruptedException {
        HRegionInfo actualRegion = new HRegionInfo(region);
        HBaseFsckRepair.forceOfflineInZK(admin, actualRegion);
    }

    private static void forceOfflineInZK(Admin admin, HRegionInfo region) throws ZooKeeperConnectionException, KeeperException, IOException, InterruptedException {
        admin.assign(region.getRegionName());
    }

    public static void waitUntilAssigned(Admin admin, HRegionInfo region) throws IOException, InterruptedException {
        long timeout = admin.getConfiguration().getLong("hbase.hbck.assign.timeout", 120000L);
        long expiration = timeout + EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() < expiration) {
            try {
                boolean inTransition = false;
                for (RegionState rs : admin.getClusterStatus().getRegionsInTransition()) {
                    if (!rs.getRegion().equals(region)) continue;
                    inTransition = true;
                    break;
                }
                if (!inTransition) {
                    return;
                }
                LOG.info((Object)("Region still in transition, waiting for it to become assigned: " + region));
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when waiting for region to become assigned, retrying", (Throwable)e);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to move out of " + "transition within timeout " + timeout + "ms");
    }

    public static void closeRegionSilentlyAndWait(HConnection connection, ServerName server, HRegionInfo region) throws IOException, InterruptedException {
        long timeout = connection.getConfiguration().getLong("hbase.hbck.close.timeout", 120000L);
        ServerManager.closeRegionSilentlyAndWait((ClusterConnection)connection, server, region, timeout);
    }

    public static void fixMetaHoleOnlineAndAddReplicas(Configuration conf, HRegionInfo hri, Collection<ServerName> servers, int numReplicas) throws IOException {
        Connection conn = ConnectionFactory.createConnection(conf);
        Table meta = conn.getTable(TableName.META_TABLE_NAME);
        Put put = MetaTableAccessor.makePutFromRegionInfo(hri);
        if (numReplicas > 1) {
            Random r = new Random();
            ServerName[] serversArr = servers.toArray(new ServerName[servers.size()]);
            for (int i = 1; i < numReplicas; ++i) {
                ServerName sn = serversArr[r.nextInt(serversArr.length)];
                MetaTableAccessor.addLocation(put, sn, sn.getStartcode(), -1L, i);
            }
        }
        meta.put(put);
        meta.close();
        conn.close();
    }

    public static HRegion createHDFSRegionDir(Configuration conf, HRegionInfo hri, HTableDescriptor htd) throws IOException {
        Path root = FSUtils.getRootDir(conf);
        HRegion region = HRegion.createHRegion(hri, root, conf, htd, null);
        HRegion.closeHRegion(region);
        return region;
    }

    public static void removeParentInMeta(Configuration conf, HRegionInfo hri) throws IOException {
        Connection conn = ConnectionFactory.createConnection(conf);
        MetaTableAccessor.deleteRegion(conn, hri);
    }
}

