/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class XAttrHelper {
    public static XAttr buildXAttr(String name) {
        return XAttrHelper.buildXAttr(name, null);
    }

    public static XAttr buildXAttr(String name, byte[] value) {
        XAttr.NameSpace ns;
        Preconditions.checkNotNull(name, "XAttr name cannot be null.");
        int prefixIndex = name.indexOf(".");
        if (prefixIndex < 3) {
            throw new HadoopIllegalArgumentException("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'");
        }
        if (prefixIndex == name.length() - 1) {
            throw new HadoopIllegalArgumentException("XAttr name cannot be empty.");
        }
        String prefix = name.substring(0, prefixIndex);
        if (StringUtils.equalsIgnoreCase(prefix, XAttr.NameSpace.USER.toString())) {
            ns = XAttr.NameSpace.USER;
        } else if (StringUtils.equalsIgnoreCase(prefix, XAttr.NameSpace.TRUSTED.toString())) {
            ns = XAttr.NameSpace.TRUSTED;
        } else if (StringUtils.equalsIgnoreCase(prefix, XAttr.NameSpace.SYSTEM.toString())) {
            ns = XAttr.NameSpace.SYSTEM;
        } else if (StringUtils.equalsIgnoreCase(prefix, XAttr.NameSpace.SECURITY.toString())) {
            ns = XAttr.NameSpace.SECURITY;
        } else if (StringUtils.equalsIgnoreCase(prefix, XAttr.NameSpace.RAW.toString())) {
            ns = XAttr.NameSpace.RAW;
        } else {
            throw new HadoopIllegalArgumentException("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'");
        }
        XAttr xAttr = new XAttr.Builder().setNameSpace(ns).setName(name.substring(prefixIndex + 1)).setValue(value).build();
        return xAttr;
    }

    public static List<XAttr> buildXAttrAsList(String name) {
        XAttr xAttr = XAttrHelper.buildXAttr(name);
        ArrayList<XAttr> xAttrs = Lists.newArrayListWithCapacity(1);
        xAttrs.add(xAttr);
        return xAttrs;
    }

    public static byte[] getFirstXAttrValue(List<XAttr> xAttrs) {
        byte[] value = null;
        XAttr xAttr = XAttrHelper.getFirstXAttr(xAttrs);
        if (xAttr != null && (value = xAttr.getValue()) == null) {
            value = new byte[]{};
        }
        return value;
    }

    public static XAttr getFirstXAttr(List<XAttr> xAttrs) {
        if (xAttrs != null && !xAttrs.isEmpty()) {
            return xAttrs.get(0);
        }
        return null;
    }

    public static Map<String, byte[]> buildXAttrMap(List<XAttr> xAttrs) {
        if (xAttrs == null) {
            return null;
        }
        HashMap<String, byte[]> xAttrMap = Maps.newHashMap();
        for (XAttr xAttr : xAttrs) {
            String name = XAttrHelper.getPrefixName(xAttr);
            byte[] value = xAttr.getValue();
            if (value == null) {
                value = new byte[]{};
            }
            xAttrMap.put(name, value);
        }
        return xAttrMap;
    }

    public static String getPrefixName(XAttr xAttr) {
        if (xAttr == null) {
            return null;
        }
        String namespace = xAttr.getNameSpace().toString();
        return StringUtils.toLowerCase(namespace) + "." + xAttr.getName();
    }

    public static List<XAttr> buildXAttrs(List<String> names) {
        if (names == null || names.isEmpty()) {
            throw new HadoopIllegalArgumentException("XAttr names can not be null or empty.");
        }
        ArrayList<XAttr> xAttrs = Lists.newArrayListWithCapacity(names.size());
        for (String name : names) {
            xAttrs.add(XAttrHelper.buildXAttr(name, null));
        }
        return xAttrs;
    }
}

