/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class ContainerBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(ContainerBlock.class);
    protected ApplicationBaseProtocol appBaseProt;

    @Inject
    public ContainerBlock(ApplicationBaseProtocol appBaseProt, View.ViewContext ctx) {
        super(ctx);
        this.appBaseProt = appBaseProt;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        String containerid = this.$("container.id");
        if (containerid.isEmpty()) {
            this.puts("Bad request: requires container ID");
            return;
        }
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId(containerid);
        }
        catch (IllegalArgumentException e) {
            this.puts("Invalid container ID: " + containerid);
            return;
        }
        UserGroupInformation callerUGI = this.getCallerUGI();
        ContainerReport containerReport = null;
        try {
            final GetContainerReportRequest request = GetContainerReportRequest.newInstance(containerId);
            containerReport = callerUGI == null ? this.appBaseProt.getContainerReport(request).getContainerReport() : callerUGI.doAs(new PrivilegedExceptionAction<ContainerReport>(){

                @Override
                public ContainerReport run() throws Exception {
                    return ContainerBlock.this.appBaseProt.getContainerReport(request).getContainerReport();
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the container " + containerid + ".";
            LOG.error((Object)message, (Throwable)e);
            ((HamletImpl.EImp)((Object)((Hamlet.P)html.p())._(new Object[]{message})))._();
            return;
        }
        if (containerReport == null) {
            this.puts("Container not found: " + containerid);
            return;
        }
        ContainerInfo container = new ContainerInfo(containerReport);
        this.setTitle(StringHelper.join("Container ", containerid));
        this.info("Container Overview")._("Container State:", container.getContainerState() == null ? "N/A" : container.getContainerState())._("Exit Status:", container.getContainerExitStatus())._("Node:", container.getNodeHttpAddress() == null ? "#" : container.getNodeHttpAddress(), container.getNodeHttpAddress() == null ? "N/A" : container.getNodeHttpAddress())._("Priority:", container.getPriority())._("Started:", Times.format(container.getStartedTime()))._("Elapsed:", StringUtils.formatTime(Times.elapsed(container.getStartedTime(), container.getFinishedTime())))._("Resource:", container.getAllocatedMB() + " Memory, " + container.getAllocatedVCores() + " VCores")._("Logs:", container.getLogUrl() == null ? "#" : container.getLogUrl(), container.getLogUrl() == null ? "N/A" : "Logs")._("Diagnostics:", container.getDiagnosticsInfo() == null ? "" : container.getDiagnosticsInfo());
        html._(InfoBlock.class);
    }
}

