/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class ClientScanner
extends AbstractClientScanner {
    private static final Log LOG = LogFactory.getLog(ClientScanner.class);
    protected final Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected ScannerCallableWithReplicas callable = null;
    protected final LinkedList<Result> cache = new LinkedList();
    private final ScanResultCache scanResultCache;
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final ClusterConnection connection;
    private final TableName tableName;
    protected final int scannerTimeout;
    protected boolean scanMetricsPublished = false;
    protected RpcRetryingCaller<Result[]> caller;
    protected RpcControllerFactory rpcControllerFactory;
    protected Configuration conf;
    protected final int primaryOperationTimeout;
    private int retries;
    protected final ExecutorService pool;

    public ClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary(scan.getStartRow())));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.pool = pool;
        this.primaryOperationTimeout = primaryOperationTimeout;
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.scannerTimeout = HBaseConfiguration.getInt(conf, "hbase.client.scanner.timeout.period", "hbase.regionserver.lease.period", 60000);
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.caller = rpcFactory.newCaller();
        this.rpcControllerFactory = controllerFactory;
        this.conf = conf;
        this.scanResultCache = ConnectionUtils.createScanResultCache(scan);
    }

    protected ClusterConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    protected byte[] getTableName() {
        return this.tableName.getName();
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected int getScannerTimeout() {
        return this.scannerTimeout;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    protected int getPrimaryOperationTimeout() {
        return this.primaryOperationTimeout;
    }

    protected int getCaching() {
        return this.caching;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    @VisibleForTesting
    protected long getMaxResultSize() {
        return this.maxScannerResultSize;
    }

    private void closeScanner() throws IOException {
        if (this.callable != null) {
            this.callable.setClose();
            this.call(this.callable, this.caller, this.scannerTimeout, false);
            this.callable = null;
        }
    }

    protected abstract boolean setNewStartKey();

    protected abstract ScannerCallable createScannerCallable();

    @VisibleForTesting
    protected boolean moveToNextRegion() {
        block7: {
            try {
                this.closeScanner();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)("close scanner for " + this.currentRegion + " failed"), (Throwable)e);
            }
        }
        if (this.currentRegion != null) {
            if (!this.setNewStartKey()) {
                return false;
            }
            this.scan.resetMvccReadPoint();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Finished " + this.currentRegion));
            }
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(this.scan.getStartRow()) + "', " + (this.scan.includeStartRow() ? "inclusive" : "exclusive")));
        }
        this.currentRegion = null;
        this.callable = new ScannerCallableWithReplicas(this.getTable(), this.getConnection(), this.createScannerCallable(), this.pool, this.primaryOperationTimeout, this.scan, this.getRetries(), this.scannerTimeout, this.caching, this.conf, this.caller);
        this.callable.setCaching(this.caching);
        if (this.scanMetrics != null) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @VisibleForTesting
    boolean isAnyRPCcancelled() {
        return this.callable.isAnyRPCcancelled();
    }

    private Result[] call(ScannerCallableWithReplicas callable, RpcRetryingCaller<Result[]> caller, int scannerTimeout, boolean updateCurrentRegion) throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        Result[] rrs = caller.callWithoutRetries(callable, scannerTimeout);
        if (this.currentRegion == null && updateCurrentRegion) {
            this.currentRegion = callable.getHRegionInfo();
        }
        return rrs;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        this.scan.setAttribute("scan.attributes.metrics.data", ProtobufUtil.toScanMetrics(this.scanMetrics, false).toByteArray());
        this.scanMetricsPublished = true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @VisibleForTesting
    public int getCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    private boolean scanExhausted(Result[] values) {
        return this.callable.moreResultsForScan() == ScannerCallable.MoreResults.NO;
    }

    private boolean regionExhausted(Result[] values) {
        return values.length == 0 && !this.callable.isHeartbeatMessage() || this.callable.moreResultsInRegion() == ScannerCallable.MoreResults.NO;
    }

    private void closeScannerIfExhausted(boolean exhausted) throws IOException {
        if (exhausted) {
            this.closeScanner();
        }
    }

    private void handleScanError(DoNotRetryIOException e, MutableBoolean retryAfterOutOfOrderException, int retriesLeft) throws DoNotRetryIOException {
        this.scanResultCache.clear();
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException || e instanceof UnknownScannerException || e instanceof ScannerResetException) {
            if (retriesLeft <= 0) {
                throw e;
            }
        } else {
            throw e;
        }
        if (this.lastResult != null) {
            this.scan.withStartRow(this.lastResult.getRow(), this.lastResult.mayHaveMoreCellsInRow());
        }
        if (e instanceof OutOfOrderScannerNextException) {
            if (retryAfterOutOfOrderException.isTrue()) {
                retryAfterOutOfOrderException.setValue(false);
            } else {
                throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", e);
            }
        }
        this.currentRegion = null;
        this.callable = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadCache() throws IOException {
        if (this.closed) {
            return;
        }
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        if (this.callable == null && !this.moveToNextRegion()) {
            return;
        }
        MutableBoolean retryAfterOutOfOrderException = new MutableBoolean(true);
        int retriesLeft = this.getRetries();
        while (true) {
            Result[] values;
            try {
                values = this.call(this.callable, this.caller, this.scannerTimeout, true);
                if (this.callable.switchedToADifferentReplica()) {
                    this.scanResultCache.clear();
                    this.currentRegion = this.callable.getHRegionInfo();
                }
                retryAfterOutOfOrderException.setValue(true);
            }
            catch (DoNotRetryIOException e) {
                this.handleScanError(e, retryAfterOutOfOrderException, retriesLeft--);
                if (this.moveToNextRegion()) continue;
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            int numberOfCompleteRowsBefore = this.scanResultCache.numberOfCompleteRows();
            Result[] resultsToAddToCache = this.scanResultCache.addAndGet(values, this.callable.isHeartbeatMessage());
            int numberOfCompleteRows = this.scanResultCache.numberOfCompleteRows() - numberOfCompleteRowsBefore;
            if (resultsToAddToCache.length > 0) {
                for (Result rs : resultsToAddToCache) {
                    this.cache.add(rs);
                    for (Cell cell : rs.rawCells()) {
                        remainingResultSize -= CellUtil.estimatedHeapSizeOf(cell);
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            }
            if (this.scan.getLimit() > 0) {
                int newLimit = this.scan.getLimit() - numberOfCompleteRows;
                assert (newLimit >= 0);
                this.scan.setLimit(newLimit);
            }
            if (this.scanExhausted(values)) {
                this.closeScanner();
                this.closed = true;
                return;
            }
            boolean regionExhausted = this.regionExhausted(values);
            if (this.callable.isHeartbeatMessage() && !this.cache.isEmpty()) {
                if (!LOG.isTraceEnabled()) return;
                LOG.trace((Object)"Heartbeat message received and cache contains Results. Breaking out of scan loop");
                return;
            }
            if (this.cache.isEmpty() && !this.closed && this.scan.isNeedCursorResult()) {
                if (this.callable.isHeartbeatMessage() && this.callable.getCursor() != null) {
                    this.cache.add(Result.createCursorResult(this.callable.getCursor()));
                    return;
                }
                if (values.length > 0) {
                    this.cache.add(Result.createCursorResult(new Cursor(values[values.length - 1].getRow())));
                    return;
                }
            }
            if (countdown <= 0) {
                this.closeScannerIfExhausted(regionExhausted);
                return;
            }
            if (remainingResultSize <= 0L) {
                if (!this.cache.isEmpty()) {
                    this.closeScannerIfExhausted(regionExhausted);
                    return;
                }
                remainingResultSize = this.maxScannerResultSize;
            }
            if (regionExhausted && !this.moveToNextRegion()) return;
        }
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.call(this.callable, this.caller, this.scannerTimeout, false);
            }
            catch (UnknownScannerException unknownScannerException) {
            }
            catch (IOException e) {
                LOG.warn((Object)("scanner failed to close. Exception follows: " + e));
            }
            this.callable = null;
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renewLease() {
        if (this.callable != null) {
            this.callable.setRenew(true);
            try {
                this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.callable.setRenew(false);
            }
            return true;
        }
        return false;
    }
}

