/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.generated.master;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.HttpJspBase;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.JspSourceDependent;
import org.apache.hadoop.hbase.shaded.org.apache.jasper.runtime.ResourceInjector;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.util.StringUtils;

public final class table_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    @Override
    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        table_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html;charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            HMaster master = (HMaster)this.getServletContext().getAttribute("master");
            Configuration conf = master.getConfiguration();
            MetaTableLocator metaTableLocator = new MetaTableLocator();
            String fqtn = request.getParameter("name");
            String escaped_fqtn = StringEscapeUtils.escapeHtml(fqtn);
            String sortKey = request.getParameter("sort");
            String reverse = request.getParameter("reverse");
            final boolean reverseOrder = reverse == null || !reverse.equals("false");
            String showWholeKey = request.getParameter("showwhole");
            boolean showWhole = showWholeKey != null && showWholeKey.equals("true");
            HTable table = null;
            boolean withReplica = false;
            ServerName rl = metaTableLocator.getMetaRegionLocation(master.getZooKeeper());
            boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
            boolean readOnly = conf.getBoolean("hbase.master.ui.readonly", false);
            int numMetaReplicas = conf.getInt("hbase.meta.replica.count", 1);
            Map<String, Integer> frags = null;
            if (showFragmentation) {
                frags = FSUtils.getTableFragmentation(master);
            }
            String action = request.getParameter("action");
            String key = request.getParameter("key");
            String left = request.getParameter("left");
            String right = request.getParameter("right");
            long totalStoreFileSizeMB = 0L;
            String numRegionsParam = request.getParameter("numRegions");
            int numRegionsToRender = 10000;
            if (numRegionsParam != null) {
                if (numRegionsParam.equals("all")) {
                    numRegionsToRender = -1;
                } else {
                    try {
                        numRegionsToRender = Integer.parseInt(numRegionsParam);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            int numRegions = 0;
            out.write("\n<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n  <head>\n    <meta charset=\"utf-8\">\n    ");
            if (!readOnly && action != null) {
                out.write("\n        <title>HBase Master: ");
                out.print(StringEscapeUtils.escapeHtml(master.getServerName().toString()));
                out.write("</title>\n    ");
            } else {
                out.write("\n        <title>Table: ");
                out.print(escaped_fqtn);
                out.write("</title>\n    ");
            }
            out.write("\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n\n\n      <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n      <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n      ");
            if (!readOnly && action != null || fqtn == null) {
                out.write("\n\t  <script type=\"text/javascript\">\n      <!--\n\t\t  setTimeout(\"history.back()\",5000);\n\t  -->\n\t  </script>\n      ");
            } else {
                out.write("\n      <!--[if lt IE 9]>\n          <script src=\"/static/js/html5shiv.js\"></script>\n      <![endif]-->\n      ");
            }
            out.write("\n</head>\n<body>\n<div class=\"navbar  navbar-fixed-top navbar-default\">\n    <div class=\"container-fluid\">\n        <div class=\"navbar-header\">\n            <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n                <span class=\"icon-bar\"></span>\n            </button>\n            <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n        </div>\n        <div class=\"collapse navbar-collapse\">\n            <ul class=\"nav navbar-nav\">\n                <li><a href=\"/master-status\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/procedures.jsp\">Procedures</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n");
            out.write("                ");
            if (HBaseConfiguration.isShowConfInServlet()) {
                out.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
            }
            out.write("\n            </ul>\n        </div><!--/.nav-collapse -->\n    </div>\n</div>\n");
            if (fqtn != null) {
                String tableHeader;
                table = new HTable(conf, fqtn);
                if (table.getTableDescriptor().getRegionReplication() > 1) {
                    tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th>Name</th><th>Region Server</th><th>ReadRequests</th><th>WriteRequests</th><th>StorefileSize</th><th>Num.Storefiles</th><th>MemSize</th><th>Locality</th><th>Start Key</th><th>End Key</th><th>ReplicaID</th></tr>";
                    withReplica = true;
                } else {
                    tableHeader = "<h2>Table Regions</h2><table class=\"table table-striped\" style=\"table-layout: fixed; word-wrap: break-word;\"><tr><th>Name</th><th>Region Server</th><th>ReadRequests</th><th>WriteRequests</th><th>StorefileSize</th><th>Num.Storefiles</th><th>MemSize</th><th>Locality</th><th>Start Key</th><th>End Key</th></tr>";
                }
                if (!readOnly && action != null) {
                    out.write("\n<div class=\"container-fluid content\">\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Table action request accepted</h1>\n            </div>\n        </div>\n<p><hr><p>\n");
                    try (Admin admin = master.getConnection().getAdmin();){
                        if (action.equals("split")) {
                            if (key != null && key.length() > 0) {
                                admin.splitRegion(Bytes.toBytes(key));
                            } else {
                                admin.split(TableName.valueOf(fqtn));
                            }
                            out.write(" Split request accepted. ");
                        } else if (action.equals("compact")) {
                            if (key != null && key.length() > 0) {
                                admin.compactRegion(Bytes.toBytes(key));
                            } else {
                                admin.compact(TableName.valueOf(fqtn));
                            }
                            out.write(" Compact request accepted. ");
                        } else if (action.equals("merge")) {
                            if (left != null && left.length() > 0 && right != null && right.length() > 0) {
                                admin.mergeRegions(Bytes.toBytesBinary(left), Bytes.toBytesBinary(right), false);
                            }
                            out.write(" Merge request accepted. ");
                        }
                    }
                    out.write("\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
                } else {
                    out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table <small>");
                    out.print(escaped_fqtn);
                    out.write("</small></h1>\n        </div>\n    </div>\n    <div class=\"row\">\n");
                    if (fqtn.equals(TableName.META_TABLE_NAME.getNameAsString())) {
                        out.write(10);
                        out.print(tableHeader);
                        out.write(10);
                        for (int j = 0; j < numMetaReplicas; ++j) {
                            HRegionInfo meta = RegionReplicaUtil.getRegionInfoForReplica(HRegionInfo.FIRST_META_REGIONINFO, j);
                            ServerName metaLocation = metaTableLocator.waitMetaRegionLocation(master.getZooKeeper(), j, 1L);
                            for (int i = 0; i < 1; ++i) {
                                String url = "";
                                String readReq = "N/A";
                                String writeReq = "N/A";
                                String fileSize = "N/A";
                                String fileCount = "N/A";
                                String memSize = "N/A";
                                float locality = 0.0f;
                                if (metaLocation != null) {
                                    Map<byte[], RegionLoad> map;
                                    ServerLoad sl = master.getServerManager().getLoad(metaLocation);
                                    url = "//" + URLEncoder.encode(metaLocation.getHostname()) + ":" + master.getRegionServerInfoPort(metaLocation) + "/";
                                    if (sl != null && (map = sl.getRegionsLoad()).containsKey(meta.getRegionName())) {
                                        RegionLoad load = map.get(meta.getRegionName());
                                        readReq = String.format("%,1d", load.getReadRequestsCount());
                                        writeReq = String.format("%,1d", load.getWriteRequestsCount());
                                        fileSize = StringUtils.byteDesc((long)load.getStorefileSizeMB() * 1024L * 1024L);
                                        fileCount = String.format("%,1d", load.getStorefiles());
                                        memSize = StringUtils.byteDesc((long)load.getMemStoreSizeMB() * 1024L * 1024L);
                                        locality = load.getDataLocality();
                                    }
                                }
                                out.write("\n<tr>\n  ");
                                String metaLocationString = metaLocation != null ? StringEscapeUtils.escapeHtml(metaLocation.getHostname().toString()) + ":" + master.getRegionServerInfoPort(metaLocation) : "(null)";
                                out.write("\n  <td>");
                                out.print(StringEscapeUtils.escapeXml(meta.getRegionNameAsString()));
                                out.write("</td>\n    <td><a href=\"");
                                out.print(url);
                                out.write(34);
                                out.write(62);
                                out.print(metaLocationString);
                                out.write("</a></td>\n    <td>");
                                out.print(readReq);
                                out.write("</td>\n    <td>");
                                out.print(writeReq);
                                out.write("</td>\n    <td>");
                                out.print(fileSize);
                                out.write("</td>\n    <td>");
                                out.print(fileCount);
                                out.write("</td>\n    <td>");
                                out.print(memSize);
                                out.write("</td>\n    <td>");
                                out.print(locality);
                                out.write("</td>\n    <td>");
                                out.print(StringEscapeUtils.escapeXml(Bytes.toString(meta.getStartKey())));
                                out.write("</td>\n    <td>");
                                out.print(StringEscapeUtils.escapeXml(Bytes.toString(meta.getEndKey())));
                                out.write("</td>\n</tr>\n");
                            }
                            out.write(10);
                        }
                        out.write("\n</table>\n");
                    } else {
                        try (Admin admin = master.getConnection().getAdmin();){
                            out.write("\n<h2>Table Attributes</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Attribute Name</th>\n      <th>Value</th>\n      <th>Description</th>\n  </tr>\n  <tr>\n      <td>Enabled</td>\n      <td>");
                            out.print(admin.isTableEnabled(table.getName()));
                            out.write("</td>\n      <td>Is the table enabled</td>\n  </tr>\n  <tr>\n      <td>Compaction</td>\n      <td>\n");
                            try {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = admin.getCompactionState(table.getName());
                                out.write(10);
                                out.print((Object)compactionState);
                                out.write(10);
                            }
                            catch (Exception e) {
                                for (StackTraceElement element : e.getStackTrace()) {
                                    out.print(StringEscapeUtils.escapeHtml(element.toString()));
                                }
                                out.write(" Unknown ");
                            }
                            out.write("\n      </td>\n      <td>Is the table compacting</td>\n  </tr>\n");
                            if (showFragmentation) {
                                out.write("\n  <tr>\n      <td>Fragmentation</td>\n      <td>");
                                out.print(frags.get(fqtn) != null ? frags.get(fqtn) + "%" : "n/a");
                                out.write("</td>\n      <td>How fragmented is the table. After a major compaction it is 0%.</td>\n  </tr>\n");
                            }
                            out.write("\n</table>\n<h2>Table Schema</h2>\n<table class=\"table table-striped\">\n  <tr>\n      <th>Column Name</th>\n      <th></th>\n  </tr>\n  ");
                            Collection<HColumnDescriptor> families = table.getTableDescriptor().getFamilies();
                            for (HColumnDescriptor family : families) {
                                out.write("\n  <tr>\n    <td>");
                                out.print(StringEscapeUtils.escapeHtml(family.getNameAsString()));
                                out.write("</td>\n    <td>\n    <table class=\"table table-striped\">\n      <tr>\n       <th>Property</th>\n       <th>Value</th>       \n      </tr>\n    ");
                                Map<ImmutableBytesWritable, ImmutableBytesWritable> familyValues = family.getValues();
                                for (ImmutableBytesWritable familyKey : familyValues.keySet()) {
                                    ImmutableBytesWritable familyValue = familyValues.get(familyKey);
                                    out.write("\n      <tr>\n        <td>\n          ");
                                    out.print(StringEscapeUtils.escapeHtml(Bytes.toString(familyKey.get(), familyKey.getOffset(), familyKey.getLength())));
                                    out.write("\n\t\t</td>\n        <td>\n          ");
                                    out.print(StringEscapeUtils.escapeHtml(Bytes.toString(familyValue.get(), familyValue.getOffset(), familyValue.getLength())));
                                    out.write("\n        </td>\n      </tr>\n    ");
                                }
                                out.write("\n    </table>\n    </td>\n  </tr>\n  ");
                            }
                            out.write("\n</table>\n");
                            long totalReadReq = 0L;
                            long totalWriteReq = 0L;
                            long totalSize = 0L;
                            long totalStoreFileCount = 0L;
                            long totalMemSize = 0L;
                            String urlRegionServer = null;
                            TreeMap<ServerName, Integer> regDistribution = new TreeMap<ServerName, Integer>();
                            TreeMap<ServerName, Integer> primaryRegDistribution = new TreeMap<ServerName, Integer>();
                            LinkedHashMap<HRegionInfo, RegionLoad> regionsToLoad = new LinkedHashMap<HRegionInfo, RegionLoad>();
                            Map<HRegionInfo, ServerName> regions = table.getRegionLocations();
                            if (regions == null) {
                                regions = new HashMap();
                            }
                            for (Map.Entry hriEntry : regions.entrySet()) {
                                HRegionInfo regionInfo = (HRegionInfo)hriEntry.getKey();
                                ServerName serverName = (ServerName)hriEntry.getValue();
                                if (serverName != null) {
                                    ServerLoad sl = master.getServerManager().getLoad(serverName);
                                    if (sl != null) {
                                        Map<byte[], RegionLoad> map = sl.getRegionsLoad();
                                        RegionLoad regionload = map.get(regionInfo.getRegionName());
                                        regionsToLoad.put(regionInfo, regionload);
                                        if (regionload != null) {
                                            totalReadReq += regionload.getReadRequestsCount();
                                            totalWriteReq += regionload.getWriteRequestsCount();
                                            totalSize += (long)regionload.getStorefileSizeMB();
                                            totalStoreFileCount += (long)regionload.getStorefiles();
                                            totalMemSize += (long)regionload.getMemStoreSizeMB();
                                            totalStoreFileSizeMB += (long)regionload.getStorefileSizeMB();
                                            continue;
                                        }
                                        RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom(regionInfo.getRegionName())).build()).build());
                                        regionsToLoad.put(regionInfo, load0);
                                        continue;
                                    }
                                    RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom(regionInfo.getRegionName())).build()).build());
                                    regionsToLoad.put(regionInfo, load0);
                                    continue;
                                }
                                RegionLoad load0 = new RegionLoad(ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(HBaseProtos.RegionSpecifier.newBuilder().setValue(ByteString.copyFrom(regionInfo.getRegionName())).build()).build());
                                regionsToLoad.put(regionInfo, load0);
                            }
                            if (regions != null && regions.size() > 0) {
                                out.write("\n<h2>Table Regions</h2>\nSort As\n<select id=\"sel\" style=\"margin-right: 10px\">\n<option value=\"regionName\">RegionName</option>\n<option value=\"readrequest\">ReadRequest</option>\n<option value=\"writerequest\">WriteRequest</option>\n<option value=\"size\">StorefileSize</option>\n<option value=\"filecount\">Num.Storefiles</option>\n<option value=\"memstore\">MemstoreSize</option>\n<option value=\"locality\">Locality</option>\n</select>\nAscending<input type=\"checkbox\" id=\"ascending\" value=\"Ascending\" style=\"margin-right:10px\">\nShowDetailName&Start/End Key<input type=\"checkbox\" id=\"showWhole\" style=\"margin-right:10px\">\n<input type=\"button\" id=\"submit\" value=\"Reorder\" onClick=\"reloadAsSort()\" style=\"font-size: 12pt; width: 5em; margin-bottom: 5px\" class=\"btn\">\n<p>\n\n<table class=\"table table-striped\">\n<tr>\n<th>Name(");
                                out.print(String.format("%,1d", regions.size()));
                                out.write(")</th>\n<th>Region Server</th>\n<th>ReadRequests<br>(");
                                out.print(String.format("%,1d", totalReadReq));
                                out.write(")</th>\n<th>WriteRequests<br>(");
                                out.print(String.format("%,1d", totalWriteReq));
                                out.write(")</th>\n<th>StorefileSize<br>(");
                                out.print(StringUtils.byteDesc(totalSize * 1024L * 1024L));
                                out.write(")</th>\n<th>Num.Storefiles<br>(");
                                out.print(String.format("%,1d", totalStoreFileCount));
                                out.write(")</th>\n<th>MemSize<br>(");
                                out.print(StringUtils.byteDesc(totalMemSize * 1024L * 1024L));
                                out.write(")</th>\n<th>Locality</th>\n<th>Start Key</th>\n<th>End Key</th>\n");
                                if (withReplica) {
                                    out.write("\n<th>ReplicaID</th>\n");
                                }
                                out.write("\n</tr>\n\n");
                                ArrayList entryList = new ArrayList(regionsToLoad.entrySet());
                                if (sortKey != null) {
                                    if (sortKey.equals("readrequest")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getReadRequestsCount() < entry2.getValue().getReadRequestsCount()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getReadRequestsCount() > entry2.getValue().getReadRequestsCount()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    } else if (sortKey.equals("writerequest")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getWriteRequestsCount() < entry2.getValue().getWriteRequestsCount()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getWriteRequestsCount() > entry2.getValue().getWriteRequestsCount()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    } else if (sortKey.equals("size")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getStorefileSizeMB() < entry2.getValue().getStorefileSizeMB()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getStorefileSizeMB() > entry2.getValue().getStorefileSizeMB()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    } else if (sortKey.equals("filecount")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getStorefiles() < entry2.getValue().getStorefiles()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getStorefiles() > entry2.getValue().getStorefiles()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    } else if (sortKey.equals("memstore")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getMemStoreSizeMB() < entry2.getValue().getMemStoreSizeMB()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getMemStoreSizeMB() > entry2.getValue().getMemStoreSizeMB()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    } else if (sortKey.equals("locality")) {
                                        Collections.sort(entryList, new Comparator<Map.Entry<HRegionInfo, RegionLoad>>(){

                                            @Override
                                            public int compare(Map.Entry<HRegionInfo, RegionLoad> entry1, Map.Entry<HRegionInfo, RegionLoad> entry2) {
                                                if (entry1 == null || entry1.getValue() == null) {
                                                    return -1;
                                                }
                                                if (entry2 == null || entry2.getValue() == null) {
                                                    return 1;
                                                }
                                                int result = 0;
                                                if (entry1.getValue().getDataLocality() < entry2.getValue().getDataLocality()) {
                                                    result = -1;
                                                } else if (entry1.getValue().getDataLocality() > entry2.getValue().getDataLocality()) {
                                                    result = 1;
                                                }
                                                if (reverseOrder) {
                                                    result = -1 * result;
                                                }
                                                return result;
                                            }
                                        });
                                    }
                                }
                                numRegions = regions.size();
                                int numRegionsRendered = 0;
                                if (numRegionsToRender < 0) {
                                    numRegionsToRender = numRegions;
                                }
                                for (Map.Entry entry : entryList) {
                                    HRegionInfo regionInfo = (HRegionInfo)entry.getKey();
                                    ServerName addr = regions.get(regionInfo);
                                    RegionLoad load = (RegionLoad)entry.getValue();
                                    String readReq = "N/A";
                                    String writeReq = "N/A";
                                    String regionSize = "N/A";
                                    String fileCount = "N/A";
                                    String memSize = "N/A";
                                    float locality = 0.0f;
                                    if (load != null) {
                                        readReq = String.format("%,1d", load.getReadRequestsCount());
                                        writeReq = String.format("%,1d", load.getWriteRequestsCount());
                                        regionSize = StringUtils.byteDesc((long)load.getStorefileSizeMB() * 1024L * 1024L);
                                        fileCount = String.format("%,1d", load.getStorefiles());
                                        memSize = StringUtils.byteDesc((long)load.getMemStoreSizeMB() * 1024L * 1024L);
                                        locality = load.getDataLocality();
                                    }
                                    if (addr != null) {
                                        ServerLoad sl = master.getServerManager().getLoad(addr);
                                        urlRegionServer = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                        if (sl != null) {
                                            Integer i = (Integer)regDistribution.get(addr);
                                            if (null == i) {
                                                i = 0;
                                            }
                                            regDistribution.put(addr, i + 1);
                                            if (withReplica && RegionReplicaUtil.isDefaultReplica(regionInfo.getReplicaId())) {
                                                i = (Integer)primaryRegDistribution.get(addr);
                                                if (null == i) {
                                                    i = 0;
                                                }
                                                primaryRegDistribution.put(addr, i + 1);
                                            }
                                        }
                                    }
                                    if (numRegionsRendered < numRegionsToRender) {
                                        ++numRegionsRendered;
                                        out.write("\n<tr>\n  <td>");
                                        out.print(StringEscapeUtils.escapeXml(showWhole ? Bytes.toStringBinary(regionInfo.getRegionName()) : regionInfo.getEncodedName()));
                                        out.write("</td>\n  ");
                                        if (urlRegionServer != null) {
                                            out.write("\n  <td>\n     <a href=\"");
                                            out.print(urlRegionServer);
                                            out.write(34);
                                            out.write(62);
                                            out.print(StringEscapeUtils.escapeHtml(addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                            out.write("</a>\n  </td>\n  ");
                                        } else {
                                            out.write("\n  <td class=\"undeployed-region\">not deployed</td>\n  ");
                                        }
                                        out.write("\n  <td>");
                                        out.print(readReq);
                                        out.write("</td>\n  <td>");
                                        out.print(writeReq);
                                        out.write("</td>\n  <td>");
                                        out.print(regionSize);
                                        out.write("</td>\n  <td>");
                                        out.print(fileCount);
                                        out.write("</td>\n  <td>");
                                        out.print(memSize);
                                        out.write("</td>\n  <td>");
                                        out.print(locality);
                                        out.write("</td>\n  <td>");
                                        out.print(StringEscapeUtils.escapeXml(showWhole ? Bytes.toStringBinary(regionInfo.getStartKey()) : "-"));
                                        out.write("</td>\n  <td>");
                                        out.print(StringEscapeUtils.escapeXml(showWhole ? Bytes.toStringBinary(regionInfo.getEndKey()) : "-"));
                                        out.write("</td>\n  ");
                                        if (withReplica) {
                                            out.write("\n  <td>");
                                            out.print(regionInfo.getReplicaId());
                                            out.write("</td>\n  ");
                                        }
                                        out.write("\n</tr>\n");
                                    }
                                    out.write(10);
                                }
                                out.write("\n</table>\n");
                                if (numRegions > numRegionsRendered) {
                                    String allRegionsUrl = "?name=" + URLEncoder.encode(fqtn, "UTF-8") + "&numRegions=all";
                                    out.write("\n  <p>This table has <b>");
                                    out.print(numRegions);
                                    out.write("</b> regions in total, in order to improve the page load time,\n     only <b>");
                                    out.print(numRegionsRendered);
                                    out.write("</b> regions are displayed here, <a href=\"");
                                    out.print(allRegionsUrl);
                                    out.write("\">click\n     here</a> to see all regions.</p>\n");
                                }
                                out.write("\n<h2>Regions by Region Server</h2>\n");
                                if (withReplica) {
                                    out.write("\n<table class=\"table table-striped\"><tr><th>Region Server</th><th>Region Count</th><th>Primary Region Count</th></tr>\n");
                                } else {
                                    out.write("\n<table class=\"table table-striped\"><tr><th>Region Server</th><th>Region Count</th></tr>\n");
                                }
                                out.write(10);
                                for (Map.Entry entry : regDistribution.entrySet()) {
                                    ServerName addr = (ServerName)entry.getKey();
                                    String url = "//" + URLEncoder.encode(addr.getHostname()) + ":" + master.getRegionServerInfoPort(addr) + "/";
                                    out.write("\n<tr>\n  <td><a href=\"");
                                    out.print(url);
                                    out.write(34);
                                    out.write(62);
                                    out.print(StringEscapeUtils.escapeHtml(addr.getHostname().toString()) + ":" + master.getRegionServerInfoPort(addr));
                                    out.write("</a></td>\n  <td>");
                                    out.print(entry.getValue());
                                    out.write("</td>\n");
                                    if (withReplica) {
                                        out.write("\n  <td>");
                                        out.print(primaryRegDistribution.get(addr));
                                        out.write("</td>\n");
                                    }
                                    out.write("\n</tr>\n");
                                }
                                out.write("\n</table>\n");
                            }
                        }
                    }
                    out.write("\n\n<h2>Table Stats</h2>\n<table class=\"table table-striped\">\n  <tr>\n    <th>Name</th>\n    <th>Value</th>\n    <th>Description</th>\n  </tr>\n  <tr>\n    <td>Size</td>\n    <td>");
                    out.print(StringUtils.TraditionalBinaryPrefix.long2String(totalStoreFileSizeMB * 1024L * 1024L, "B", 2));
                    out.write("</td>\n    <td>Total size of store files (in bytes)</td>\n  </tr>\n</table>\n\n");
                    if (!readOnly) {
                        out.write("\n<p><hr/></p>\nActions:\n<p>\n<center>\n<table class=\"table\" width=\"95%\" >\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"compact\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Compact\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a compaction of all\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key.</td>\n  </form>\n</tr>\n<tr><td style=\"border-style: none\" colspan=\"4\">&nbsp;</td></tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"split\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Split\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (optional):<input type=\"text\" name=\"key\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will force a split of all eligible\n  regions of the table, or, if a key is supplied, only the region containing the\n  given key. An eligible region is one that does not contain any references to\n  other regions. Split requests for noneligible regions will be ignored.</td>\n  </form>\n</tr>\n<tr>\n  <form method=\"get\">\n  <input type=\"hidden\" name=\"action\" value=\"merge\">\n  <input type=\"hidden\" name=\"name\" value=\"");
                        out.print(escaped_fqtn);
                        out.write("\">\n  <td style=\"border-style: none; text-align: center\">\n      <input style=\"font-size: 12pt; width: 10em\" type=\"submit\" value=\"Merge\" class=\"btn\"></td>\n  <td style=\"border-style: none\" width=\"5%\">&nbsp;</td>\n  <td style=\"border-style: none\">Region Key (Required):<input type=\"text\" name=\"left\" size=\"40\">\n  Region Key (Required) :<input type=\"text\" name=\"right\" size=\"40\"></td>\n  <td style=\"border-style: none\">This action will merge two\n  regions of the table, Merge requests for noneligible regions will be ignored.</td>\n  </form>\n</tr>\n</table>\n</center>\n</p>\n");
                    }
                    out.write("\n</div>\n</div>\n");
                }
            } else {
                out.write("\n<div class=\"container-fluid content\">\n    <div class=\"row inner_header\">\n        <div class=\"page-header\">\n            <h1>Table not ready</h1>\n        </div>\n    </div>\n<p><hr><p>\n<p>Go <a href=\"javascript:history.back()\">Back</a>, or wait for the redirect.\n</div>\n");
            }
            out.write("\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n\n</body>\n</html>\n\n<script>\nvar index=0;\nvar sortKeyValue='");
            out.print(StringEscapeUtils.escapeJavaScript(sortKey));
            out.write("';\nif(sortKeyValue==\"readrequest\")index=1;\nelse if(sortKeyValue==\"writerequest\")index=2;\nelse if(sortKeyValue==\"size\")index=3;\nelse if(sortKeyValue==\"filecount\")index=4;\nelse if(sortKeyValue==\"memstore\")index=5;\nelse if(sortKeyValue==\"locality\")index=6;\ndocument.getElementById(\"sel\").selectedIndex=index;\n\n");
            out.write("\nvar reverse='");
            out.print(reverseOrder);
            out.write("';\nif(reverse=='false')document.getElementById(\"ascending\").checked=true;\n\n");
            out.write("\nvar showWhole='");
            out.print(showWhole);
            out.write("';\nif(showWhole=='true')document.getElementById(\"showWhole\").checked=true;\n\nfunction reloadAsSort(){\n  var url=\"?name=\"+'");
            out.print(fqtn != null ? URLEncoder.encode(fqtn) : "");
            out.write("';\n  if(document.getElementById(\"sel\").selectedIndex>0){\n    url=url+\"&sort=\"+document.getElementById(\"sel\").value;\n  }\n  if(document.getElementById(\"ascending\").checked){\n    url=url+\"&reverse=false\";\n  }\n  if(document.getElementById(\"showWhole\").checked){\n    url=url+\"&showwhole=true\";\n  }\n  location.href=url;\n}\n</script>\n");
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

