/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.http.HttpConfig;
import org.apache.hadoop.hbase.http.HttpServer;

@InterfaceAudience.Private
public class InfoServer {
    private static final String HBASE_APP_DIR = "hbase-webapps";
    private final HttpServer httpServer;

    public InfoServer(String name, String bindAddress, int port, boolean findPort, Configuration c) throws IOException {
        HttpConfig httpConfig = new HttpConfig(c);
        HttpServer.Builder builder = new HttpServer.Builder();
        builder.setName(name).addEndpoint(URI.create(httpConfig.getSchemePrefix() + bindAddress + ":" + port)).setAppDir(HBASE_APP_DIR).setFindPort(findPort).setConf(c);
        String logDir = System.getProperty("hbase.log.dir");
        if (logDir != null) {
            builder.setLogDir(logDir);
        }
        if (httpConfig.isSecure()) {
            builder.keyPassword(HBaseConfiguration.getPassword(c, "ssl.server.keystore.keypassword", null)).keyStore(c.get("ssl.server.keystore.location"), HBaseConfiguration.getPassword(c, "ssl.server.keystore.password", null), c.get("ssl.server.keystore.type", "jks")).trustStore(c.get("ssl.server.truststore.location"), HBaseConfiguration.getPassword(c, "ssl.server.truststore.password", null), c.get("ssl.server.truststore.type", "jks"));
        }
        if ("kerberos".equalsIgnoreCase(c.get("hbase.security.authentication.ui", null))) {
            builder.setUsernameConfKey("hbase.security.authentication.spnego.kerberos.principal").setKeytabConfKey("hbase.security.authentication.spnego.kerberos.keytab").setKerberosNameRulesKey("hbase.security.authentication.spnego.kerberos.name.rules").setSignatureSecretFileKey("hbase.security.authentication.signature.secret.file").setSecurityEnabled(true);
        }
        this.httpServer = builder.build();
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.httpServer.addServlet(name, pathSpec, clazz);
    }

    public void setAttribute(String name, Object value) {
        this.httpServer.setAttribute(name, value);
    }

    public void start() throws IOException {
        this.httpServer.start();
    }

    @Deprecated
    public int getPort() {
        return this.httpServer.getPort();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }
}

