/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"ageHistogram", "snapshot"})
public class AgeSnapshot {
    private final FastLongHistogram ageHistogram;
    private final long[] quantiles;

    AgeSnapshot(FastLongHistogram ageHistogram) {
        this.ageHistogram = ageHistogram;
        this.quantiles = ageHistogram.getQuantiles(new double[]{0.75, 0.95, 0.98, 0.99, 0.999});
    }

    public double get75thPercentile() {
        return this.quantiles[0];
    }

    public double get95thPercentile() {
        return this.quantiles[1];
    }

    public double get98thPercentile() {
        return this.quantiles[2];
    }

    public double get99thPercentile() {
        return this.quantiles[3];
    }

    public double get999thPercentile() {
        return this.quantiles[4];
    }

    public double getMean() {
        return this.ageHistogram.getMean();
    }

    public double getMax() {
        return this.ageHistogram.getMax();
    }

    public double getMin() {
        return this.ageHistogram.getMin();
    }
}

