/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IdentityTableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Export {
    private static final Log LOG = LogFactory.getLog(Export.class);
    static final String NAME = "export";
    static final String RAW_SCAN = "hbase.mapreduce.include.deleted.rows";
    static final String EXPORT_BATCHING = "hbase.export.scanner.batch";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        Path outputDir = new Path(args[1]);
        Job job = new Job(conf, "export_" + tableName);
        job.setJobName("export_" + tableName);
        job.setJarByClass(Export.class);
        Scan s = Export.getConfiguredScanForJob(conf, args);
        IdentityTableMapper.initJob(tableName, s, IdentityTableMapper.class, job);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        FileOutputFormat.setOutputPath(job, outputDir);
        return job;
    }

    private static Scan getConfiguredScanForJob(Configuration conf, String[] args) throws IOException {
        int batching;
        Filter exportFilter;
        boolean raw;
        Scan s = new Scan();
        int versions = args.length > 2 ? Integer.parseInt(args[2]) : 1;
        s.setMaxVersions(versions);
        long startTime = args.length > 3 ? Long.parseLong(args[3]) : 0L;
        long endTime = args.length > 4 ? Long.parseLong(args[4]) : Long.MAX_VALUE;
        s.setTimeRange(startTime, endTime);
        s.setCacheBlocks(false);
        if (conf.get("hbase.mapreduce.scan.row.start") != null) {
            s.setStartRow(Bytes.toBytesBinary(conf.get("hbase.mapreduce.scan.row.start")));
        }
        if (conf.get("hbase.mapreduce.scan.row.stop") != null) {
            s.setStopRow(Bytes.toBytesBinary(conf.get("hbase.mapreduce.scan.row.stop")));
        }
        if (raw = Boolean.parseBoolean(conf.get(RAW_SCAN))) {
            s.setRaw(raw);
        }
        if (conf.get("hbase.mapreduce.scan.column.family") != null) {
            s.addFamily(Bytes.toBytes(conf.get("hbase.mapreduce.scan.column.family")));
        }
        if ((exportFilter = Export.getExportFilter(args)) != null) {
            LOG.info((Object)"Setting Scan Filter for Export.");
            s.setFilter(exportFilter);
        }
        if ((batching = conf.getInt(EXPORT_BATCHING, -1)) != -1) {
            try {
                s.setBatch(batching);
            }
            catch (IncompatibleFilterException e) {
                LOG.error((Object)"Batching could not be set", (Throwable)e);
            }
        }
        LOG.info((Object)("versions=" + versions + ", starttime=" + startTime + ", endtime=" + endTime + ", keepDeletedCells=" + raw));
        return s;
    }

    private static Filter getExportFilter(String[] args) {
        String filterCriteria;
        FilterBase exportFilter = null;
        String string = filterCriteria = args.length > 5 ? args[5] : null;
        if (filterCriteria == null) {
            return null;
        }
        if (filterCriteria.startsWith("^")) {
            String regexPattern = filterCriteria.substring(1, filterCriteria.length());
            exportFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(regexPattern));
        } else {
            exportFilter = new PrefixFilter(Bytes.toBytesBinary(filterCriteria));
        }
        return exportFilter;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: Export [-D <property=value>]* <tablename> <outputdir> [<versions> [<starttime> [<endtime>]] [^[regex pattern] or [Prefix] to filter]]\n");
        System.err.println("  Note: -D properties will be applied to the conf used. ");
        System.err.println("  For example: ");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress=true");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress.codec=org.apache.hadoop.io.compress.GzipCodec");
        System.err.println("   -D mapreduce.output.fileoutputformat.compress.type=BLOCK");
        System.err.println("  Additionally, the following SCAN properties can be specified");
        System.err.println("  to control/limit what is exported..");
        System.err.println("   -D hbase.mapreduce.scan.column.family=<familyName>");
        System.err.println("   -D hbase.mapreduce.include.deleted.rows=true");
        System.err.println("   -D hbase.mapreduce.scan.row.start=<ROWSTART>");
        System.err.println("   -D hbase.mapreduce.scan.row.stop=<ROWSTOP>");
        System.err.println("For performance consider the following properties:\n   -Dhbase.client.scanner.caching=100\n   -Dmapreduce.map.speculative=false\n   -Dmapreduce.reduce.speculative=false");
        System.err.println("For tables with very wide rows consider setting the batch size as below:\n   -Dhbase.export.scanner.batch=10");
    }

    public static void main(String[] args) throws Exception {
        Job job;
        Configuration conf = HBaseConfiguration.create();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        if (otherArgs.length < 2) {
            Export.usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        System.exit((job = Export.createSubmittableJob(conf, otherArgs)).waitForCompletion(true) ? 0 : 1);
    }
}

