/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.GnuParser;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.hbase.shaded.org.apache.commons.cli.ParseException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ServerCommandLine;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

@InterfaceAudience.Private
public class HMasterCommandLine
extends ServerCommandLine {
    private static final Log LOG = LogFactory.getLog(HMasterCommandLine.class);
    private static final String USAGE = "Usage: Master [opts] start|stop|clear\n start  Start Master. If local mode, start Master and RegionServer in same JVM\n stop   Start cluster shutdown; Master signals RegionServer shutdown\n clear  Delete the master znode in ZooKeeper after a master crashes\n  where [opts] are:\n   --minRegionServers=<servers>   Minimum RegionServers needed to host user tables.\n   --localRegionServers=<servers> RegionServers to start in master process when in standalone mode.\n   --masters=<servers>            Masters to start in this process.\n   --backup                       Master should start in backup mode";
    private final Class<? extends HMaster> masterClass;

    public HMasterCommandLine(Class<? extends HMaster> masterClass) {
        this.masterClass = masterClass;
    }

    @Override
    protected String getUsage() {
        return USAGE;
    }

    @Override
    public int run(String[] args) throws Exception {
        List remainingArgs;
        String val;
        CommandLine cmd;
        Options opt = new Options();
        opt.addOption("localRegionServers", true, "RegionServers to start in master process when running standalone");
        opt.addOption("masters", true, "Masters to start in this process");
        opt.addOption("minRegionServers", true, "Minimum RegionServers needed to host user tables");
        opt.addOption("backup", false, "Do not try to become HMaster until the primary fails");
        try {
            cmd = new GnuParser().parse(opt, args);
        }
        catch (ParseException e) {
            LOG.error((Object)"Could not parse: ", (Throwable)e);
            this.usage(null);
            return 1;
        }
        if (cmd.hasOption("minRegionServers")) {
            val = cmd.getOptionValue("minRegionServers");
            this.getConf().setInt("hbase.regions.server.count.min", Integer.parseInt(val));
            LOG.debug((Object)("minRegionServers set to " + val));
        }
        if (cmd.hasOption("minServers")) {
            val = cmd.getOptionValue("minServers");
            this.getConf().setInt("hbase.regions.server.count.min", Integer.parseInt(val));
            LOG.debug((Object)("minServers set to " + val));
        }
        if (cmd.hasOption("backup")) {
            this.getConf().setBoolean("hbase.master.backup", true);
        }
        if (cmd.hasOption("localRegionServers")) {
            val = cmd.getOptionValue("localRegionServers");
            this.getConf().setInt("hbase.regionservers", Integer.parseInt(val));
            LOG.debug((Object)("localRegionServers set to " + val));
        }
        if (cmd.hasOption("masters")) {
            val = cmd.getOptionValue("masters");
            this.getConf().setInt("hbase.masters", Integer.parseInt(val));
            LOG.debug((Object)("masters set to " + val));
        }
        if ((remainingArgs = cmd.getArgList()).size() != 1) {
            this.usage(null);
            return 1;
        }
        String command = (String)remainingArgs.get(0);
        if ("start".equals(command)) {
            return this.startMaster();
        }
        if ("stop".equals(command)) {
            return this.stopMaster();
        }
        if ("clear".equals(command)) {
            return ZNodeClearer.clear(this.getConf()) ? 0 : 1;
        }
        this.usage("Invalid command: " + command);
        return 1;
    }

    private int startMaster() {
        Configuration conf = this.getConf();
        try {
            if (LocalHBaseCluster.isLocal(conf)) {
                DefaultMetricsSystem.setMiniClusterMode(true);
                MiniZooKeeperCluster zooKeeperCluster = new MiniZooKeeperCluster(conf);
                File zkDataPath = new File(conf.get("hbase.zookeeper.property.dataDir"));
                int zkClientPort = 0;
                String zkserver = conf.get("hbase.zookeeper.quorum");
                if (zkserver != null) {
                    String[] zkservers = zkserver.split(",");
                    if (zkservers.length > 1) {
                        String errorMsg = "Could not start ZK with " + zkservers.length + " ZK servers in local mode deployment. Aborting as clients (e.g. shell) will not " + "be able to find this ZK quorum.";
                        System.err.println(errorMsg);
                        throw new IOException(errorMsg);
                    }
                    String[] parts = zkservers[0].split(":");
                    if (parts.length == 2) {
                        zkClientPort = Integer.parseInt(parts[1]);
                    }
                }
                if (zkClientPort == 0 && (zkClientPort = conf.getInt("hbase.zookeeper.property.clientPort", 0)) == 0) {
                    throw new IOException("No config value for hbase.zookeeper.property.clientPort");
                }
                zooKeeperCluster.setDefaultClientPort(zkClientPort);
                int zkTickTime = conf.getInt("hbase.zookeeper.property.tickTime", 0);
                if (zkTickTime > 0) {
                    zooKeeperCluster.setTickTime(zkTickTime);
                }
                ZKUtil.loginServer(conf, "hbase.zookeeper.server.keytab.file", "hbase.zookeeper.server.kerberos.principal", null);
                int localZKClusterSessionTimeout = conf.getInt("zookeeper.session.timeout.localHBaseCluster", 10000);
                conf.setInt("zookeeper.session.timeout", localZKClusterSessionTimeout);
                LOG.info((Object)"Starting a zookeeper cluster");
                int clientPort = zooKeeperCluster.startup(zkDataPath);
                if (clientPort != zkClientPort) {
                    String errorMsg = "Could not start ZK at requested port of " + zkClientPort + ".  ZK was started at port: " + clientPort + ".  Aborting as clients (e.g. shell) will not be able to find " + "this ZK quorum.";
                    System.err.println(errorMsg);
                    throw new IOException(errorMsg);
                }
                conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
                int mastersCount = conf.getInt("hbase.masters", 1);
                int regionServersCount = conf.getInt("hbase.regionservers", 1);
                conf.setIfUnset("hbase.master.start.timeout.localHBaseCluster", "300000");
                LOG.info((Object)("Starting up instance of localHBaseCluster; master=" + mastersCount + ", regionserversCount=" + regionServersCount));
                LocalHBaseCluster cluster = new LocalHBaseCluster(conf, mastersCount, regionServersCount, LocalHMaster.class, HRegionServer.class);
                ((LocalHMaster)cluster.getMaster(0)).setZKCluster(zooKeeperCluster);
                cluster.startup();
                this.waitOnMasterThreads(cluster);
            } else {
                HMasterCommandLine.logProcessInfo(this.getConf());
                CoordinatedStateManager csm = CoordinatedStateManagerFactory.getCoordinatedStateManager(conf);
                HMaster master = HMaster.constructMaster(this.masterClass, conf, csm);
                if (master.isStopped()) {
                    LOG.info((Object)"Won't bring the Master up as a shutdown is requested");
                    return 1;
                }
                master.start();
                master.join();
                if (master.isAborted()) {
                    throw new RuntimeException("HMaster Aborted");
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Master exiting", t);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopMaster() {
        Admin adm = null;
        try {
            Configuration conf = this.getConf();
            conf.setInt("hbase.client.retries.number", 1);
            adm = new HBaseAdmin(this.getConf());
            adm.shutdown();
        }
        catch (MasterNotRunningException e) {
            LOG.error((Object)"Master not running");
            int n = 1;
            return n;
        }
        catch (ZooKeeperConnectionException e) {
            LOG.error((Object)"ZooKeeper not available");
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.error((Object)("Got IOException: " + e.getMessage()), (Throwable)e);
            int n = 1;
            return n;
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to stop master", t);
            int n = 1;
            return n;
        }
        finally {
            if (adm != null) {
                try {
                    adm.close();
                }
                catch (Throwable t) {
                    LOG.error((Object)"Failed to close Admin", t);
                    return 1;
                }
            }
        }
        return 0;
    }

    private void waitOnMasterThreads(LocalHBaseCluster cluster) throws InterruptedException {
        List<JVMClusterUtil.MasterThread> masters = cluster.getMasters();
        List<JVMClusterUtil.RegionServerThread> regionservers = cluster.getRegionServers();
        if (masters != null) {
            for (JVMClusterUtil.MasterThread t : masters) {
                t.join();
                if (!t.getMaster().isAborted()) continue;
                HMasterCommandLine.closeAllRegionServerThreads(regionservers);
                throw new RuntimeException("HMaster Aborted");
            }
        }
    }

    private static void closeAllRegionServerThreads(List<JVMClusterUtil.RegionServerThread> regionservers) {
        for (JVMClusterUtil.RegionServerThread t : regionservers) {
            t.getRegionServer().stop("HMaster Aborted; Bringing down regions servers");
        }
    }

    public static class LocalHMaster
    extends HMaster {
        private MiniZooKeeperCluster zkcluster = null;

        public LocalHMaster(Configuration conf, CoordinatedStateManager csm) throws IOException, KeeperException, InterruptedException {
            super(conf, csm);
        }

        @Override
        public void run() {
            super.run();
            if (this.zkcluster != null) {
                try {
                    this.zkcluster.shutdown();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        void setZKCluster(MiniZooKeeperCluster zkcluster) {
            this.zkcluster = zkcluster;
        }
    }
}

