/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryFactory;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.impl.MetricRegistryFactoryImpl;
import org.apache.hadoop.hbase.metrics.impl.RefCountingMap;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Optional;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Supplier;

@InterfaceAudience.Private
public class MetricRegistriesImpl
extends MetricRegistries {
    private final MetricRegistryFactory factory;
    private final RefCountingMap<MetricRegistryInfo, MetricRegistry> registries;

    public MetricRegistriesImpl() {
        this(new MetricRegistryFactoryImpl());
    }

    public MetricRegistriesImpl(MetricRegistryFactory factory) {
        this.factory = factory;
        this.registries = new RefCountingMap();
    }

    @Override
    public MetricRegistry create(final MetricRegistryInfo info) {
        return this.registries.put(info, new Supplier<MetricRegistry>(){

            @Override
            public MetricRegistry get() {
                return MetricRegistriesImpl.this.factory.create(info);
            }
        });
    }

    @Override
    public boolean remove(MetricRegistryInfo key) {
        return this.registries.remove(key) == null;
    }

    @Override
    public Optional<MetricRegistry> get(MetricRegistryInfo info) {
        return Optional.fromNullable(this.registries.get(info));
    }

    @Override
    public Collection<MetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    public void clear() {
        this.registries.clear();
    }

    @Override
    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }
}

