/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.SizedCellScanner;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public class ReplicationProtbufUtil {
    public static void replicateWALEntry(AdminProtos.AdminService.BlockingInterface admin, WAL.Entry[] entries, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir) throws IOException {
        Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> p = ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, replicationClusterId, sourceBaseNamespaceDir, sourceHFileArchiveDir);
        HBaseRpcControllerImpl controller = new HBaseRpcControllerImpl(p.getSecond());
        try {
            admin.replicateWALEntry(controller, p.getFirst());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getServiceException(se);
        }
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries) {
        return ReplicationProtbufUtil.buildReplicateWALEntryRequest(entries, null, null, null, null);
    }

    public static Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> buildReplicateWALEntryRequest(WAL.Entry[] entries, byte[] encodedRegionName, String replicationClusterId, Path sourceBaseNamespaceDir, Path sourceHFileArchiveDir) {
        ArrayList<List<? extends Cell>> allCells = new ArrayList<List<? extends Cell>>(entries.length);
        int size = 0;
        WALProtos.FamilyScope.Builder scopeBuilder = WALProtos.FamilyScope.newBuilder();
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        AdminProtos.ReplicateWALEntryRequest.Builder builder = AdminProtos.ReplicateWALEntryRequest.newBuilder();
        HBaseProtos.UUID.Builder uuidBuilder = HBaseProtos.UUID.newBuilder();
        for (WAL.Entry entry : entries) {
            entryBuilder.clear();
            WALProtos.WALKey.Builder keyBuilder = entryBuilder.getKeyBuilder();
            WALKey key = entry.getKey();
            keyBuilder.setEncodedRegionName(ByteStringer.wrap(encodedRegionName == null ? key.getEncodedRegionName() : encodedRegionName));
            keyBuilder.setTableName(ByteStringer.wrap(key.getTablename().getName()));
            keyBuilder.setLogSequenceNumber(key.getLogSeqNum());
            keyBuilder.setWriteTime(key.getWriteTime());
            if (key.getNonce() != 0L) {
                keyBuilder.setNonce(key.getNonce());
            }
            if (key.getNonceGroup() != 0L) {
                keyBuilder.setNonceGroup(key.getNonceGroup());
            }
            for (UUID clusterId : key.getClusterIds()) {
                uuidBuilder.setLeastSigBits(clusterId.getLeastSignificantBits());
                uuidBuilder.setMostSigBits(clusterId.getMostSignificantBits());
                keyBuilder.addClusterIds(uuidBuilder.build());
            }
            if (key.getOrigLogSeqNum() > 0L) {
                keyBuilder.setOrigSequenceNumber(key.getOrigLogSeqNum());
            }
            WALEdit edit = entry.getEdit();
            NavigableMap<byte[], Integer> scopes = key.getScopes();
            if (scopes != null && !scopes.isEmpty()) {
                for (Map.Entry scope : scopes.entrySet()) {
                    scopeBuilder.setFamily(ByteStringer.wrap((byte[])scope.getKey()));
                    WALProtos.ScopeType scopeType = WALProtos.ScopeType.valueOf((Integer)scope.getValue());
                    scopeBuilder.setScopeType(scopeType);
                    keyBuilder.addScopes(scopeBuilder.build());
                }
            }
            ArrayList<Cell> cells = edit.getCells();
            for (Cell cell : cells) {
                size += CellUtil.estimatedSerializedSizeOf(cell);
            }
            allCells.add(cells);
            entryBuilder.setAssociatedCellCount(cells.size());
            builder.addEntry(entryBuilder.build());
        }
        if (replicationClusterId != null) {
            builder.setReplicationClusterId(replicationClusterId);
        }
        if (sourceBaseNamespaceDir != null) {
            builder.setSourceBaseNamespaceDirPath(sourceBaseNamespaceDir.toString());
        }
        if (sourceHFileArchiveDir != null) {
            builder.setSourceHFileArchiveDirPath(sourceHFileArchiveDir.toString());
        }
        return new Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner>(builder.build(), ReplicationProtbufUtil.getCellScanner(allCells, size));
    }

    static CellScanner getCellScanner(final List<List<? extends Cell>> cells, final int size) {
        return new SizedCellScanner(){
            private final Iterator<List<? extends Cell>> entries;
            private Iterator<? extends Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = cells.iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                if (this.currentIterator == null) {
                    if (!this.entries.hasNext()) {
                        return false;
                    }
                    this.currentIterator = this.entries.next().iterator();
                }
                if (this.currentIterator.hasNext()) {
                    this.currentCell = this.currentIterator.next();
                    return true;
                }
                this.currentCell = null;
                this.currentIterator = null;
                return this.advance();
            }

            @Override
            public long heapSize() {
                return size;
            }
        };
    }
}

