/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ConstantSizeRegionSplitPolicy
extends RegionSplitPolicy {
    private static final Random RANDOM = new Random();
    private long desiredMaxFileSize;
    private double jitterRate;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        HTableDescriptor desc = region.getTableDesc();
        if (desc != null) {
            this.desiredMaxFileSize = desc.getMaxFileSize();
        }
        if (this.desiredMaxFileSize <= 0L) {
            this.desiredMaxFileSize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        }
        double jitter = conf.getDouble("hbase.hregion.max.filesize.jitter", 0.25);
        this.jitterRate = ((double)RANDOM.nextFloat() - 0.5) * jitter;
        long jitterValue = (long)((double)this.desiredMaxFileSize * this.jitterRate);
        this.desiredMaxFileSize = this.jitterRate > 0.0 && jitterValue > Long.MAX_VALUE - this.desiredMaxFileSize ? Long.MAX_VALUE : (this.desiredMaxFileSize += jitterValue);
    }

    @Override
    protected boolean shouldSplit() {
        boolean force = this.region.shouldForceSplit();
        boolean foundABigStore = false;
        for (Store store : this.region.getStores()) {
            if (!store.canSplit()) {
                return false;
            }
            if (store.getSize() <= this.desiredMaxFileSize) continue;
            foundABigStore = true;
        }
        return foundABigStore || force;
    }

    long getDesiredMaxFileSize() {
        return this.desiredMaxFileSize;
    }

    @VisibleForTesting
    public boolean positiveJitterRate() {
        return this.jitterRate > 0.0;
    }
}

