/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Predicate;

public class BulkLoadCellFilter {
    private static final Log LOG = LogFactory.getLog(BulkLoadCellFilter.class);

    public Cell filterCell(Cell cell, Predicate<byte[]> famPredicate) {
        WALProtos.BulkLoadDescriptor bld = null;
        try {
            bld = WALEdit.getBulkLoadDescriptor(cell);
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to get bulk load events information from the WAL file.", (Throwable)e);
            return cell;
        }
        List<WALProtos.StoreDescriptor> storesList = bld.getStoresList();
        ArrayList<WALProtos.StoreDescriptor> copiedStoresList = new ArrayList<WALProtos.StoreDescriptor>(storesList);
        Iterator copiedStoresListIterator = copiedStoresList.iterator();
        boolean anyStoreRemoved = false;
        while (copiedStoresListIterator.hasNext()) {
            WALProtos.StoreDescriptor sd = (WALProtos.StoreDescriptor)copiedStoresListIterator.next();
            byte[] fam = sd.getFamilyName().toByteArray();
            if (!famPredicate.apply(fam)) continue;
            copiedStoresListIterator.remove();
            anyStoreRemoved = true;
        }
        if (!anyStoreRemoved) {
            return cell;
        }
        if (copiedStoresList.isEmpty()) {
            return null;
        }
        WALProtos.BulkLoadDescriptor.Builder newDesc = WALProtos.BulkLoadDescriptor.newBuilder().setTableName(bld.getTableName()).setEncodedRegionName(bld.getEncodedRegionName()).setBulkloadSeqNum(bld.getBulkloadSeqNum());
        newDesc.addAllStores(copiedStoresList);
        WALProtos.BulkLoadDescriptor newBulkLoadDescriptor = newDesc.build();
        return CellUtil.createCell(CellUtil.cloneRow(cell), WALEdit.METAFAMILY, WALEdit.BULK_LOAD, cell.getTimestamp(), cell.getTypeByte(), newBulkLoadDescriptor.toByteArray());
    }
}

