/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.BlockReaderLocalLegacy;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.RemoteBlockReader;
import org.apache.hadoop.hdfs.RemoteBlockReader2;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.shortcircuit.DomainSocketFactory;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplicaInfo;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class BlockReaderFactory
implements ShortCircuitCache.ShortCircuitReplicaCreator {
    static final Log LOG = LogFactory.getLog(BlockReaderFactory.class);
    @VisibleForTesting
    static ShortCircuitCache.ShortCircuitReplicaCreator createShortCircuitReplicaInfoCallback = null;
    private final DFSClient.Conf conf;
    private final FailureInjector failureInjector;
    private String fileName;
    private ExtendedBlock block;
    private Token<BlockTokenIdentifier> token;
    private long startOffset;
    private boolean verifyChecksum;
    private String clientName;
    private DatanodeInfo datanode;
    private StorageType storageType;
    private boolean allowShortCircuitLocalReads;
    private ClientContext clientContext;
    private long length = -1L;
    private CachingStrategy cachingStrategy;
    private InetSocketAddress inetSocketAddress;
    private RemotePeerFactory remotePeerFactory;
    private UserGroupInformation userGroupInformation;
    private Configuration configuration;
    private DomainSocketFactory.PathInfo pathInfo;
    private int remainingCacheTries;

    public BlockReaderFactory(DFSClient.Conf conf) {
        this.conf = conf;
        this.failureInjector = conf.brfFailureInjector;
        this.remainingCacheTries = conf.nCachedConnRetry;
    }

    public BlockReaderFactory setFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public BlockReaderFactory setBlock(ExtendedBlock block) {
        this.block = block;
        return this;
    }

    public BlockReaderFactory setBlockToken(Token<BlockTokenIdentifier> token) {
        this.token = token;
        return this;
    }

    public BlockReaderFactory setStartOffset(long startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    public BlockReaderFactory setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    public BlockReaderFactory setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public BlockReaderFactory setDatanodeInfo(DatanodeInfo datanode) {
        this.datanode = datanode;
        return this;
    }

    public BlockReaderFactory setStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public BlockReaderFactory setAllowShortCircuitLocalReads(boolean allowShortCircuitLocalReads) {
        this.allowShortCircuitLocalReads = allowShortCircuitLocalReads;
        return this;
    }

    public BlockReaderFactory setClientCacheContext(ClientContext clientContext) {
        this.clientContext = clientContext;
        return this;
    }

    public BlockReaderFactory setLength(long length) {
        this.length = length;
        return this;
    }

    public BlockReaderFactory setCachingStrategy(CachingStrategy cachingStrategy) {
        this.cachingStrategy = cachingStrategy;
        return this;
    }

    public BlockReaderFactory setInetSocketAddress(InetSocketAddress inetSocketAddress) {
        this.inetSocketAddress = inetSocketAddress;
        return this;
    }

    public BlockReaderFactory setUserGroupInformation(UserGroupInformation userGroupInformation) {
        this.userGroupInformation = userGroupInformation;
        return this;
    }

    public BlockReaderFactory setRemotePeerFactory(RemotePeerFactory remotePeerFactory) {
        this.remotePeerFactory = remotePeerFactory;
        return this;
    }

    public BlockReaderFactory setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public BlockReader build() throws IOException {
        BlockReader reader = null;
        Preconditions.checkNotNull(this.configuration);
        if (this.conf.shortCircuitLocalReads && this.allowShortCircuitLocalReads) {
            if (this.clientContext.getUseLegacyBlockReaderLocal()) {
                reader = this.getLegacyBlockReaderLocal();
                if (reader != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this + ": returning new legacy block reader local."));
                    }
                    return reader;
                }
            } else {
                reader = this.getBlockReaderLocal();
                if (reader != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this + ": returning new block reader local."));
                    }
                    return reader;
                }
            }
        }
        if (this.conf.domainSocketDataTraffic && (reader = this.getRemoteBlockReaderFromDomain()) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": returning new remote block reader using " + "UNIX domain socket on " + this.pathInfo.getPath()));
            }
            return reader;
        }
        Preconditions.checkState(!DFSInputStream.tcpReadsDisabledForTesting, "TCP reads were disabled for testing, but we failed to do a non-TCP read.");
        return this.getRemoteBlockReaderFromTcp();
    }

    private BlockReader getLegacyBlockReaderLocal() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": trying to construct BlockReaderLocalLegacy"));
        }
        if (!DFSClient.isLocalAddress(this.inetSocketAddress)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": can't construct BlockReaderLocalLegacy because " + "the address " + this.inetSocketAddress + " is not local"));
            }
            return null;
        }
        if (this.clientContext.getDisableLegacyBlockReaderLocal()) {
            PerformanceAdvisory.LOG.debug(this + ": can't construct " + "BlockReaderLocalLegacy because " + "disableLegacyBlockReaderLocal is set.");
            return null;
        }
        IOException ioe = null;
        try {
            return BlockReaderLocalLegacy.newBlockReader(this.conf, this.userGroupInformation, this.configuration, this.fileName, this.block, this.token, this.datanode, this.startOffset, this.length, this.storageType);
        }
        catch (RemoteException remoteException) {
            ioe = remoteException.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
        catch (IOException e) {
            ioe = e;
        }
        if (!(ioe instanceof AccessControlException) && BlockReaderFactory.isSecurityException(ioe)) {
            throw ioe;
        }
        LOG.warn((Object)(this + ": error creating legacy BlockReaderLocal.  " + "Disabling legacy local reads."), (Throwable)ioe);
        this.clientContext.setDisableLegacyBlockReaderLocal();
        return null;
    }

    private BlockReader getBlockReaderLocal() throws SecretManager.InvalidToken {
        ExtendedBlockId key;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": trying to construct a BlockReaderLocal " + "for short-circuit reads."));
        }
        if (this.pathInfo == null) {
            this.pathInfo = this.clientContext.getDomainSocketFactory().getPathInfo(this.inetSocketAddress, this.conf);
        }
        if (!this.pathInfo.getPathState().getUsableForShortCircuit()) {
            PerformanceAdvisory.LOG.debug(this + ": " + this.pathInfo + " is not " + "usable for short circuit; giving up on BlockReaderLocal.");
            return null;
        }
        ShortCircuitCache cache = this.clientContext.getShortCircuitCache();
        ShortCircuitReplicaInfo info = cache.fetchOrCreate(key = new ExtendedBlockId(this.block.getBlockId(), this.block.getBlockPoolId()), this);
        SecretManager.InvalidToken exc = info.getInvalidTokenException();
        if (exc != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": got InvalidToken exception while trying to " + "construct BlockReaderLocal via " + this.pathInfo.getPath()));
            }
            throw exc;
        }
        if (info.getReplica() == null) {
            if (LOG.isTraceEnabled()) {
                PerformanceAdvisory.LOG.debug(this + ": failed to get " + "ShortCircuitReplica. Cannot construct " + "BlockReaderLocal via " + this.pathInfo.getPath());
            }
            return null;
        }
        return new BlockReaderLocal.Builder(this.conf).setFilename(this.fileName).setBlock(this.block).setStartOffset(this.startOffset).setShortCircuitReplica(info.getReplica()).setVerifyChecksum(this.verifyChecksum).setCachingStrategy(this.cachingStrategy).setStorageType(this.storageType).build();
    }

    @Override
    public ShortCircuitReplicaInfo createShortCircuitReplicaInfo() {
        BlockReaderPeer curPeer;
        ShortCircuitReplicaInfo info;
        if (createShortCircuitReplicaInfoCallback != null && (info = createShortCircuitReplicaInfoCallback.createShortCircuitReplicaInfo()) != null) {
            return info;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": trying to create ShortCircuitReplicaInfo."));
        }
        while ((curPeer = this.nextDomainPeer()) != null) {
            if (curPeer.fromCache) {
                --this.remainingCacheTries;
            }
            DomainPeer peer = (DomainPeer)curPeer.peer;
            ShortCircuitShm.Slot slot = null;
            ShortCircuitCache cache = this.clientContext.getShortCircuitCache();
            try {
                MutableBoolean usedPeer = new MutableBoolean(false);
                slot = cache.allocShmSlot(this.datanode, peer, usedPeer, new ExtendedBlockId(this.block.getBlockId(), this.block.getBlockPoolId()), this.clientName);
                if (usedPeer.booleanValue()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this + ": allocShmSlot used up our previous socket " + peer.getDomainSocket() + ".  Allocating a new one..."));
                    }
                    if ((curPeer = this.nextDomainPeer()) == null) break;
                    peer = (DomainPeer)curPeer.peer;
                }
                ShortCircuitReplicaInfo info2 = this.requestFileDescriptors(peer, slot);
                this.clientContext.getPeerCache().put(this.datanode, peer);
                return info2;
            }
            catch (IOException e) {
                if (slot != null) {
                    cache.freeSlot(slot);
                }
                if (curPeer.fromCache) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this + ": closing stale domain peer " + peer), (Throwable)e);
                    }
                    IOUtils.cleanup(LOG, peer);
                    continue;
                }
                LOG.warn((Object)(this + ": I/O error requesting file descriptors.  " + "Disabling domain socket " + peer.getDomainSocket()), (Throwable)e);
                IOUtils.cleanup(LOG, peer);
                this.clientContext.getDomainSocketFactory().disableDomainSocketPath(this.pathInfo.getPath());
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ShortCircuitReplicaInfo requestFileDescriptors(DomainPeer peer, ShortCircuitShm.Slot slot) throws IOException {
        ShortCircuitCache cache = this.clientContext.getShortCircuitCache();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(peer.getOutputStream()));
        ShortCircuitShm.SlotId slotId = slot == null ? null : slot.getSlotId();
        new Sender(out).requestShortCircuitFds(this.block, this.token, slotId, 1, this.failureInjector.getSupportsReceiptVerification());
        DataInputStream in = new DataInputStream(peer.getInputStream());
        DataTransferProtos.BlockOpResponseProto resp = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelper.vintPrefixed(in));
        DomainSocket sock = peer.getDomainSocket();
        this.failureInjector.injectRequestFileDescriptorsFailure();
        switch (resp.getStatus()) {
            case SUCCESS: {
                ShortCircuitReplicaInfo shortCircuitReplicaInfo;
                byte[] buf = new byte[1];
                FileInputStream[] fis = new FileInputStream[2];
                sock.recvFileInputStreams(fis, buf, 0, buf.length);
                ShortCircuitReplica replica = null;
                try {
                    ExtendedBlockId key = new ExtendedBlockId(this.block.getBlockId(), this.block.getBlockPoolId());
                    if (buf[0] == DataTransferProtos.ShortCircuitFdResponse.USE_RECEIPT_VERIFICATION.getNumber()) {
                        LOG.trace((Object)("Sending receipt verification byte for slot " + slot));
                        sock.getOutputStream().write(0);
                    }
                    replica = new ShortCircuitReplica(key, fis[0], fis[1], cache, Time.monotonicNow(), slot);
                    shortCircuitReplicaInfo = new ShortCircuitReplicaInfo(replica);
                    if (replica != null) return shortCircuitReplicaInfo;
                }
                catch (IOException e) {
                    ShortCircuitReplicaInfo shortCircuitReplicaInfo2;
                    try {
                        LOG.warn((Object)(this + ": error creating ShortCircuitReplica."), (Throwable)e);
                        shortCircuitReplicaInfo2 = null;
                        if (replica != null) return shortCircuitReplicaInfo2;
                    }
                    catch (Throwable throwable) {
                        if (replica != null) throw throwable;
                        IOUtils.cleanup(DFSClient.LOG, fis[0], fis[1]);
                        throw throwable;
                    }
                    IOUtils.cleanup(DFSClient.LOG, fis[0], fis[1]);
                    return shortCircuitReplicaInfo2;
                }
                IOUtils.cleanup(DFSClient.LOG, fis[0], fis[1]);
                return shortCircuitReplicaInfo;
            }
            case ERROR_UNSUPPORTED: {
                if (!resp.hasShortCircuitAccessVersion()) {
                    LOG.warn((Object)("short-circuit read access is disabled for DataNode " + this.datanode + ".  reason: " + resp.getMessage()));
                    this.clientContext.getDomainSocketFactory().disableShortCircuitForPath(this.pathInfo.getPath());
                    return null;
                } else {
                    LOG.warn((Object)("short-circuit read access for the file " + this.fileName + " is disabled for DataNode " + this.datanode + ".  reason: " + resp.getMessage()));
                }
                return null;
            }
            case ERROR_ACCESS_TOKEN: {
                String msg = "access control error while attempting to set up short-circuit access to " + this.fileName + resp.getMessage();
                if (!LOG.isDebugEnabled()) return new ShortCircuitReplicaInfo(new SecretManager.InvalidToken(msg));
                LOG.debug((Object)(this + ":" + msg));
                return new ShortCircuitReplicaInfo(new SecretManager.InvalidToken(msg));
            }
        }
        LOG.warn((Object)(this + ": unknown response code " + resp.getStatus() + " while attempting to set up short-circuit access. " + resp.getMessage()));
        this.clientContext.getDomainSocketFactory().disableShortCircuitForPath(this.pathInfo.getPath());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockReader getRemoteBlockReaderFromDomain() throws IOException {
        BlockReaderPeer curPeer;
        if (this.pathInfo == null) {
            this.pathInfo = this.clientContext.getDomainSocketFactory().getPathInfo(this.inetSocketAddress, this.conf);
        }
        if (!this.pathInfo.getPathState().getUsableForDataTransfer()) {
            PerformanceAdvisory.LOG.debug(this + ": not trying to create a " + "remote block reader because the UNIX domain socket at " + this.pathInfo + " is not usable.");
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": trying to create a remote block reader from the " + "UNIX domain socket at " + this.pathInfo.getPath()));
        }
        while ((curPeer = this.nextDomainPeer()) != null) {
            BlockReader blockReader;
            block14: {
                if (curPeer.fromCache) {
                    --this.remainingCacheTries;
                }
                DomainPeer peer = (DomainPeer)curPeer.peer;
                BlockReader blockReader2 = null;
                try {
                    blockReader = blockReader2 = this.getRemoteBlockReader(peer);
                    if (blockReader2 != null) break block14;
                }
                catch (IOException ioe) {
                    block15: {
                        BlockReader blockReader3;
                        block16: {
                            try {
                                IOUtils.cleanup(LOG, peer);
                                if (BlockReaderFactory.isSecurityException(ioe)) {
                                    if (LOG.isTraceEnabled()) {
                                        LOG.trace((Object)(this + ": got security exception while constructing " + "a remote block reader from the unix domain socket at " + this.pathInfo.getPath()), (Throwable)ioe);
                                    }
                                    throw ioe;
                                }
                                if (curPeer.fromCache) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Closed potentially stale domain peer " + peer), (Throwable)ioe);
                                    }
                                    break block15;
                                }
                                LOG.warn((Object)("I/O error constructing remote block reader.  Disabling domain socket " + peer.getDomainSocket()), (Throwable)ioe);
                                this.clientContext.getDomainSocketFactory().disableDomainSocketPath(this.pathInfo.getPath());
                                blockReader3 = null;
                                if (blockReader2 != null) break block16;
                            }
                            catch (Throwable throwable) {
                                if (blockReader2 == null) {
                                    IOUtils.cleanup(LOG, peer);
                                }
                                throw throwable;
                            }
                            IOUtils.cleanup(LOG, peer);
                        }
                        return blockReader3;
                    }
                    if (blockReader2 != null) continue;
                    IOUtils.cleanup(LOG, peer);
                    continue;
                }
                IOUtils.cleanup(LOG, peer);
            }
            return blockReader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockReader getRemoteBlockReaderFromTcp() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": trying to create a remote block reader from a " + "TCP socket"));
        }
        BlockReader blockReader = null;
        while (true) {
            BlockReader blockReader2;
            block13: {
                BlockReaderPeer curPeer = null;
                Peer peer = null;
                try {
                    curPeer = this.nextTcpPeer();
                    if (curPeer.fromCache) {
                        --this.remainingCacheTries;
                    }
                    peer = curPeer.peer;
                    blockReader2 = blockReader = this.getRemoteBlockReader(peer);
                    if (blockReader != null) break block13;
                }
                catch (IOException ioe) {
                    try {
                        if (BlockReaderFactory.isSecurityException(ioe)) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)(this + ": got security exception while constructing " + "a remote block reader from " + peer), (Throwable)ioe);
                            }
                            throw ioe;
                        }
                        if (curPeer != null && curPeer.fromCache) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Closed potentially stale remote peer " + peer), (Throwable)ioe);
                            }
                        } else {
                            LOG.warn((Object)"I/O error constructing remote block reader.", (Throwable)ioe);
                            throw ioe;
                        }
                        if (blockReader != null) continue;
                    }
                    catch (Throwable throwable) {
                        if (blockReader == null) {
                            IOUtils.cleanup(LOG, peer);
                        }
                        throw throwable;
                    }
                    IOUtils.cleanup(LOG, peer);
                    continue;
                }
                IOUtils.cleanup(LOG, peer);
            }
            return blockReader2;
            break;
        }
    }

    private BlockReaderPeer nextDomainPeer() {
        Peer peer;
        if (this.remainingCacheTries > 0 && (peer = this.clientContext.getPeerCache().get(this.datanode, true)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("nextDomainPeer: reusing existing peer " + peer));
            }
            return new BlockReaderPeer(peer, true);
        }
        DomainSocket sock = this.clientContext.getDomainSocketFactory().createSocket(this.pathInfo, this.conf.socketTimeout);
        if (sock == null) {
            return null;
        }
        return new BlockReaderPeer(new DomainPeer(sock), false);
    }

    private BlockReaderPeer nextTcpPeer() throws IOException {
        Peer peer;
        if (this.remainingCacheTries > 0 && (peer = this.clientContext.getPeerCache().get(this.datanode, false)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("nextTcpPeer: reusing existing peer " + peer));
            }
            return new BlockReaderPeer(peer, true);
        }
        try {
            peer = this.remotePeerFactory.newConnectedPeer(this.inetSocketAddress, this.token, this.datanode);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("nextTcpPeer: created newConnectedPeer " + peer));
            }
            return new BlockReaderPeer(peer, false);
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("nextTcpPeer: failed to create newConnectedPeer connected to " + this.datanode));
            }
            throw e;
        }
    }

    private static boolean isSecurityException(IOException ioe) {
        return ioe instanceof SecretManager.InvalidToken || ioe instanceof InvalidEncryptionKeyException || ioe instanceof InvalidBlockTokenException || ioe instanceof AccessControlException;
    }

    private BlockReader getRemoteBlockReader(Peer peer) throws IOException {
        if (this.conf.useLegacyBlockReader) {
            return RemoteBlockReader.newBlockReader(this.fileName, this.block, this.token, this.startOffset, this.length, this.conf.ioBufferSize, this.verifyChecksum, this.clientName, peer, this.datanode, this.clientContext.getPeerCache(), this.cachingStrategy);
        }
        return RemoteBlockReader2.newBlockReader(this.fileName, this.block, this.token, this.startOffset, this.length, this.verifyChecksum, this.clientName, peer, this.datanode, this.clientContext.getPeerCache(), this.cachingStrategy);
    }

    public String toString() {
        return "BlockReaderFactory(fileName=" + this.fileName + ", block=" + this.block + ")";
    }

    public static String getFileName(InetSocketAddress s, String poolId, long blockId) {
        return s.toString() + ":" + poolId + ":" + blockId;
    }

    public static class BlockReaderPeer {
        final Peer peer;
        final boolean fromCache;

        BlockReaderPeer(Peer peer, boolean fromCache) {
            this.peer = peer;
            this.fromCache = fromCache;
        }
    }

    public static class FailureInjector {
        public void injectRequestFileDescriptorsFailure() throws IOException {
        }

        public boolean getSupportsReceiptVerification() {
            return true;
        }
    }
}

