/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class HAUtil {
    private static final Log LOG = LogFactory.getLog(HAUtil.class);
    private static final DelegationTokenSelector tokenSelector = new DelegationTokenSelector();

    private HAUtil() {
    }

    public static boolean isHAEnabled(Configuration conf, String nsId) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        if (addresses == null) {
            return false;
        }
        Map<String, InetSocketAddress> nnMap = addresses.get(nsId);
        return nnMap != null && nnMap.size() > 1;
    }

    public static boolean usesSharedEditsDir(Configuration conf) {
        return null != conf.get("dfs.namenode.shared.edits.dir");
    }

    public static String getNameNodeId(Configuration conf, String nsId) {
        String namenodeId = conf.getTrimmed("dfs.ha.namenode.id");
        if (namenodeId != null) {
            return namenodeId;
        }
        String[] suffixes = DFSUtil.getSuffixIDs(conf, "dfs.namenode.rpc-address", nsId, null, DFSUtil.LOCAL_ADDRESS_MATCHER);
        if (suffixes == null) {
            String msg = "Configuration dfs.namenode.rpc-address must be suffixed with nameservice and namenode ID for HA configuration.";
            throw new HadoopIllegalArgumentException(msg);
        }
        return suffixes[1];
    }

    public static String getNameNodeIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        if (ids != null && ids.length > 1) {
            return ids[1];
        }
        return null;
    }

    public static String getNameNodeIdOfOtherNode(Configuration conf, String nsId) {
        Preconditions.checkArgument(nsId != null, "Could not determine namespace id. Please ensure that this machine is one of the machines listed as a NN RPC address, or configure dfs.nameservice.id");
        Collection<String> nnIds = DFSUtil.getNameNodeIds(conf, nsId);
        String myNNId = conf.get("dfs.ha.namenode.id");
        Preconditions.checkArgument(nnIds != null, "Could not determine namenode ids in namespace '%s'. Please configure " + DFSUtil.addKeySuffixes("dfs.ha.namenodes", nsId), nsId);
        Preconditions.checkArgument(nnIds.size() == 2, "Expected exactly 2 NameNodes in namespace '%s'. Instead, got only %s (NN ids were '%s'", nsId, nnIds.size(), Joiner.on("','").join(nnIds));
        Preconditions.checkState(myNNId != null && !myNNId.isEmpty(), "Could not determine own NN ID in namespace '%s'. Please ensure that this node is one of the machines listed as an NN RPC address, or configure dfs.ha.namenode.id", nsId);
        ArrayList<String> nnSet = Lists.newArrayList(nnIds);
        nnSet.remove(myNNId);
        assert (nnSet.size() == 1);
        return nnSet.get(0);
    }

    public static Configuration getConfForOtherNode(Configuration myConf) {
        String nsId = DFSUtil.getNamenodeNameServiceId(myConf);
        String otherNn = HAUtil.getNameNodeIdOfOtherNode(myConf, nsId);
        Configuration confForOtherNode = new Configuration(myConf);
        NameNode.initializeGenericKeys(confForOtherNode, nsId, otherNn);
        return confForOtherNode;
    }

    public static boolean shouldAllowStandbyReads(Configuration conf) {
        return conf.getBoolean("dfs.ha.allow.stale.reads", false);
    }

    public static void setAllowStandbyReads(Configuration conf, boolean val) {
        conf.setBoolean("dfs.ha.allow.stale.reads", val);
    }

    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        return DFSUtil.getNameServiceIds(conf).contains(host);
    }

    public static boolean isClientFailoverConfigured(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static boolean useLogicalUri(Configuration conf, URI nameNodeUri) throws IOException {
        AbstractNNFailoverProxyProvider<ClientProtocol> provider = NameNodeProxies.createFailoverProxyProvider(conf, nameNodeUri, ClientProtocol.class, false, null);
        if (provider == null) {
            return false;
        }
        return provider.useLogicalURI();
    }

    public static URI getServiceUriFromToken(String scheme, Token<?> token) {
        String prefix;
        String tokStr = token.getService().toString();
        if (tokStr.startsWith(prefix = HAUtil.buildTokenServicePrefixForLogicalUri(scheme))) {
            tokStr = tokStr.replaceFirst(prefix, "");
        }
        return URI.create(scheme + "://" + tokStr);
    }

    public static Text buildTokenServiceForLogicalUri(URI uri, String scheme) {
        return new Text(HAUtil.buildTokenServicePrefixForLogicalUri(scheme) + uri.getHost());
    }

    public static boolean isTokenForLogicalUri(Token<?> token) {
        return token.getService().toString().startsWith("ha-");
    }

    public static String buildTokenServicePrefixForLogicalUri(String scheme) {
        return "ha-" + scheme + ":";
    }

    public static void cloneDelegationTokenForLogicalUri(UserGroupInformation ugi, URI haUri, Collection<InetSocketAddress> nnAddrs) {
        Text haService = HAUtil.buildTokenServiceForLogicalUri(haUri, "hdfs");
        Token haToken = tokenSelector.selectToken(haService, ugi.getTokens());
        if (haToken != null) {
            for (InetSocketAddress singleNNAddr : nnAddrs) {
                Token.PrivateToken specificToken = new Token.PrivateToken(haToken);
                SecurityUtil.setTokenService(specificToken, singleNNAddr);
                Text alias = new Text(HAUtil.buildTokenServicePrefixForLogicalUri("hdfs") + "//" + specificToken.getService());
                ugi.addToken(alias, specificToken);
                LOG.debug((Object)("Mapped HA service delegation token for logical URI " + haUri + " to namenode " + singleNNAddr));
            }
        } else {
            LOG.debug((Object)("No HA service delegation token found for logical URI " + haUri));
        }
    }

    public static InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs + " is not a DFS.");
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress(dfsClient.getNamenode());
    }

    public static List<ClientProtocol> getProxiesForAllNameNodesInNameservice(Configuration conf, String nsId) throws IOException {
        List<NameNodeProxies.ProxyAndInfo<ClientProtocol>> proxies = HAUtil.getProxiesForAllNameNodesInNameservice(conf, nsId, ClientProtocol.class);
        ArrayList<ClientProtocol> namenodes = new ArrayList<ClientProtocol>(proxies.size());
        for (NameNodeProxies.ProxyAndInfo<ClientProtocol> proxy : proxies) {
            namenodes.add(proxy.getProxy());
        }
        return namenodes;
    }

    public static <T> List<NameNodeProxies.ProxyAndInfo<T>> getProxiesForAllNameNodesInNameservice(Configuration conf, String nsId, Class<T> xface) throws IOException {
        Map<String, InetSocketAddress> nnAddresses = DFSUtil.getRpcAddressesForNameserviceId(conf, nsId, null);
        ArrayList<NameNodeProxies.ProxyAndInfo<T>> proxies = new ArrayList<NameNodeProxies.ProxyAndInfo<T>>(nnAddresses.size());
        for (InetSocketAddress nnAddress : nnAddresses.values()) {
            NameNodeProxies.ProxyAndInfo<T> proxyInfo = null;
            proxyInfo = NameNodeProxies.createNonHAProxy(conf, nnAddress, xface, UserGroupInformation.getCurrentUser(), false);
            proxies.add(proxyInfo);
        }
        return proxies;
    }

    public static boolean isAtLeastOneActive(List<ClientProtocol> namenodes) throws IOException {
        for (ClientProtocol namenode : namenodes) {
            try {
                namenode.getFileInfo("/");
                return true;
            }
            catch (RemoteException re) {
                IOException cause = re.unwrapRemoteException();
                if (cause instanceof StandbyException) continue;
                throw re;
            }
        }
        return false;
    }
}

