/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.util.ToolRunner;

public class DFSHAAdmin
extends HAAdmin {
    private static final Log LOG = LogFactory.getLog(DFSHAAdmin.class);
    private String nameserviceId;

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected void setOut(PrintStream out) {
        this.out = out;
    }

    @Override
    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = DFSHAAdmin.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    public static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new HdfsConfiguration(conf);
        String nameNodePrincipal = conf.get("dfs.namenode.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using NN principal: " + nameNodePrincipal));
        }
        conf.set("hadoop.security.service.user.name.key", nameNodePrincipal);
        return conf;
    }

    @Override
    protected HAServiceTarget resolveTarget(String nnId) {
        HdfsConfiguration conf = (HdfsConfiguration)this.getConf();
        return new NNHAServiceTarget(conf, this.nameserviceId, nnId);
    }

    @Override
    protected String getUsageString() {
        return "Usage: haadmin";
    }

    @Override
    protected int runCmd(String[] argv) throws Exception {
        String cmd;
        if (argv.length < 1) {
            this.printUsage(this.errOut);
            return -1;
        }
        int i = 0;
        if ("-ns".equals(cmd = argv[i++])) {
            if (i == argv.length) {
                this.errOut.println("Missing nameservice ID");
                this.printUsage(this.errOut);
                return -1;
            }
            this.nameserviceId = argv[i++];
            if (i >= argv.length) {
                this.errOut.println("Missing command");
                this.printUsage(this.errOut);
                return -1;
            }
            argv = Arrays.copyOfRange(argv, i, argv.length);
        }
        return super.runCmd(argv);
    }

    @Override
    protected Collection<String> getTargetIds(String namenodeToActivate) {
        return DFSUtil.getNameNodeIds(this.getConf(), this.nameserviceId != null ? this.nameserviceId : DFSUtil.getNamenodeNameServiceId(this.getConf()));
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new DFSHAAdmin(), argv);
        System.exit(res);
    }
}

