/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.speculate;

import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.speculate.Speculator;
import org.apache.hadoop.yarn.event.AbstractEvent;

public class SpeculatorEvent
extends AbstractEvent<Speculator.EventType> {
    private TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus;
    private TaskId taskID;
    private int containersNeededChange;
    private JobId jobID;

    public SpeculatorEvent(JobId jobID, long timestamp) {
        super(Speculator.EventType.JOB_CREATE, timestamp);
        this.jobID = jobID;
    }

    public SpeculatorEvent(TaskAttemptStatusUpdateEvent.TaskAttemptStatus reportedStatus, long timestamp) {
        super(Speculator.EventType.ATTEMPT_STATUS_UPDATE, timestamp);
        this.reportedStatus = reportedStatus;
    }

    public SpeculatorEvent(TaskAttemptId attemptID, boolean flag, long timestamp) {
        super(Speculator.EventType.ATTEMPT_START, timestamp);
        this.reportedStatus = new TaskAttemptStatusUpdateEvent.TaskAttemptStatus();
        this.reportedStatus.id = attemptID;
        this.taskID = attemptID.getTaskId();
    }

    public SpeculatorEvent(TaskId taskID, int containersNeededChange) {
        super(Speculator.EventType.TASK_CONTAINER_NEED_UPDATE);
        this.taskID = taskID;
        this.containersNeededChange = containersNeededChange;
    }

    public TaskAttemptStatusUpdateEvent.TaskAttemptStatus getReportedStatus() {
        return this.reportedStatus;
    }

    public int containersNeededChange() {
        return this.containersNeededChange;
    }

    public TaskId getTaskID() {
        return this.taskID;
    }

    public JobId getJobID() {
        return this.jobID;
    }
}

