/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Map;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceImpl;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExecutorStatusChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckChore.class);
    public static final String WAKE_FREQ = "hbase.executors.status.collect.period";
    public static final int DEFAULT_WAKE_FREQ = 60000;
    private ExecutorService service;
    private DynamicMetricsRegistry metricsRegistry;

    public ExecutorStatusChore(int sleepTime, Stoppable stopper, ExecutorService service, MetricsRegionServerSource metrics) {
        super("ExecutorStatusChore", stopper, sleepTime);
        LOG.info("ExecutorStatusChore runs every {} ", (Object)StringUtils.formatTime(sleepTime));
        this.service = service;
        this.metricsRegistry = ((MetricsRegionServerSourceImpl)metrics).getMetricsRegistry();
    }

    @Override
    protected void chore() {
        try {
            Map<String, ExecutorService.ExecutorStatus> statuses = this.service.getAllExecutorStatuses();
            for (Map.Entry<String, ExecutorService.ExecutorStatus> statusEntry : statuses.entrySet()) {
                String name = statusEntry.getKey();
                String poolName = name.split("-")[0];
                ExecutorService.ExecutorStatus status = statusEntry.getValue();
                MutableGaugeLong queued = this.metricsRegistry.getGauge(poolName + "_queued", 0L);
                MutableGaugeLong running = this.metricsRegistry.getGauge(poolName + "_running", 0L);
                int queueSize = status.getQueuedEvents().size();
                int runningSize = status.getRunning().size();
                if (queueSize > 0) {
                    LOG.warn("{}'s size info, queued: {}, running: {}", new Object[]{poolName, queueSize, runningSize});
                }
                queued.set(queueSize);
                running.set(runningSize);
            }
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public Pair<Long, Long> getExecutorStatus(String poolName) {
        MutableGaugeLong running = this.metricsRegistry.getGauge(poolName + "_running", 0L);
        MutableGaugeLong queued = this.metricsRegistry.getGauge(poolName + "_queued", 0L);
        return new Pair<Long, Long>(running.value(), queued.value());
    }
}

